<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getProductsOffer StructType
 * Meta information extracted from the WSDL
 * - type: tns:getProductsOffer
 * @subpackage Structs
 */
class GetProductsOffer extends AbstractStructBase
{
    /**
     * The uniqueId
     * @var string
     */
    public $uniqueId;
    /**
     * The startDate
     * @var string
     */
    public $startDate;
    /**
     * The insuredDays
     * @var int
     */
    public $insuredDays;
    /**
     * The region
     * @var string
     */
    public $region;
    /**
     * The insuredsCount
     * @var int
     */
    public $insuredsCount;
    /**
     * The tariffType
     * @var string
     */
    public $tariffType;
    /**
     * The cancellationAmount
     * @var float
     */
    public $cancellationAmount;
    /**
     * The currency
     * @var string
     */
    public $currency;
    /**
     * The language
     * @var string
     */
    public $language;
    /**
     * Constructor method for getProductsOffer
     * @uses GetProductsOffer::setUniqueId()
     * @uses GetProductsOffer::setStartDate()
     * @uses GetProductsOffer::setInsuredDays()
     * @uses GetProductsOffer::setRegion()
     * @uses GetProductsOffer::setInsuredsCount()
     * @uses GetProductsOffer::setTariffType()
     * @uses GetProductsOffer::setCancellationAmount()
     * @uses GetProductsOffer::setCurrency()
     * @uses GetProductsOffer::setLanguage()
     * @param string $uniqueId
     * @param string $startDate
     * @param int $insuredDays
     * @param string $region
     * @param int $insuredsCount
     * @param string $tariffType
     * @param float $cancellationAmount
     * @param string $currency
     * @param string $language
     */
    public function __construct($uniqueId = null, $startDate = null, $insuredDays = null, $region = null, $insuredsCount = null, $tariffType = null, $cancellationAmount = null, $currency = null, $language = null)
    {
        $this
            ->setUniqueId($uniqueId)
            ->setStartDate($startDate)
            ->setInsuredDays($insuredDays)
            ->setRegion($region)
            ->setInsuredsCount($insuredsCount)
            ->setTariffType($tariffType)
            ->setCancellationAmount($cancellationAmount)
            ->setCurrency($currency)
            ->setLanguage($language);
    }
    /**
     * Get uniqueId value
     * @return string|null
     */
    public function getUniqueId()
    {
        return $this->uniqueId;
    }
    /**
     * Set uniqueId value
     * @param string $uniqueId
     * @return \StructType\GetProductsOffer
     */
    public function setUniqueId($uniqueId = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueId) && !is_string($uniqueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uniqueId, true), gettype($uniqueId)), __LINE__);
        }
        $this->uniqueId = $uniqueId;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\GetProductsOffer
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get insuredDays value
     * @return int|null
     */
    public function getInsuredDays()
    {
        return $this->insuredDays;
    }
    /**
     * Set insuredDays value
     * @param int $insuredDays
     * @return \StructType\GetProductsOffer
     */
    public function setInsuredDays($insuredDays = null)
    {
        // validation for constraint: int
        if (!is_null($insuredDays) && !(is_int($insuredDays) || ctype_digit($insuredDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($insuredDays, true), gettype($insuredDays)), __LINE__);
        }
        $this->insuredDays = $insuredDays;
        return $this;
    }
    /**
     * Get region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->region;
    }
    /**
     * Set region value
     * @param string $region
     * @return \StructType\GetProductsOffer
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($region, true), gettype($region)), __LINE__);
        }
        $this->region = $region;
        return $this;
    }
    /**
     * Get insuredsCount value
     * @return int|null
     */
    public function getInsuredsCount()
    {
        return $this->insuredsCount;
    }
    /**
     * Set insuredsCount value
     * @param int $insuredsCount
     * @return \StructType\GetProductsOffer
     */
    public function setInsuredsCount($insuredsCount = null)
    {
        // validation for constraint: int
        if (!is_null($insuredsCount) && !(is_int($insuredsCount) || ctype_digit($insuredsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($insuredsCount, true), gettype($insuredsCount)), __LINE__);
        }
        $this->insuredsCount = $insuredsCount;
        return $this;
    }
    /**
     * Get tariffType value
     * @return string|null
     */
    public function getTariffType()
    {
        return $this->tariffType;
    }
    /**
     * Set tariffType value
     * @param string $tariffType
     * @return \StructType\GetProductsOffer
     */
    public function setTariffType($tariffType = null)
    {
        // validation for constraint: string
        if (!is_null($tariffType) && !is_string($tariffType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariffType, true), gettype($tariffType)), __LINE__);
        }
        $this->tariffType = $tariffType;
        return $this;
    }
    /**
     * Get cancellationAmount value
     * @return float|null
     */
    public function getCancellationAmount()
    {
        return $this->cancellationAmount;
    }
    /**
     * Set cancellationAmount value
     * @param float $cancellationAmount
     * @return \StructType\GetProductsOffer
     */
    public function setCancellationAmount($cancellationAmount = null)
    {
        // validation for constraint: float
        if (!is_null($cancellationAmount) && !(is_float($cancellationAmount) || is_numeric($cancellationAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cancellationAmount, true), gettype($cancellationAmount)), __LINE__);
        }
        $this->cancellationAmount = $cancellationAmount;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\GetProductsOffer
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\GetProductsOffer
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetProductsOffer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
