<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cancelPolicy StructType
 * Meta information extracted from the WSDL
 * - type: tns:cancelPolicy
 * @subpackage Structs
 */
class CancelPolicy extends AbstractStructBase
{
    /**
     * The uniqueId
     * @var string
     */
    public $uniqueId;
    /**
     * The policyNumber
     * @var int
     */
    public $policyNumber;
    /**
     * The currency
     * @var string
     */
    public $currency;
    /**
     * Constructor method for cancelPolicy
     * @uses CancelPolicy::setUniqueId()
     * @uses CancelPolicy::setPolicyNumber()
     * @uses CancelPolicy::setCurrency()
     * @param string $uniqueId
     * @param int $policyNumber
     * @param string $currency
     */
    public function __construct($uniqueId = null, $policyNumber = null, $currency = null)
    {
        $this
            ->setUniqueId($uniqueId)
            ->setPolicyNumber($policyNumber)
            ->setCurrency($currency);
    }
    /**
     * Get uniqueId value
     * @return string|null
     */
    public function getUniqueId()
    {
        return $this->uniqueId;
    }
    /**
     * Set uniqueId value
     * @param string $uniqueId
     * @return \StructType\CancelPolicy
     */
    public function setUniqueId($uniqueId = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueId) && !is_string($uniqueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uniqueId, true), gettype($uniqueId)), __LINE__);
        }
        $this->uniqueId = $uniqueId;
        return $this;
    }
    /**
     * Get policyNumber value
     * @return int|null
     */
    public function getPolicyNumber()
    {
        return $this->policyNumber;
    }
    /**
     * Set policyNumber value
     * @param int $policyNumber
     * @return \StructType\CancelPolicy
     */
    public function setPolicyNumber($policyNumber = null)
    {
        // validation for constraint: int
        if (!is_null($policyNumber) && !(is_int($policyNumber) || ctype_digit($policyNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($policyNumber, true), gettype($policyNumber)), __LINE__);
        }
        $this->policyNumber = $policyNumber;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\CancelPolicy
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CancelPolicy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
