<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for userLogin StructType
 * Meta information extracted from the WSDL
 * - type: tns:userLogin
 * @subpackage Structs
 */
class UserLogin extends AbstractStructBase
{
    /**
     * The agentCode
     * @var string
     */
    public $agentCode;
    /**
     * The userName
     * @var string
     */
    public $userName;
    /**
     * The userPasswd
     * @var string
     */
    public $userPasswd;
    /**
     * Constructor method for userLogin
     * @uses UserLogin::setAgentCode()
     * @uses UserLogin::setUserName()
     * @uses UserLogin::setUserPasswd()
     * @param string $agentCode
     * @param string $userName
     * @param string $userPasswd
     */
    public function __construct($agentCode = null, $userName = null, $userPasswd = null)
    {
        $this
            ->setAgentCode($agentCode)
            ->setUserName($userName)
            ->setUserPasswd($userPasswd);
    }
    /**
     * Get agentCode value
     * @return string|null
     */
    public function getAgentCode()
    {
        return $this->agentCode;
    }
    /**
     * Set agentCode value
     * @param string $agentCode
     * @return \StructType\UserLogin
     */
    public function setAgentCode($agentCode = null)
    {
        // validation for constraint: string
        if (!is_null($agentCode) && !is_string($agentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentCode, true), gettype($agentCode)), __LINE__);
        }
        $this->agentCode = $agentCode;
        return $this;
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \StructType\UserLogin
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get userPasswd value
     * @return string|null
     */
    public function getUserPasswd()
    {
        return $this->userPasswd;
    }
    /**
     * Set userPasswd value
     * @param string $userPasswd
     * @return \StructType\UserLogin
     */
    public function setUserPasswd($userPasswd = null)
    {
        // validation for constraint: string
        if (!is_null($userPasswd) && !is_string($userPasswd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userPasswd, true), gettype($userPasswd)), __LINE__);
        }
        $this->userPasswd = $userPasswd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserLogin
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
