<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for documentData StructType
 * @subpackage Structs
 */
class DocumentData extends AbstractStructBase
{
    /**
     * The fileContents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fileContents;
    /**
     * The fileName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fileName;
    /**
     * The fileSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $fileSize;
    /**
     * The mimeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mimeType;
    /**
     * Constructor method for documentData
     * @uses DocumentData::setFileContents()
     * @uses DocumentData::setFileName()
     * @uses DocumentData::setFileSize()
     * @uses DocumentData::setMimeType()
     * @param string $fileContents
     * @param string $fileName
     * @param int $fileSize
     * @param string $mimeType
     */
    public function __construct($fileContents = null, $fileName = null, $fileSize = null, $mimeType = null)
    {
        $this
            ->setFileContents($fileContents)
            ->setFileName($fileName)
            ->setFileSize($fileSize)
            ->setMimeType($mimeType);
    }
    /**
     * Get fileContents value
     * @return string|null
     */
    public function getFileContents()
    {
        return $this->fileContents;
    }
    /**
     * Set fileContents value
     * @param string $fileContents
     * @return \StructType\DocumentData
     */
    public function setFileContents($fileContents = null)
    {
        // validation for constraint: string
        if (!is_null($fileContents) && !is_string($fileContents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileContents, true), gettype($fileContents)), __LINE__);
        }
        $this->fileContents = $fileContents;
        return $this;
    }
    /**
     * Get fileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->fileName;
    }
    /**
     * Set fileName value
     * @param string $fileName
     * @return \StructType\DocumentData
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        $this->fileName = $fileName;
        return $this;
    }
    /**
     * Get fileSize value
     * @return int|null
     */
    public function getFileSize()
    {
        return $this->fileSize;
    }
    /**
     * Set fileSize value
     * @param int $fileSize
     * @return \StructType\DocumentData
     */
    public function setFileSize($fileSize = null)
    {
        // validation for constraint: int
        if (!is_null($fileSize) && !(is_int($fileSize) || ctype_digit($fileSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fileSize, true), gettype($fileSize)), __LINE__);
        }
        $this->fileSize = $fileSize;
        return $this;
    }
    /**
     * Get mimeType value
     * @return string|null
     */
    public function getMimeType()
    {
        return $this->mimeType;
    }
    /**
     * Set mimeType value
     * @param string $mimeType
     * @return \StructType\DocumentData
     */
    public function setMimeType($mimeType = null)
    {
        // validation for constraint: string
        if (!is_null($mimeType) && !is_string($mimeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mimeType, true), gettype($mimeType)), __LINE__);
        }
        $this->mimeType = $mimeType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocumentData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
