<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for supplementaries StructType
 * @subpackage Structs
 */
class Supplementaries extends AbstractStructBase
{
    /**
     * The supplementary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $supplementary;
    /**
     * Constructor method for supplementaries
     * @uses Supplementaries::setSupplementary()
     * @param string[] $supplementary
     */
    public function __construct(array $supplementary = array())
    {
        $this
            ->setSupplementary($supplementary);
    }
    /**
     * Get supplementary value
     * @return string[]|null
     */
    public function getSupplementary()
    {
        return $this->supplementary;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplementary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplementary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplementaryForArrayConstraintsFromSetSupplementary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplementariesSupplementaryItem) {
            // validation for constraint: itemType
            if (!is_string($supplementariesSupplementaryItem)) {
                $invalidValues[] = is_object($supplementariesSupplementaryItem) ? get_class($supplementariesSupplementaryItem) : sprintf('%s(%s)', gettype($supplementariesSupplementaryItem), var_export($supplementariesSupplementaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The supplementary property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set supplementary value
     * @throws \InvalidArgumentException
     * @param string[] $supplementary
     * @return \StructType\Supplementaries
     */
    public function setSupplementary(array $supplementary = array())
    {
        // validation for constraint: array
        if ('' !== ($supplementaryArrayErrorMessage = self::validateSupplementaryForArrayConstraintsFromSetSupplementary($supplementary))) {
            throw new \InvalidArgumentException($supplementaryArrayErrorMessage, __LINE__);
        }
        $this->supplementary = $supplementary;
        return $this;
    }
    /**
     * Add item to supplementary value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Supplementaries
     */
    public function addToSupplementary($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The supplementary property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->supplementary[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Supplementaries
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
