<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SuitableTariff StructType
 * @subpackage Structs
 */
class SuitableTariff extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $code;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The regionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $regionCode;
    /**
     * The tariffSubject
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tariffSubject;
    /**
     * The calcType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $calcType;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $price;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The childAge
     * @var int
     */
    public $childAge;
    /**
     * The maxAdult
     * @var int
     */
    public $maxAdult;
    /**
     * The maxAge
     * @var int
     */
    public $maxAge;
    /**
     * The maxChildren
     * @var int
     */
    public $maxChildren;
    /**
     * The maxDays
     * @var int
     */
    public $maxDays;
    /**
     * The maxPersons
     * @var int
     */
    public $maxPersons;
    /**
     * The minAdult
     * @var int
     */
    public $minAdult;
    /**
     * The minAge
     * @var int
     */
    public $minAge;
    /**
     * The minChildren
     * @var int
     */
    public $minChildren;
    /**
     * The minDays
     * @var int
     */
    public $minDays;
    /**
     * Constructor method for SuitableTariff
     * @uses SuitableTariff::setCode()
     * @uses SuitableTariff::setName()
     * @uses SuitableTariff::setDescription()
     * @uses SuitableTariff::setRegionCode()
     * @uses SuitableTariff::setTariffSubject()
     * @uses SuitableTariff::setCalcType()
     * @uses SuitableTariff::setPrice()
     * @uses SuitableTariff::setCurrency()
     * @uses SuitableTariff::setChildAge()
     * @uses SuitableTariff::setMaxAdult()
     * @uses SuitableTariff::setMaxAge()
     * @uses SuitableTariff::setMaxChildren()
     * @uses SuitableTariff::setMaxDays()
     * @uses SuitableTariff::setMaxPersons()
     * @uses SuitableTariff::setMinAdult()
     * @uses SuitableTariff::setMinAge()
     * @uses SuitableTariff::setMinChildren()
     * @uses SuitableTariff::setMinDays()
     * @param string $code
     * @param string $name
     * @param string $description
     * @param string $regionCode
     * @param string $tariffSubject
     * @param string $calcType
     * @param float $price
     * @param string $currency
     * @param int $childAge
     * @param int $maxAdult
     * @param int $maxAge
     * @param int $maxChildren
     * @param int $maxDays
     * @param int $maxPersons
     * @param int $minAdult
     * @param int $minAge
     * @param int $minChildren
     * @param int $minDays
     */
    public function __construct($code = null, $name = null, $description = null, $regionCode = null, $tariffSubject = null, $calcType = null, $price = null, $currency = null, $childAge = null, $maxAdult = null, $maxAge = null, $maxChildren = null, $maxDays = null, $maxPersons = null, $minAdult = null, $minAge = null, $minChildren = null, $minDays = null)
    {
        $this
            ->setCode($code)
            ->setName($name)
            ->setDescription($description)
            ->setRegionCode($regionCode)
            ->setTariffSubject($tariffSubject)
            ->setCalcType($calcType)
            ->setPrice($price)
            ->setCurrency($currency)
            ->setChildAge($childAge)
            ->setMaxAdult($maxAdult)
            ->setMaxAge($maxAge)
            ->setMaxChildren($maxChildren)
            ->setMaxDays($maxDays)
            ->setMaxPersons($maxPersons)
            ->setMinAdult($minAdult)
            ->setMinAge($minAge)
            ->setMinChildren($minChildren)
            ->setMinDays($minDays);
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\SuitableTariff
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\SuitableTariff
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\SuitableTariff
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get regionCode value
     * @return string|null
     */
    public function getRegionCode()
    {
        return $this->regionCode;
    }
    /**
     * Set regionCode value
     * @param string $regionCode
     * @return \StructType\SuitableTariff
     */
    public function setRegionCode($regionCode = null)
    {
        // validation for constraint: string
        if (!is_null($regionCode) && !is_string($regionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regionCode, true), gettype($regionCode)), __LINE__);
        }
        $this->regionCode = $regionCode;
        return $this;
    }
    /**
     * Get tariffSubject value
     * @return string|null
     */
    public function getTariffSubject()
    {
        return $this->tariffSubject;
    }
    /**
     * Set tariffSubject value
     * @param string $tariffSubject
     * @return \StructType\SuitableTariff
     */
    public function setTariffSubject($tariffSubject = null)
    {
        // validation for constraint: string
        if (!is_null($tariffSubject) && !is_string($tariffSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariffSubject, true), gettype($tariffSubject)), __LINE__);
        }
        $this->tariffSubject = $tariffSubject;
        return $this;
    }
    /**
     * Get calcType value
     * @return string|null
     */
    public function getCalcType()
    {
        return $this->calcType;
    }
    /**
     * Set calcType value
     * @param string $calcType
     * @return \StructType\SuitableTariff
     */
    public function setCalcType($calcType = null)
    {
        // validation for constraint: string
        if (!is_null($calcType) && !is_string($calcType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calcType, true), gettype($calcType)), __LINE__);
        }
        $this->calcType = $calcType;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\SuitableTariff
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\SuitableTariff
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get childAge value
     * @return int|null
     */
    public function getChildAge()
    {
        return $this->childAge;
    }
    /**
     * Set childAge value
     * @param int $childAge
     * @return \StructType\SuitableTariff
     */
    public function setChildAge($childAge = null)
    {
        // validation for constraint: int
        if (!is_null($childAge) && !(is_int($childAge) || ctype_digit($childAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($childAge, true), gettype($childAge)), __LINE__);
        }
        $this->childAge = $childAge;
        return $this;
    }
    /**
     * Get maxAdult value
     * @return int|null
     */
    public function getMaxAdult()
    {
        return $this->maxAdult;
    }
    /**
     * Set maxAdult value
     * @param int $maxAdult
     * @return \StructType\SuitableTariff
     */
    public function setMaxAdult($maxAdult = null)
    {
        // validation for constraint: int
        if (!is_null($maxAdult) && !(is_int($maxAdult) || ctype_digit($maxAdult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAdult, true), gettype($maxAdult)), __LINE__);
        }
        $this->maxAdult = $maxAdult;
        return $this;
    }
    /**
     * Get maxAge value
     * @return int|null
     */
    public function getMaxAge()
    {
        return $this->maxAge;
    }
    /**
     * Set maxAge value
     * @param int $maxAge
     * @return \StructType\SuitableTariff
     */
    public function setMaxAge($maxAge = null)
    {
        // validation for constraint: int
        if (!is_null($maxAge) && !(is_int($maxAge) || ctype_digit($maxAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAge, true), gettype($maxAge)), __LINE__);
        }
        $this->maxAge = $maxAge;
        return $this;
    }
    /**
     * Get maxChildren value
     * @return int|null
     */
    public function getMaxChildren()
    {
        return $this->maxChildren;
    }
    /**
     * Set maxChildren value
     * @param int $maxChildren
     * @return \StructType\SuitableTariff
     */
    public function setMaxChildren($maxChildren = null)
    {
        // validation for constraint: int
        if (!is_null($maxChildren) && !(is_int($maxChildren) || ctype_digit($maxChildren))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxChildren, true), gettype($maxChildren)), __LINE__);
        }
        $this->maxChildren = $maxChildren;
        return $this;
    }
    /**
     * Get maxDays value
     * @return int|null
     */
    public function getMaxDays()
    {
        return $this->maxDays;
    }
    /**
     * Set maxDays value
     * @param int $maxDays
     * @return \StructType\SuitableTariff
     */
    public function setMaxDays($maxDays = null)
    {
        // validation for constraint: int
        if (!is_null($maxDays) && !(is_int($maxDays) || ctype_digit($maxDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxDays, true), gettype($maxDays)), __LINE__);
        }
        $this->maxDays = $maxDays;
        return $this;
    }
    /**
     * Get maxPersons value
     * @return int|null
     */
    public function getMaxPersons()
    {
        return $this->maxPersons;
    }
    /**
     * Set maxPersons value
     * @param int $maxPersons
     * @return \StructType\SuitableTariff
     */
    public function setMaxPersons($maxPersons = null)
    {
        // validation for constraint: int
        if (!is_null($maxPersons) && !(is_int($maxPersons) || ctype_digit($maxPersons))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxPersons, true), gettype($maxPersons)), __LINE__);
        }
        $this->maxPersons = $maxPersons;
        return $this;
    }
    /**
     * Get minAdult value
     * @return int|null
     */
    public function getMinAdult()
    {
        return $this->minAdult;
    }
    /**
     * Set minAdult value
     * @param int $minAdult
     * @return \StructType\SuitableTariff
     */
    public function setMinAdult($minAdult = null)
    {
        // validation for constraint: int
        if (!is_null($minAdult) && !(is_int($minAdult) || ctype_digit($minAdult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minAdult, true), gettype($minAdult)), __LINE__);
        }
        $this->minAdult = $minAdult;
        return $this;
    }
    /**
     * Get minAge value
     * @return int|null
     */
    public function getMinAge()
    {
        return $this->minAge;
    }
    /**
     * Set minAge value
     * @param int $minAge
     * @return \StructType\SuitableTariff
     */
    public function setMinAge($minAge = null)
    {
        // validation for constraint: int
        if (!is_null($minAge) && !(is_int($minAge) || ctype_digit($minAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minAge, true), gettype($minAge)), __LINE__);
        }
        $this->minAge = $minAge;
        return $this;
    }
    /**
     * Get minChildren value
     * @return int|null
     */
    public function getMinChildren()
    {
        return $this->minChildren;
    }
    /**
     * Set minChildren value
     * @param int $minChildren
     * @return \StructType\SuitableTariff
     */
    public function setMinChildren($minChildren = null)
    {
        // validation for constraint: int
        if (!is_null($minChildren) && !(is_int($minChildren) || ctype_digit($minChildren))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minChildren, true), gettype($minChildren)), __LINE__);
        }
        $this->minChildren = $minChildren;
        return $this;
    }
    /**
     * Get minDays value
     * @return int|null
     */
    public function getMinDays()
    {
        return $this->minDays;
    }
    /**
     * Set minDays value
     * @param int $minDays
     * @return \StructType\SuitableTariff
     */
    public function setMinDays($minDays = null)
    {
        // validation for constraint: int
        if (!is_null($minDays) && !(is_int($minDays) || ctype_digit($minDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minDays, true), gettype($minDays)), __LINE__);
        }
        $this->minDays = $minDays;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SuitableTariff
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
