<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SuitableProductOffer StructType
 * @subpackage Structs
 */
class SuitableProductOffer extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $code;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The regionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $regionCode;
    /**
     * The shortcut
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shortcut;
    /**
     * The duration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $duration;
    /**
     * The repeat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $repeat;
    /**
     * The productType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $productType;
    /**
     * The usageInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $usageInfo;
    /**
     * The tariffGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SuitableTariffGroup[]
     */
    public $tariffGroup;
    /**
     * Constructor method for SuitableProductOffer
     * @uses SuitableProductOffer::setCode()
     * @uses SuitableProductOffer::setDescription()
     * @uses SuitableProductOffer::setName()
     * @uses SuitableProductOffer::setRegionCode()
     * @uses SuitableProductOffer::setShortcut()
     * @uses SuitableProductOffer::setDuration()
     * @uses SuitableProductOffer::setRepeat()
     * @uses SuitableProductOffer::setProductType()
     * @uses SuitableProductOffer::setUsageInfo()
     * @uses SuitableProductOffer::setTariffGroup()
     * @param string $code
     * @param string $description
     * @param string $name
     * @param string $regionCode
     * @param string $shortcut
     * @param string $duration
     * @param string $repeat
     * @param string $productType
     * @param string $usageInfo
     * @param \StructType\SuitableTariffGroup[] $tariffGroup
     */
    public function __construct($code = null, $description = null, $name = null, $regionCode = null, $shortcut = null, $duration = null, $repeat = null, $productType = null, $usageInfo = null, array $tariffGroup = array())
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setName($name)
            ->setRegionCode($regionCode)
            ->setShortcut($shortcut)
            ->setDuration($duration)
            ->setRepeat($repeat)
            ->setProductType($productType)
            ->setUsageInfo($usageInfo)
            ->setTariffGroup($tariffGroup);
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\SuitableProductOffer
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\SuitableProductOffer
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\SuitableProductOffer
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get regionCode value
     * @return string|null
     */
    public function getRegionCode()
    {
        return $this->regionCode;
    }
    /**
     * Set regionCode value
     * @param string $regionCode
     * @return \StructType\SuitableProductOffer
     */
    public function setRegionCode($regionCode = null)
    {
        // validation for constraint: string
        if (!is_null($regionCode) && !is_string($regionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regionCode, true), gettype($regionCode)), __LINE__);
        }
        $this->regionCode = $regionCode;
        return $this;
    }
    /**
     * Get shortcut value
     * @return string|null
     */
    public function getShortcut()
    {
        return $this->shortcut;
    }
    /**
     * Set shortcut value
     * @param string $shortcut
     * @return \StructType\SuitableProductOffer
     */
    public function setShortcut($shortcut = null)
    {
        // validation for constraint: string
        if (!is_null($shortcut) && !is_string($shortcut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortcut, true), gettype($shortcut)), __LINE__);
        }
        $this->shortcut = $shortcut;
        return $this;
    }
    /**
     * Get duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->duration;
    }
    /**
     * Set duration value
     * @param string $duration
     * @return \StructType\SuitableProductOffer
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->duration = $duration;
        return $this;
    }
    /**
     * Get repeat value
     * @return string|null
     */
    public function getRepeat()
    {
        return $this->repeat;
    }
    /**
     * Set repeat value
     * @param string $repeat
     * @return \StructType\SuitableProductOffer
     */
    public function setRepeat($repeat = null)
    {
        // validation for constraint: string
        if (!is_null($repeat) && !is_string($repeat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repeat, true), gettype($repeat)), __LINE__);
        }
        $this->repeat = $repeat;
        return $this;
    }
    /**
     * Get productType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->productType;
    }
    /**
     * Set productType value
     * @param string $productType
     * @return \StructType\SuitableProductOffer
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: string
        if (!is_null($productType) && !is_string($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productType, true), gettype($productType)), __LINE__);
        }
        $this->productType = $productType;
        return $this;
    }
    /**
     * Get usageInfo value
     * @return string|null
     */
    public function getUsageInfo()
    {
        return $this->usageInfo;
    }
    /**
     * Set usageInfo value
     * @param string $usageInfo
     * @return \StructType\SuitableProductOffer
     */
    public function setUsageInfo($usageInfo = null)
    {
        // validation for constraint: string
        if (!is_null($usageInfo) && !is_string($usageInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usageInfo, true), gettype($usageInfo)), __LINE__);
        }
        $this->usageInfo = $usageInfo;
        return $this;
    }
    /**
     * Get tariffGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SuitableTariffGroup[]|null
     */
    public function getTariffGroup()
    {
        return isset($this->tariffGroup) ? $this->tariffGroup : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTariffGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTariffGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTariffGroupForArrayConstraintsFromSetTariffGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suitableProductOfferTariffGroupItem) {
            // validation for constraint: itemType
            if (!$suitableProductOfferTariffGroupItem instanceof \StructType\SuitableTariffGroup) {
                $invalidValues[] = is_object($suitableProductOfferTariffGroupItem) ? get_class($suitableProductOfferTariffGroupItem) : sprintf('%s(%s)', gettype($suitableProductOfferTariffGroupItem), var_export($suitableProductOfferTariffGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The tariffGroup property can only contain items of type \StructType\SuitableTariffGroup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set tariffGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SuitableTariffGroup[] $tariffGroup
     * @return \StructType\SuitableProductOffer
     */
    public function setTariffGroup(array $tariffGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($tariffGroupArrayErrorMessage = self::validateTariffGroupForArrayConstraintsFromSetTariffGroup($tariffGroup))) {
            throw new \InvalidArgumentException($tariffGroupArrayErrorMessage, __LINE__);
        }
        if (is_null($tariffGroup) || (is_array($tariffGroup) && empty($tariffGroup))) {
            unset($this->tariffGroup);
        } else {
            $this->tariffGroup = $tariffGroup;
        }
        return $this;
    }
    /**
     * Add item to tariffGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\SuitableTariffGroup $item
     * @return \StructType\SuitableProductOffer
     */
    public function addToTariffGroup(\StructType\SuitableTariffGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SuitableTariffGroup) {
            throw new \InvalidArgumentException(sprintf('The tariffGroup property can only contain items of type \StructType\SuitableTariffGroup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->tariffGroup[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SuitableProductOffer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
