<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductsResp StructType
 * @subpackage Structs
 */
class ProductsResp extends AbstractStructBase
{
    /**
     * The error
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RespError
     */
    public $error;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Product[]
     */
    public $product;
    /**
     * Constructor method for ProductsResp
     * @uses ProductsResp::setError()
     * @uses ProductsResp::setProduct()
     * @param \StructType\RespError $error
     * @param \StructType\Product[] $product
     */
    public function __construct(\StructType\RespError $error = null, array $product = array())
    {
        $this
            ->setError($error)
            ->setProduct($product);
    }
    /**
     * Get error value
     * @return \StructType\RespError|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param \StructType\RespError $error
     * @return \StructType\ProductsResp
     */
    public function setError(\StructType\RespError $error = null)
    {
        $this->error = $error;
        return $this;
    }
    /**
     * Get product value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Product[]|null
     */
    public function getProduct()
    {
        return isset($this->product) ? $this->product : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProduct method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProduct method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductForArrayConstraintsFromSetProduct(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productsRespProductItem) {
            // validation for constraint: itemType
            if (!$productsRespProductItem instanceof \StructType\Product) {
                $invalidValues[] = is_object($productsRespProductItem) ? get_class($productsRespProductItem) : sprintf('%s(%s)', gettype($productsRespProductItem), var_export($productsRespProductItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The product property can only contain items of type \StructType\Product, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set product value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Product[] $product
     * @return \StructType\ProductsResp
     */
    public function setProduct(array $product = array())
    {
        // validation for constraint: array
        if ('' !== ($productArrayErrorMessage = self::validateProductForArrayConstraintsFromSetProduct($product))) {
            throw new \InvalidArgumentException($productArrayErrorMessage, __LINE__);
        }
        if (is_null($product) || (is_array($product) && empty($product))) {
            unset($this->product);
        } else {
            $this->product = $product;
        }
        return $this;
    }
    /**
     * Add item to product value
     * @throws \InvalidArgumentException
     * @param \StructType\Product $item
     * @return \StructType\ProductsResp
     */
    public function addToProduct(\StructType\Product $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Product) {
            throw new \InvalidArgumentException(sprintf('The product property can only contain items of type \StructType\Product, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->product[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductsResp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
