<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolicyParms StructType
 * @subpackage Structs
 */
class PolicyParms extends AbstractStructBase
{
    /**
     * The destination
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $destination;
    /**
     * The insureds
     * @var \StructType\Insureds
     */
    public $insureds;
    /**
     * The issuedOn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $issuedOn;
    /**
     * The lastDay
     * @var string
     */
    public $lastDay;
    /**
     * The officeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $officeID;
    /**
     * The organized
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $organized;
    /**
     * The policyHolder
     * @var \StructType\PolicyHolderParms
     */
    public $policyHolder;
    /**
     * The productCode
     * @var int
     */
    public $productCode;
    /**
     * The regionCode
     * @var string
     */
    public $regionCode;
    /**
     * The seller
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $seller;
    /**
     * The startDay
     * @var string
     */
    public $startDay;
    /**
     * The transport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $transport;
    /**
     * Constructor method for PolicyParms
     * @uses PolicyParms::setDestination()
     * @uses PolicyParms::setInsureds()
     * @uses PolicyParms::setIssuedOn()
     * @uses PolicyParms::setLastDay()
     * @uses PolicyParms::setOfficeID()
     * @uses PolicyParms::setOrganized()
     * @uses PolicyParms::setPolicyHolder()
     * @uses PolicyParms::setProductCode()
     * @uses PolicyParms::setRegionCode()
     * @uses PolicyParms::setSeller()
     * @uses PolicyParms::setStartDay()
     * @uses PolicyParms::setTransport()
     * @param string $destination
     * @param \StructType\Insureds $insureds
     * @param string $issuedOn
     * @param string $lastDay
     * @param string $officeID
     * @param bool $organized
     * @param \StructType\PolicyHolderParms $policyHolder
     * @param int $productCode
     * @param string $regionCode
     * @param string $seller
     * @param string $startDay
     * @param string $transport
     */
    public function __construct($destination = null, \StructType\Insureds $insureds = null, $issuedOn = null, $lastDay = null, $officeID = null, $organized = false, \StructType\PolicyHolderParms $policyHolder = null, $productCode = null, $regionCode = null, $seller = null, $startDay = null, $transport = null)
    {
        $this
            ->setDestination($destination)
            ->setInsureds($insureds)
            ->setIssuedOn($issuedOn)
            ->setLastDay($lastDay)
            ->setOfficeID($officeID)
            ->setOrganized($organized)
            ->setPolicyHolder($policyHolder)
            ->setProductCode($productCode)
            ->setRegionCode($regionCode)
            ->setSeller($seller)
            ->setStartDay($startDay)
            ->setTransport($transport);
    }
    /**
     * Get destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return \StructType\PolicyParms
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get insureds value
     * @return \StructType\Insureds|null
     */
    public function getInsureds()
    {
        return $this->insureds;
    }
    /**
     * Set insureds value
     * @param \StructType\Insureds $insureds
     * @return \StructType\PolicyParms
     */
    public function setInsureds(\StructType\Insureds $insureds = null)
    {
        $this->insureds = $insureds;
        return $this;
    }
    /**
     * Get issuedOn value
     * @return string|null
     */
    public function getIssuedOn()
    {
        return $this->issuedOn;
    }
    /**
     * Set issuedOn value
     * @param string $issuedOn
     * @return \StructType\PolicyParms
     */
    public function setIssuedOn($issuedOn = null)
    {
        // validation for constraint: string
        if (!is_null($issuedOn) && !is_string($issuedOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuedOn, true), gettype($issuedOn)), __LINE__);
        }
        $this->issuedOn = $issuedOn;
        return $this;
    }
    /**
     * Get lastDay value
     * @return string|null
     */
    public function getLastDay()
    {
        return $this->lastDay;
    }
    /**
     * Set lastDay value
     * @param string $lastDay
     * @return \StructType\PolicyParms
     */
    public function setLastDay($lastDay = null)
    {
        // validation for constraint: string
        if (!is_null($lastDay) && !is_string($lastDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastDay, true), gettype($lastDay)), __LINE__);
        }
        $this->lastDay = $lastDay;
        return $this;
    }
    /**
     * Get officeID value
     * @return string|null
     */
    public function getOfficeID()
    {
        return $this->officeID;
    }
    /**
     * Set officeID value
     * @param string $officeID
     * @return \StructType\PolicyParms
     */
    public function setOfficeID($officeID = null)
    {
        // validation for constraint: string
        if (!is_null($officeID) && !is_string($officeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($officeID, true), gettype($officeID)), __LINE__);
        }
        $this->officeID = $officeID;
        return $this;
    }
    /**
     * Get organized value
     * @return bool|null
     */
    public function getOrganized()
    {
        return $this->organized;
    }
    /**
     * Set organized value
     * @param bool $organized
     * @return \StructType\PolicyParms
     */
    public function setOrganized($organized = false)
    {
        // validation for constraint: boolean
        if (!is_null($organized) && !is_bool($organized)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($organized, true), gettype($organized)), __LINE__);
        }
        $this->organized = $organized;
        return $this;
    }
    /**
     * Get policyHolder value
     * @return \StructType\PolicyHolderParms|null
     */
    public function getPolicyHolder()
    {
        return $this->policyHolder;
    }
    /**
     * Set policyHolder value
     * @param \StructType\PolicyHolderParms $policyHolder
     * @return \StructType\PolicyParms
     */
    public function setPolicyHolder(\StructType\PolicyHolderParms $policyHolder = null)
    {
        $this->policyHolder = $policyHolder;
        return $this;
    }
    /**
     * Get productCode value
     * @return int|null
     */
    public function getProductCode()
    {
        return $this->productCode;
    }
    /**
     * Set productCode value
     * @param int $productCode
     * @return \StructType\PolicyParms
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: int
        if (!is_null($productCode) && !(is_int($productCode) || ctype_digit($productCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        $this->productCode = $productCode;
        return $this;
    }
    /**
     * Get regionCode value
     * @return string|null
     */
    public function getRegionCode()
    {
        return $this->regionCode;
    }
    /**
     * Set regionCode value
     * @param string $regionCode
     * @return \StructType\PolicyParms
     */
    public function setRegionCode($regionCode = null)
    {
        // validation for constraint: string
        if (!is_null($regionCode) && !is_string($regionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regionCode, true), gettype($regionCode)), __LINE__);
        }
        $this->regionCode = $regionCode;
        return $this;
    }
    /**
     * Get seller value
     * @return string|null
     */
    public function getSeller()
    {
        return $this->seller;
    }
    /**
     * Set seller value
     * @param string $seller
     * @return \StructType\PolicyParms
     */
    public function setSeller($seller = null)
    {
        // validation for constraint: string
        if (!is_null($seller) && !is_string($seller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seller, true), gettype($seller)), __LINE__);
        }
        $this->seller = $seller;
        return $this;
    }
    /**
     * Get startDay value
     * @return string|null
     */
    public function getStartDay()
    {
        return $this->startDay;
    }
    /**
     * Set startDay value
     * @param string $startDay
     * @return \StructType\PolicyParms
     */
    public function setStartDay($startDay = null)
    {
        // validation for constraint: string
        if (!is_null($startDay) && !is_string($startDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDay, true), gettype($startDay)), __LINE__);
        }
        $this->startDay = $startDay;
        return $this;
    }
    /**
     * Get transport value
     * @return string|null
     */
    public function getTransport()
    {
        return $this->transport;
    }
    /**
     * Set transport value
     * @param string $transport
     * @return \StructType\PolicyParms
     */
    public function setTransport($transport = null)
    {
        // validation for constraint: string
        if (!is_null($transport) && !is_string($transport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transport, true), gettype($transport)), __LINE__);
        }
        $this->transport = $transport;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PolicyParms
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
