<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getSupplementariesOffer StructType
 * Meta information extracted from the WSDL
 * - type: tns:getSupplementariesOffer
 * @subpackage Structs
 */
class GetSupplementariesOffer extends AbstractStructBase
{
    /**
     * The uniqueId
     * @var string
     */
    public $uniqueId;
    /**
     * The productCode
     * @var int
     */
    public $productCode;
    /**
     * The startDate
     * @var string
     */
    public $startDate;
    /**
     * The insuredDays
     * @var int
     */
    public $insuredDays;
    /**
     * The currency
     * @var string
     */
    public $currency;
    /**
     * The language
     * @var string
     */
    public $language;
    /**
     * Constructor method for getSupplementariesOffer
     * @uses GetSupplementariesOffer::setUniqueId()
     * @uses GetSupplementariesOffer::setProductCode()
     * @uses GetSupplementariesOffer::setStartDate()
     * @uses GetSupplementariesOffer::setInsuredDays()
     * @uses GetSupplementariesOffer::setCurrency()
     * @uses GetSupplementariesOffer::setLanguage()
     * @param string $uniqueId
     * @param int $productCode
     * @param string $startDate
     * @param int $insuredDays
     * @param string $currency
     * @param string $language
     */
    public function __construct($uniqueId = null, $productCode = null, $startDate = null, $insuredDays = null, $currency = null, $language = null)
    {
        $this
            ->setUniqueId($uniqueId)
            ->setProductCode($productCode)
            ->setStartDate($startDate)
            ->setInsuredDays($insuredDays)
            ->setCurrency($currency)
            ->setLanguage($language);
    }
    /**
     * Get uniqueId value
     * @return string|null
     */
    public function getUniqueId()
    {
        return $this->uniqueId;
    }
    /**
     * Set uniqueId value
     * @param string $uniqueId
     * @return \StructType\GetSupplementariesOffer
     */
    public function setUniqueId($uniqueId = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueId) && !is_string($uniqueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uniqueId, true), gettype($uniqueId)), __LINE__);
        }
        $this->uniqueId = $uniqueId;
        return $this;
    }
    /**
     * Get productCode value
     * @return int|null
     */
    public function getProductCode()
    {
        return $this->productCode;
    }
    /**
     * Set productCode value
     * @param int $productCode
     * @return \StructType\GetSupplementariesOffer
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: int
        if (!is_null($productCode) && !(is_int($productCode) || ctype_digit($productCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        $this->productCode = $productCode;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\GetSupplementariesOffer
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get insuredDays value
     * @return int|null
     */
    public function getInsuredDays()
    {
        return $this->insuredDays;
    }
    /**
     * Set insuredDays value
     * @param int $insuredDays
     * @return \StructType\GetSupplementariesOffer
     */
    public function setInsuredDays($insuredDays = null)
    {
        // validation for constraint: int
        if (!is_null($insuredDays) && !(is_int($insuredDays) || ctype_digit($insuredDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($insuredDays, true), gettype($insuredDays)), __LINE__);
        }
        $this->insuredDays = $insuredDays;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\GetSupplementariesOffer
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\GetSupplementariesOffer
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetSupplementariesOffer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
