<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ITGIMotorPreInspectionAgencyRecommendationResponse_Input
 * StructType
 * @subpackage Structs
 */
class ITGIMotorPreInspectionAgencyRecommendationResponse_Input extends AbstractStructBase
{
    /**
     * The PreInspectionNumber
     * @var string
     */
    public $PreInspectionNumber;
    /**
     * The RecommendationResponse
     * @var string
     */
    public $RecommendationResponse;
    /**
     * The LatitudeLongitude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LatitudeLongitude;
    /**
     * The InspectionLocation
     * @var string
     */
    public $InspectionLocation;
    /**
     * The PreInspectionIntegrationId
     * @var string
     */
    public $PreInspectionIntegrationId;
    /**
     * The Remarks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Remarks;
    /**
     * The ChassisNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ChassisNumber;
    /**
     * The InspectionDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InspectionDateTime;
    /**
     * The EngineNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EngineNumber;
    /**
     * Constructor method for ITGIMotorPreInspectionAgencyRecommendationResponse_Input
     * @uses ITGIMotorPreInspectionAgencyRecommendationResponse_Input::setPreInspectionNumber()
     * @uses ITGIMotorPreInspectionAgencyRecommendationResponse_Input::setRecommendationResponse()
     * @uses ITGIMotorPreInspectionAgencyRecommendationResponse_Input::setLatitudeLongitude()
     * @uses ITGIMotorPreInspectionAgencyRecommendationResponse_Input::setInspectionLocation()
     * @uses ITGIMotorPreInspectionAgencyRecommendationResponse_Input::setPreInspectionIntegrationId()
     * @uses ITGIMotorPreInspectionAgencyRecommendationResponse_Input::setRemarks()
     * @uses ITGIMotorPreInspectionAgencyRecommendationResponse_Input::setChassisNumber()
     * @uses ITGIMotorPreInspectionAgencyRecommendationResponse_Input::setInspectionDateTime()
     * @uses ITGIMotorPreInspectionAgencyRecommendationResponse_Input::setEngineNumber()
     * @param string $preInspectionNumber
     * @param string $recommendationResponse
     * @param string $latitudeLongitude
     * @param string $inspectionLocation
     * @param string $preInspectionIntegrationId
     * @param string $remarks
     * @param string $chassisNumber
     * @param string $inspectionDateTime
     * @param string $engineNumber
     */
    public function __construct($preInspectionNumber = null, $recommendationResponse = null, $latitudeLongitude = null, $inspectionLocation = null, $preInspectionIntegrationId = null, $remarks = null, $chassisNumber = null, $inspectionDateTime = null, $engineNumber = null)
    {
        $this
            ->setPreInspectionNumber($preInspectionNumber)
            ->setRecommendationResponse($recommendationResponse)
            ->setLatitudeLongitude($latitudeLongitude)
            ->setInspectionLocation($inspectionLocation)
            ->setPreInspectionIntegrationId($preInspectionIntegrationId)
            ->setRemarks($remarks)
            ->setChassisNumber($chassisNumber)
            ->setInspectionDateTime($inspectionDateTime)
            ->setEngineNumber($engineNumber);
    }
    /**
     * Get PreInspectionNumber value
     * @return string|null
     */
    public function getPreInspectionNumber()
    {
        return $this->PreInspectionNumber;
    }
    /**
     * Set PreInspectionNumber value
     * @param string $preInspectionNumber
     * @return \StructType\ITGIMotorPreInspectionAgencyRecommendationResponse_Input
     */
    public function setPreInspectionNumber($preInspectionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($preInspectionNumber) && !is_string($preInspectionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preInspectionNumber, true), gettype($preInspectionNumber)), __LINE__);
        }
        $this->PreInspectionNumber = $preInspectionNumber;
        return $this;
    }
    /**
     * Get RecommendationResponse value
     * @return string|null
     */
    public function getRecommendationResponse()
    {
        return $this->RecommendationResponse;
    }
    /**
     * Set RecommendationResponse value
     * @param string $recommendationResponse
     * @return \StructType\ITGIMotorPreInspectionAgencyRecommendationResponse_Input
     */
    public function setRecommendationResponse($recommendationResponse = null)
    {
        // validation for constraint: string
        if (!is_null($recommendationResponse) && !is_string($recommendationResponse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recommendationResponse, true), gettype($recommendationResponse)), __LINE__);
        }
        $this->RecommendationResponse = $recommendationResponse;
        return $this;
    }
    /**
     * Get LatitudeLongitude value
     * @return string|null
     */
    public function getLatitudeLongitude()
    {
        return $this->LatitudeLongitude;
    }
    /**
     * Set LatitudeLongitude value
     * @param string $latitudeLongitude
     * @return \StructType\ITGIMotorPreInspectionAgencyRecommendationResponse_Input
     */
    public function setLatitudeLongitude($latitudeLongitude = null)
    {
        // validation for constraint: string
        if (!is_null($latitudeLongitude) && !is_string($latitudeLongitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latitudeLongitude, true), gettype($latitudeLongitude)), __LINE__);
        }
        $this->LatitudeLongitude = $latitudeLongitude;
        return $this;
    }
    /**
     * Get InspectionLocation value
     * @return string|null
     */
    public function getInspectionLocation()
    {
        return $this->InspectionLocation;
    }
    /**
     * Set InspectionLocation value
     * @param string $inspectionLocation
     * @return \StructType\ITGIMotorPreInspectionAgencyRecommendationResponse_Input
     */
    public function setInspectionLocation($inspectionLocation = null)
    {
        // validation for constraint: string
        if (!is_null($inspectionLocation) && !is_string($inspectionLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inspectionLocation, true), gettype($inspectionLocation)), __LINE__);
        }
        $this->InspectionLocation = $inspectionLocation;
        return $this;
    }
    /**
     * Get PreInspectionIntegrationId value
     * @return string|null
     */
    public function getPreInspectionIntegrationId()
    {
        return $this->PreInspectionIntegrationId;
    }
    /**
     * Set PreInspectionIntegrationId value
     * @param string $preInspectionIntegrationId
     * @return \StructType\ITGIMotorPreInspectionAgencyRecommendationResponse_Input
     */
    public function setPreInspectionIntegrationId($preInspectionIntegrationId = null)
    {
        // validation for constraint: string
        if (!is_null($preInspectionIntegrationId) && !is_string($preInspectionIntegrationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preInspectionIntegrationId, true), gettype($preInspectionIntegrationId)), __LINE__);
        }
        $this->PreInspectionIntegrationId = $preInspectionIntegrationId;
        return $this;
    }
    /**
     * Get Remarks value
     * @return string|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param string $remarks
     * @return \StructType\ITGIMotorPreInspectionAgencyRecommendationResponse_Input
     */
    public function setRemarks($remarks = null)
    {
        // validation for constraint: string
        if (!is_null($remarks) && !is_string($remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remarks, true), gettype($remarks)), __LINE__);
        }
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Get ChassisNumber value
     * @return string|null
     */
    public function getChassisNumber()
    {
        return $this->ChassisNumber;
    }
    /**
     * Set ChassisNumber value
     * @param string $chassisNumber
     * @return \StructType\ITGIMotorPreInspectionAgencyRecommendationResponse_Input
     */
    public function setChassisNumber($chassisNumber = null)
    {
        // validation for constraint: string
        if (!is_null($chassisNumber) && !is_string($chassisNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chassisNumber, true), gettype($chassisNumber)), __LINE__);
        }
        $this->ChassisNumber = $chassisNumber;
        return $this;
    }
    /**
     * Get InspectionDateTime value
     * @return string|null
     */
    public function getInspectionDateTime()
    {
        return $this->InspectionDateTime;
    }
    /**
     * Set InspectionDateTime value
     * @param string $inspectionDateTime
     * @return \StructType\ITGIMotorPreInspectionAgencyRecommendationResponse_Input
     */
    public function setInspectionDateTime($inspectionDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($inspectionDateTime) && !is_string($inspectionDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inspectionDateTime, true), gettype($inspectionDateTime)), __LINE__);
        }
        $this->InspectionDateTime = $inspectionDateTime;
        return $this;
    }
    /**
     * Get EngineNumber value
     * @return string|null
     */
    public function getEngineNumber()
    {
        return $this->EngineNumber;
    }
    /**
     * Set EngineNumber value
     * @param string $engineNumber
     * @return \StructType\ITGIMotorPreInspectionAgencyRecommendationResponse_Input
     */
    public function setEngineNumber($engineNumber = null)
    {
        // validation for constraint: string
        if (!is_null($engineNumber) && !is_string($engineNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($engineNumber, true), gettype($engineNumber)), __LINE__);
        }
        $this->EngineNumber = $engineNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ITGIMotorPreInspectionAgencyRecommendationResponse_Input
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
