<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for ITGIM ServiceType
 * @subpackage Services
 */
class ITGIM extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * ITGIMotorPreInspectionAgencyRecommendationResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ITGIMotorPreInspectionAgencyRecommendationResponse_Input $iTGIMotorPreInspectionAgencyRecommendationResponse_Input
     * @return \StructType\ITGIMotorPreInspectionAgencyRecommendationResponse_Output|bool
     */
    public function ITGIMotorPreInspectionAgencyRecommendationResponse(\StructType\ITGIMotorPreInspectionAgencyRecommendationResponse_Input $iTGIMotorPreInspectionAgencyRecommendationResponse_Input)
    {
        try {
            $this->setResult($this->getSoapClient()->ITGIMotorPreInspectionAgencyRecommendationResponse($iTGIMotorPreInspectionAgencyRecommendationResponse_Input));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ITGIMotorPreInspectionAgencyRecommendationResponse_Output
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
