<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCDM ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCDM
 * @subpackage Arrays
 */
class ArrayOfCDM extends AbstractStructArrayBase
{
    /**
     * The CDM
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CDM[]
     */
    public $CDM;
    /**
     * Constructor method for ArrayOfCDM
     * @uses ArrayOfCDM::setCDM()
     * @param \StructType\CDM[] $cDM
     */
    public function __construct(array $cDM = array())
    {
        $this
            ->setCDM($cDM);
    }
    /**
     * Get CDM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CDM[]|null
     */
    public function getCDM()
    {
        return isset($this->CDM) ? $this->CDM : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCDM method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCDM method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCDMForArrayConstraintsFromSetCDM(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCDMCDMItem) {
            // validation for constraint: itemType
            if (!$arrayOfCDMCDMItem instanceof \StructType\CDM) {
                $invalidValues[] = is_object($arrayOfCDMCDMItem) ? get_class($arrayOfCDMCDMItem) : sprintf('%s(%s)', gettype($arrayOfCDMCDMItem), var_export($arrayOfCDMCDMItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CDM property can only contain items of type \StructType\CDM, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CDM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CDM[] $cDM
     * @return \ArrayType\ArrayOfCDM
     */
    public function setCDM(array $cDM = array())
    {
        // validation for constraint: array
        if ('' !== ($cDMArrayErrorMessage = self::validateCDMForArrayConstraintsFromSetCDM($cDM))) {
            throw new \InvalidArgumentException($cDMArrayErrorMessage, __LINE__);
        }
        if (is_null($cDM) || (is_array($cDM) && empty($cDM))) {
            unset($this->CDM);
        } else {
            $this->CDM = $cDM;
        }
        return $this;
    }
    /**
     * Add item to CDM value
     * @throws \InvalidArgumentException
     * @param \StructType\CDM $item
     * @return \ArrayType\ArrayOfCDM
     */
    public function addToCDM(\StructType\CDM $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CDM) {
            throw new \InvalidArgumentException(sprintf('The CDM property can only contain items of type \StructType\CDM, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CDM[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CDM|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CDM|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CDM|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CDM|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CDM|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CDM
     */
    public function getAttributeName()
    {
        return 'CDM';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCDM
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
