<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Request
 * @subpackage Structs
 */
class Request extends AbstractStructBase
{
    /**
     * The Application
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Application;
    /**
     * The CallDetail
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CallDetail;
    /**
     * The CompanyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyCode;
    /**
     * The JobReference
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $JobReference;
    /**
     * Constructor method for Request
     * @uses Request::setApplication()
     * @uses Request::setCallDetail()
     * @uses Request::setCompanyCode()
     * @uses Request::setJobReference()
     * @param string $application
     * @param string $callDetail
     * @param string $companyCode
     * @param string $jobReference
     */
    public function __construct($application = null, $callDetail = null, $companyCode = null, $jobReference = null)
    {
        $this
            ->setApplication($application)
            ->setCallDetail($callDetail)
            ->setCompanyCode($companyCode)
            ->setJobReference($jobReference);
    }
    /**
     * Get Application value
     * @return string|null
     */
    public function getApplication()
    {
        return $this->Application;
    }
    /**
     * Set Application value
     * @param string $application
     * @return \StructType\Request
     */
    public function setApplication($application = null)
    {
        // validation for constraint: string
        if (!is_null($application) && !is_string($application)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($application, true), gettype($application)), __LINE__);
        }
        $this->Application = $application;
        return $this;
    }
    /**
     * Get CallDetail value
     * @return string|null
     */
    public function getCallDetail()
    {
        return $this->CallDetail;
    }
    /**
     * Set CallDetail value
     * @param string $callDetail
     * @return \StructType\Request
     */
    public function setCallDetail($callDetail = null)
    {
        // validation for constraint: string
        if (!is_null($callDetail) && !is_string($callDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callDetail, true), gettype($callDetail)), __LINE__);
        }
        $this->CallDetail = $callDetail;
        return $this;
    }
    /**
     * Get CompanyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyCode()
    {
        return isset($this->CompanyCode) ? $this->CompanyCode : null;
    }
    /**
     * Set CompanyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyCode
     * @return \StructType\Request
     */
    public function setCompanyCode($companyCode = null)
    {
        // validation for constraint: string
        if (!is_null($companyCode) && !is_string($companyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyCode, true), gettype($companyCode)), __LINE__);
        }
        if (is_null($companyCode) || (is_array($companyCode) && empty($companyCode))) {
            unset($this->CompanyCode);
        } else {
            $this->CompanyCode = $companyCode;
        }
        return $this;
    }
    /**
     * Get JobReference value
     * @return string|null
     */
    public function getJobReference()
    {
        return $this->JobReference;
    }
    /**
     * Set JobReference value
     * @param string $jobReference
     * @return \StructType\Request
     */
    public function setJobReference($jobReference = null)
    {
        // validation for constraint: string
        if (!is_null($jobReference) && !is_string($jobReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobReference, true), gettype($jobReference)), __LINE__);
        }
        $this->JobReference = $jobReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Request
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
