<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CDM StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CDM
 * @subpackage Structs
 */
class CDM extends AbstractStructBase
{
    /**
     * The Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Data
     */
    public $Data;
    /**
     * Constructor method for CDM
     * @uses CDM::setData()
     * @param \StructType\Data $data
     */
    public function __construct(\StructType\Data $data = null)
    {
        $this
            ->setData($data);
    }
    /**
     * Get Data value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Data|null
     */
    public function getData()
    {
        return isset($this->Data) ? $this->Data : null;
    }
    /**
     * Set Data value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Data $data
     * @return \StructType\CDM
     */
    public function setData(\StructType\Data $data = null)
    {
        if (is_null($data) || (is_array($data) && empty($data))) {
            unset($this->Data);
        } else {
            $this->Data = $data;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CDM
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
