<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Branches StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Branches
 * @subpackage Structs
 */
class Branches extends AbstractStructBase
{
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $Branch;
    /**
     * Constructor method for Branches
     * @uses Branches::setBranch()
     * @param string[] $branch
     */
    public function __construct(array $branch = array())
    {
        $this
            ->setBranch($branch);
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBranch method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBranch method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBranchForArrayConstraintsFromSetBranch(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $branchesBranchItem) {
            // validation for constraint: itemType
            if (!is_string($branchesBranchItem)) {
                $invalidValues[] = is_object($branchesBranchItem) ? get_class($branchesBranchItem) : sprintf('%s(%s)', gettype($branchesBranchItem), var_export($branchesBranchItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Branch property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $branch
     * @return \StructType\Branches
     */
    public function setBranch(array $branch = array())
    {
        // validation for constraint: array
        if ('' !== ($branchArrayErrorMessage = self::validateBranchForArrayConstraintsFromSetBranch($branch))) {
            throw new \InvalidArgumentException($branchArrayErrorMessage, __LINE__);
        }
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Add item to Branch value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Branches
     */
    public function addToBranch($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Branch property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Branch[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Branches
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
