<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Agents StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Agents
 * @subpackage Structs
 */
class Agents extends AbstractStructBase
{
    /**
     * The Agent
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $Agent;
    /**
     * Constructor method for Agents
     * @uses Agents::setAgent()
     * @param string[] $agent
     */
    public function __construct(array $agent = array())
    {
        $this
            ->setAgent($agent);
    }
    /**
     * Get Agent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAgent()
    {
        return isset($this->Agent) ? $this->Agent : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAgent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAgent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAgentForArrayConstraintsFromSetAgent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $agentsAgentItem) {
            // validation for constraint: itemType
            if (!is_string($agentsAgentItem)) {
                $invalidValues[] = is_object($agentsAgentItem) ? get_class($agentsAgentItem) : sprintf('%s(%s)', gettype($agentsAgentItem), var_export($agentsAgentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Agent property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Agent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $agent
     * @return \StructType\Agents
     */
    public function setAgent(array $agent = array())
    {
        // validation for constraint: array
        if ('' !== ($agentArrayErrorMessage = self::validateAgentForArrayConstraintsFromSetAgent($agent))) {
            throw new \InvalidArgumentException($agentArrayErrorMessage, __LINE__);
        }
        if (is_null($agent) || (is_array($agent) && empty($agent))) {
            unset($this->Agent);
        } else {
            $this->Agent = $agent;
        }
        return $this;
    }
    /**
     * Add item to Agent value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Agents
     */
    public function addToAgent($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Agent property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Agent[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Agents
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
