<?php

namespace EnumType;

/**
 * This class stands for miejsceOdbioruType EnumType
 * @subpackage Enumerations
 */
class MiejsceOdbioruType
{
    /**
     * Constant for value 'NADAWCA'
     * @return string 'NADAWCA'
     */
    const VALUE_NADAWCA = 'NADAWCA';
    /**
     * Constant for value 'URZAD_NADANIA'
     * @return string 'URZAD_NADANIA'
     */
    const VALUE_URZAD_NADANIA = 'URZAD_NADANIA';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NADAWCA
     * @uses self::VALUE_URZAD_NADANIA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NADAWCA,
            self::VALUE_URZAD_NADANIA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
