<?php

namespace EnumType;

/**
 * This class stands for kategoriaType EnumType
 * @subpackage Enumerations
 */
class KategoriaType
{
    /**
     * Constant for value 'EKONOMICZNA'
     * @return string 'EKONOMICZNA'
     */
    const VALUE_EKONOMICZNA = 'EKONOMICZNA';
    /**
     * Constant for value 'PRIORYTETOWA'
     * @return string 'PRIORYTETOWA'
     */
    const VALUE_PRIORYTETOWA = 'PRIORYTETOWA';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EKONOMICZNA
     * @uses self::VALUE_PRIORYTETOWA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EKONOMICZNA,
            self::VALUE_PRIORYTETOWA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
