<?php

namespace EnumType;

/**
 * This class stands for envelopeStatusType EnumType
 * @subpackage Enumerations
 */
class EnvelopeStatusType
{
    /**
     * Constant for value 'WYSLANY'
     * @return string 'WYSLANY'
     */
    const VALUE_WYSLANY = 'WYSLANY';
    /**
     * Constant for value 'DOSTARCZONY'
     * @return string 'DOSTARCZONY'
     */
    const VALUE_DOSTARCZONY = 'DOSTARCZONY';
    /**
     * Constant for value 'PRZYJETY'
     * @return string 'PRZYJETY'
     */
    const VALUE_PRZYJETY = 'PRZYJETY';
    /**
     * Constant for value 'WALIDOWANY'
     * @return string 'WALIDOWANY'
     */
    const VALUE_WALIDOWANY = 'WALIDOWANY';
    /**
     * Constant for value 'BLEDNY'
     * @return string 'BLEDNY'
     */
    const VALUE_BLEDNY = 'BLEDNY';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WYSLANY
     * @uses self::VALUE_DOSTARCZONY
     * @uses self::VALUE_PRZYJETY
     * @uses self::VALUE_WALIDOWANY
     * @uses self::VALUE_BLEDNY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WYSLANY,
            self::VALUE_DOSTARCZONY,
            self::VALUE_PRZYJETY,
            self::VALUE_WALIDOWANY,
            self::VALUE_BLEDNY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
