<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://tbsmnm.mnmedya.com/uyumsoft.xml',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://tbsmnm.mnmedya.com/uyumsoft.xml',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Mnm\ClassMap::get(),
);
/**
 * Samples for User ServiceType
 */
$user = new \Mnm\ServiceType\User($options);
/**
 * Sample call for IsEInvoiceUser operation/method
 */
if ($user->IsEInvoiceUser(new \Mnm\StructType\IsEInvoiceUser()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Samples for Status ServiceType
 */
$status = new \Mnm\ServiceType\Status($options);
/**
 * Sample call for QueryOutboxInvoiceStatus operation/method
 */
if ($status->QueryOutboxInvoiceStatus(new \Mnm\StructType\QueryOutboxInvoiceStatus()) !== false) {
    print_r($status->getResult());
} else {
    print_r($status->getLastError());
}
/**
 * Samples for Invoice ServiceType
 */
$invoice = new \Mnm\ServiceType\Invoice($options);
/**
 * Sample call for SendInvoice operation/method
 */
if ($invoice->SendInvoice(new \Mnm\StructType\SendInvoice()) !== false) {
    print_r($invoice->getResult());
} else {
    print_r($invoice->getLastError());
}
