<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportHandlingUnitType StructType
 * @subpackage Structs
 */
class TransportHandlingUnitType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q215:ID
     * @var \Mnm\StructType\IDType
     */
    public $ID;
    /**
     * The TransportHandlingUnitTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q216:TransportHandlingUnitTypeCode
     * @var \Mnm\StructType\TransportHandlingUnitTypeCodeType
     */
    public $TransportHandlingUnitTypeCode;
    /**
     * The HandlingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q217:HandlingCode
     * @var \Mnm\StructType\HandlingCodeType
     */
    public $HandlingCode;
    /**
     * The HandlingInstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q218:HandlingInstructions
     * @var \Mnm\StructType\HandlingInstructionsType
     */
    public $HandlingInstructions;
    /**
     * The HazardousRiskIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q219:HazardousRiskIndicator
     * @var \Mnm\StructType\HazardousRiskIndicatorType
     */
    public $HazardousRiskIndicator;
    /**
     * The TotalGoodsItemQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q220:TotalGoodsItemQuantity
     * @var \Mnm\StructType\TotalGoodsItemQuantityType
     */
    public $TotalGoodsItemQuantity;
    /**
     * The TotalPackageQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q221:TotalPackageQuantity
     * @var \Mnm\StructType\TotalPackageQuantityType
     */
    public $TotalPackageQuantity;
    /**
     * The DamageRemarks
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q222:DamageRemarks
     * @var \Mnm\StructType\DamageRemarksType[]
     */
    public $DamageRemarks;
    /**
     * The TraceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q223:TraceID
     * @var \Mnm\StructType\TraceIDType
     */
    public $TraceID;
    /**
     * The ActualPackage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\PackageType[]
     */
    public $ActualPackage;
    /**
     * The TransportEquipment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\TransportEquipmentType[]
     */
    public $TransportEquipment;
    /**
     * The TransportMeans
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\TransportMeansType[]
     */
    public $TransportMeans;
    /**
     * The HazardousGoodsTransit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\HazardousGoodsTransitType[]
     */
    public $HazardousGoodsTransit;
    /**
     * The MeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\DimensionType[]
     */
    public $MeasurementDimension;
    /**
     * The MinimumTemperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\TemperatureType
     */
    public $MinimumTemperature;
    /**
     * The MaximumTemperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\TemperatureType
     */
    public $MaximumTemperature;
    /**
     * The FloorSpaceMeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\DimensionType
     */
    public $FloorSpaceMeasurementDimension;
    /**
     * The PalletSpaceMeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\DimensionType
     */
    public $PalletSpaceMeasurementDimension;
    /**
     * The ShipmentDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\DocumentReferenceType[]
     */
    public $ShipmentDocumentReference;
    /**
     * The CustomsDeclaration
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\CustomsDeclarationType[]
     */
    public $CustomsDeclaration;
    /**
     * Constructor method for TransportHandlingUnitType
     * @uses TransportHandlingUnitType::setID()
     * @uses TransportHandlingUnitType::setTransportHandlingUnitTypeCode()
     * @uses TransportHandlingUnitType::setHandlingCode()
     * @uses TransportHandlingUnitType::setHandlingInstructions()
     * @uses TransportHandlingUnitType::setHazardousRiskIndicator()
     * @uses TransportHandlingUnitType::setTotalGoodsItemQuantity()
     * @uses TransportHandlingUnitType::setTotalPackageQuantity()
     * @uses TransportHandlingUnitType::setDamageRemarks()
     * @uses TransportHandlingUnitType::setTraceID()
     * @uses TransportHandlingUnitType::setActualPackage()
     * @uses TransportHandlingUnitType::setTransportEquipment()
     * @uses TransportHandlingUnitType::setTransportMeans()
     * @uses TransportHandlingUnitType::setHazardousGoodsTransit()
     * @uses TransportHandlingUnitType::setMeasurementDimension()
     * @uses TransportHandlingUnitType::setMinimumTemperature()
     * @uses TransportHandlingUnitType::setMaximumTemperature()
     * @uses TransportHandlingUnitType::setFloorSpaceMeasurementDimension()
     * @uses TransportHandlingUnitType::setPalletSpaceMeasurementDimension()
     * @uses TransportHandlingUnitType::setShipmentDocumentReference()
     * @uses TransportHandlingUnitType::setCustomsDeclaration()
     * @param \Mnm\StructType\IDType $iD
     * @param \Mnm\StructType\TransportHandlingUnitTypeCodeType $transportHandlingUnitTypeCode
     * @param \Mnm\StructType\HandlingCodeType $handlingCode
     * @param \Mnm\StructType\HandlingInstructionsType $handlingInstructions
     * @param \Mnm\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator
     * @param \Mnm\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity
     * @param \Mnm\StructType\TotalPackageQuantityType $totalPackageQuantity
     * @param \Mnm\StructType\DamageRemarksType[] $damageRemarks
     * @param \Mnm\StructType\TraceIDType $traceID
     * @param \Mnm\StructType\PackageType[] $actualPackage
     * @param \Mnm\StructType\TransportEquipmentType[] $transportEquipment
     * @param \Mnm\StructType\TransportMeansType[] $transportMeans
     * @param \Mnm\StructType\HazardousGoodsTransitType[] $hazardousGoodsTransit
     * @param \Mnm\StructType\DimensionType[] $measurementDimension
     * @param \Mnm\StructType\TemperatureType $minimumTemperature
     * @param \Mnm\StructType\TemperatureType $maximumTemperature
     * @param \Mnm\StructType\DimensionType $floorSpaceMeasurementDimension
     * @param \Mnm\StructType\DimensionType $palletSpaceMeasurementDimension
     * @param \Mnm\StructType\DocumentReferenceType[] $shipmentDocumentReference
     * @param \Mnm\StructType\CustomsDeclarationType[] $customsDeclaration
     */
    public function __construct(\Mnm\StructType\IDType $iD = null, \Mnm\StructType\TransportHandlingUnitTypeCodeType $transportHandlingUnitTypeCode = null, \Mnm\StructType\HandlingCodeType $handlingCode = null, \Mnm\StructType\HandlingInstructionsType $handlingInstructions = null, \Mnm\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator = null, \Mnm\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity = null, \Mnm\StructType\TotalPackageQuantityType $totalPackageQuantity = null, array $damageRemarks = array(), \Mnm\StructType\TraceIDType $traceID = null, array $actualPackage = array(), array $transportEquipment = array(), array $transportMeans = array(), array $hazardousGoodsTransit = array(), array $measurementDimension = array(), \Mnm\StructType\TemperatureType $minimumTemperature = null, \Mnm\StructType\TemperatureType $maximumTemperature = null, \Mnm\StructType\DimensionType $floorSpaceMeasurementDimension = null, \Mnm\StructType\DimensionType $palletSpaceMeasurementDimension = null, array $shipmentDocumentReference = array(), array $customsDeclaration = array())
    {
        $this
            ->setID($iD)
            ->setTransportHandlingUnitTypeCode($transportHandlingUnitTypeCode)
            ->setHandlingCode($handlingCode)
            ->setHandlingInstructions($handlingInstructions)
            ->setHazardousRiskIndicator($hazardousRiskIndicator)
            ->setTotalGoodsItemQuantity($totalGoodsItemQuantity)
            ->setTotalPackageQuantity($totalPackageQuantity)
            ->setDamageRemarks($damageRemarks)
            ->setTraceID($traceID)
            ->setActualPackage($actualPackage)
            ->setTransportEquipment($transportEquipment)
            ->setTransportMeans($transportMeans)
            ->setHazardousGoodsTransit($hazardousGoodsTransit)
            ->setMeasurementDimension($measurementDimension)
            ->setMinimumTemperature($minimumTemperature)
            ->setMaximumTemperature($maximumTemperature)
            ->setFloorSpaceMeasurementDimension($floorSpaceMeasurementDimension)
            ->setPalletSpaceMeasurementDimension($palletSpaceMeasurementDimension)
            ->setShipmentDocumentReference($shipmentDocumentReference)
            ->setCustomsDeclaration($customsDeclaration);
    }
    /**
     * Get ID value
     * @return \Mnm\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\StructType\IDType $iD
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function setID(\Mnm\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get TransportHandlingUnitTypeCode value
     * @return \Mnm\StructType\TransportHandlingUnitTypeCodeType|null
     */
    public function getTransportHandlingUnitTypeCode()
    {
        return $this->TransportHandlingUnitTypeCode;
    }
    /**
     * Set TransportHandlingUnitTypeCode value
     * @param \Mnm\StructType\TransportHandlingUnitTypeCodeType $transportHandlingUnitTypeCode
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function setTransportHandlingUnitTypeCode(\Mnm\StructType\TransportHandlingUnitTypeCodeType $transportHandlingUnitTypeCode = null)
    {
        $this->TransportHandlingUnitTypeCode = $transportHandlingUnitTypeCode;
        return $this;
    }
    /**
     * Get HandlingCode value
     * @return \Mnm\StructType\HandlingCodeType|null
     */
    public function getHandlingCode()
    {
        return $this->HandlingCode;
    }
    /**
     * Set HandlingCode value
     * @param \Mnm\StructType\HandlingCodeType $handlingCode
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function setHandlingCode(\Mnm\StructType\HandlingCodeType $handlingCode = null)
    {
        $this->HandlingCode = $handlingCode;
        return $this;
    }
    /**
     * Get HandlingInstructions value
     * @return \Mnm\StructType\HandlingInstructionsType|null
     */
    public function getHandlingInstructions()
    {
        return $this->HandlingInstructions;
    }
    /**
     * Set HandlingInstructions value
     * @param \Mnm\StructType\HandlingInstructionsType $handlingInstructions
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function setHandlingInstructions(\Mnm\StructType\HandlingInstructionsType $handlingInstructions = null)
    {
        $this->HandlingInstructions = $handlingInstructions;
        return $this;
    }
    /**
     * Get HazardousRiskIndicator value
     * @return \Mnm\StructType\HazardousRiskIndicatorType|null
     */
    public function getHazardousRiskIndicator()
    {
        return $this->HazardousRiskIndicator;
    }
    /**
     * Set HazardousRiskIndicator value
     * @param \Mnm\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function setHazardousRiskIndicator(\Mnm\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator = null)
    {
        $this->HazardousRiskIndicator = $hazardousRiskIndicator;
        return $this;
    }
    /**
     * Get TotalGoodsItemQuantity value
     * @return \Mnm\StructType\TotalGoodsItemQuantityType|null
     */
    public function getTotalGoodsItemQuantity()
    {
        return $this->TotalGoodsItemQuantity;
    }
    /**
     * Set TotalGoodsItemQuantity value
     * @param \Mnm\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function setTotalGoodsItemQuantity(\Mnm\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity = null)
    {
        $this->TotalGoodsItemQuantity = $totalGoodsItemQuantity;
        return $this;
    }
    /**
     * Get TotalPackageQuantity value
     * @return \Mnm\StructType\TotalPackageQuantityType|null
     */
    public function getTotalPackageQuantity()
    {
        return $this->TotalPackageQuantity;
    }
    /**
     * Set TotalPackageQuantity value
     * @param \Mnm\StructType\TotalPackageQuantityType $totalPackageQuantity
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function setTotalPackageQuantity(\Mnm\StructType\TotalPackageQuantityType $totalPackageQuantity = null)
    {
        $this->TotalPackageQuantity = $totalPackageQuantity;
        return $this;
    }
    /**
     * Get DamageRemarks value
     * @return \Mnm\StructType\DamageRemarksType[]|null
     */
    public function getDamageRemarks()
    {
        return $this->DamageRemarks;
    }
    /**
     * Set DamageRemarks value
     * @param \Mnm\StructType\DamageRemarksType[] $damageRemarks
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function setDamageRemarks(array $damageRemarks = array())
    {
        $this->DamageRemarks = $damageRemarks;
        return $this;
    }
    /**
     * Add item to DamageRemarks value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\DamageRemarksType $item
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function addToDamageRemarks(\Mnm\StructType\DamageRemarksType $item)
    {
        $this->DamageRemarks[] = $item;
        return $this;
    }
    /**
     * Get TraceID value
     * @return \Mnm\StructType\TraceIDType|null
     */
    public function getTraceID()
    {
        return $this->TraceID;
    }
    /**
     * Set TraceID value
     * @param \Mnm\StructType\TraceIDType $traceID
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function setTraceID(\Mnm\StructType\TraceIDType $traceID = null)
    {
        $this->TraceID = $traceID;
        return $this;
    }
    /**
     * Get ActualPackage value
     * @return \Mnm\StructType\PackageType[]|null
     */
    public function getActualPackage()
    {
        return $this->ActualPackage;
    }
    /**
     * Set ActualPackage value
     * @param \Mnm\StructType\PackageType[] $actualPackage
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function setActualPackage(array $actualPackage = array())
    {
        $this->ActualPackage = $actualPackage;
        return $this;
    }
    /**
     * Add item to ActualPackage value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\PackageType $item
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function addToActualPackage(\Mnm\StructType\PackageType $item)
    {
        $this->ActualPackage[] = $item;
        return $this;
    }
    /**
     * Get TransportEquipment value
     * @return \Mnm\StructType\TransportEquipmentType[]|null
     */
    public function getTransportEquipment()
    {
        return $this->TransportEquipment;
    }
    /**
     * Set TransportEquipment value
     * @param \Mnm\StructType\TransportEquipmentType[] $transportEquipment
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function setTransportEquipment(array $transportEquipment = array())
    {
        $this->TransportEquipment = $transportEquipment;
        return $this;
    }
    /**
     * Add item to TransportEquipment value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\TransportEquipmentType $item
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function addToTransportEquipment(\Mnm\StructType\TransportEquipmentType $item)
    {
        $this->TransportEquipment[] = $item;
        return $this;
    }
    /**
     * Get TransportMeans value
     * @return \Mnm\StructType\TransportMeansType[]|null
     */
    public function getTransportMeans()
    {
        return $this->TransportMeans;
    }
    /**
     * Set TransportMeans value
     * @param \Mnm\StructType\TransportMeansType[] $transportMeans
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function setTransportMeans(array $transportMeans = array())
    {
        $this->TransportMeans = $transportMeans;
        return $this;
    }
    /**
     * Add item to TransportMeans value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\TransportMeansType $item
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function addToTransportMeans(\Mnm\StructType\TransportMeansType $item)
    {
        $this->TransportMeans[] = $item;
        return $this;
    }
    /**
     * Get HazardousGoodsTransit value
     * @return \Mnm\StructType\HazardousGoodsTransitType[]|null
     */
    public function getHazardousGoodsTransit()
    {
        return $this->HazardousGoodsTransit;
    }
    /**
     * Set HazardousGoodsTransit value
     * @param \Mnm\StructType\HazardousGoodsTransitType[] $hazardousGoodsTransit
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function setHazardousGoodsTransit(array $hazardousGoodsTransit = array())
    {
        $this->HazardousGoodsTransit = $hazardousGoodsTransit;
        return $this;
    }
    /**
     * Add item to HazardousGoodsTransit value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\HazardousGoodsTransitType $item
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function addToHazardousGoodsTransit(\Mnm\StructType\HazardousGoodsTransitType $item)
    {
        $this->HazardousGoodsTransit[] = $item;
        return $this;
    }
    /**
     * Get MeasurementDimension value
     * @return \Mnm\StructType\DimensionType[]|null
     */
    public function getMeasurementDimension()
    {
        return $this->MeasurementDimension;
    }
    /**
     * Set MeasurementDimension value
     * @param \Mnm\StructType\DimensionType[] $measurementDimension
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function setMeasurementDimension(array $measurementDimension = array())
    {
        $this->MeasurementDimension = $measurementDimension;
        return $this;
    }
    /**
     * Add item to MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\DimensionType $item
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function addToMeasurementDimension(\Mnm\StructType\DimensionType $item)
    {
        $this->MeasurementDimension[] = $item;
        return $this;
    }
    /**
     * Get MinimumTemperature value
     * @return \Mnm\StructType\TemperatureType|null
     */
    public function getMinimumTemperature()
    {
        return $this->MinimumTemperature;
    }
    /**
     * Set MinimumTemperature value
     * @param \Mnm\StructType\TemperatureType $minimumTemperature
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function setMinimumTemperature(\Mnm\StructType\TemperatureType $minimumTemperature = null)
    {
        $this->MinimumTemperature = $minimumTemperature;
        return $this;
    }
    /**
     * Get MaximumTemperature value
     * @return \Mnm\StructType\TemperatureType|null
     */
    public function getMaximumTemperature()
    {
        return $this->MaximumTemperature;
    }
    /**
     * Set MaximumTemperature value
     * @param \Mnm\StructType\TemperatureType $maximumTemperature
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function setMaximumTemperature(\Mnm\StructType\TemperatureType $maximumTemperature = null)
    {
        $this->MaximumTemperature = $maximumTemperature;
        return $this;
    }
    /**
     * Get FloorSpaceMeasurementDimension value
     * @return \Mnm\StructType\DimensionType|null
     */
    public function getFloorSpaceMeasurementDimension()
    {
        return $this->FloorSpaceMeasurementDimension;
    }
    /**
     * Set FloorSpaceMeasurementDimension value
     * @param \Mnm\StructType\DimensionType $floorSpaceMeasurementDimension
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function setFloorSpaceMeasurementDimension(\Mnm\StructType\DimensionType $floorSpaceMeasurementDimension = null)
    {
        $this->FloorSpaceMeasurementDimension = $floorSpaceMeasurementDimension;
        return $this;
    }
    /**
     * Get PalletSpaceMeasurementDimension value
     * @return \Mnm\StructType\DimensionType|null
     */
    public function getPalletSpaceMeasurementDimension()
    {
        return $this->PalletSpaceMeasurementDimension;
    }
    /**
     * Set PalletSpaceMeasurementDimension value
     * @param \Mnm\StructType\DimensionType $palletSpaceMeasurementDimension
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function setPalletSpaceMeasurementDimension(\Mnm\StructType\DimensionType $palletSpaceMeasurementDimension = null)
    {
        $this->PalletSpaceMeasurementDimension = $palletSpaceMeasurementDimension;
        return $this;
    }
    /**
     * Get ShipmentDocumentReference value
     * @return \Mnm\StructType\DocumentReferenceType[]|null
     */
    public function getShipmentDocumentReference()
    {
        return $this->ShipmentDocumentReference;
    }
    /**
     * Set ShipmentDocumentReference value
     * @param \Mnm\StructType\DocumentReferenceType[] $shipmentDocumentReference
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function setShipmentDocumentReference(array $shipmentDocumentReference = array())
    {
        $this->ShipmentDocumentReference = $shipmentDocumentReference;
        return $this;
    }
    /**
     * Add item to ShipmentDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\DocumentReferenceType $item
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function addToShipmentDocumentReference(\Mnm\StructType\DocumentReferenceType $item)
    {
        $this->ShipmentDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get CustomsDeclaration value
     * @return \Mnm\StructType\CustomsDeclarationType[]|null
     */
    public function getCustomsDeclaration()
    {
        return $this->CustomsDeclaration;
    }
    /**
     * Set CustomsDeclaration value
     * @param \Mnm\StructType\CustomsDeclarationType[] $customsDeclaration
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function setCustomsDeclaration(array $customsDeclaration = array())
    {
        $this->CustomsDeclaration = $customsDeclaration;
        return $this;
    }
    /**
     * Add item to CustomsDeclaration value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\CustomsDeclarationType $item
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public function addToCustomsDeclaration(\Mnm\StructType\CustomsDeclarationType $item)
    {
        $this->CustomsDeclaration[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\TransportHandlingUnitType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
