<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentMeansType StructType
 * @subpackage Structs
 */
class PaymentMeansType extends AbstractStructBase
{
    /**
     * The PaymentMeansCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q239:PaymentMeansCode
     * @var \Mnm\StructType\PaymentMeansCodeType
     */
    public $PaymentMeansCode;
    /**
     * The PaymentDueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q240:PaymentDueDate
     * @var \Mnm\StructType\PaymentDueDateType
     */
    public $PaymentDueDate;
    /**
     * The PaymentChannelCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q241:PaymentChannelCode
     * @var \Mnm\StructType\PaymentChannelCodeType
     */
    public $PaymentChannelCode;
    /**
     * The InstructionNote
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q242:InstructionNote
     * @var \Mnm\StructType\InstructionNoteType
     */
    public $InstructionNote;
    /**
     * The PayerFinancialAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\FinancialAccountType
     */
    public $PayerFinancialAccount;
    /**
     * The PayeeFinancialAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\FinancialAccountType
     */
    public $PayeeFinancialAccount;
    /**
     * Constructor method for PaymentMeansType
     * @uses PaymentMeansType::setPaymentMeansCode()
     * @uses PaymentMeansType::setPaymentDueDate()
     * @uses PaymentMeansType::setPaymentChannelCode()
     * @uses PaymentMeansType::setInstructionNote()
     * @uses PaymentMeansType::setPayerFinancialAccount()
     * @uses PaymentMeansType::setPayeeFinancialAccount()
     * @param \Mnm\StructType\PaymentMeansCodeType $paymentMeansCode
     * @param \Mnm\StructType\PaymentDueDateType $paymentDueDate
     * @param \Mnm\StructType\PaymentChannelCodeType $paymentChannelCode
     * @param \Mnm\StructType\InstructionNoteType $instructionNote
     * @param \Mnm\StructType\FinancialAccountType $payerFinancialAccount
     * @param \Mnm\StructType\FinancialAccountType $payeeFinancialAccount
     */
    public function __construct(\Mnm\StructType\PaymentMeansCodeType $paymentMeansCode = null, \Mnm\StructType\PaymentDueDateType $paymentDueDate = null, \Mnm\StructType\PaymentChannelCodeType $paymentChannelCode = null, \Mnm\StructType\InstructionNoteType $instructionNote = null, \Mnm\StructType\FinancialAccountType $payerFinancialAccount = null, \Mnm\StructType\FinancialAccountType $payeeFinancialAccount = null)
    {
        $this
            ->setPaymentMeansCode($paymentMeansCode)
            ->setPaymentDueDate($paymentDueDate)
            ->setPaymentChannelCode($paymentChannelCode)
            ->setInstructionNote($instructionNote)
            ->setPayerFinancialAccount($payerFinancialAccount)
            ->setPayeeFinancialAccount($payeeFinancialAccount);
    }
    /**
     * Get PaymentMeansCode value
     * @return \Mnm\StructType\PaymentMeansCodeType|null
     */
    public function getPaymentMeansCode()
    {
        return $this->PaymentMeansCode;
    }
    /**
     * Set PaymentMeansCode value
     * @param \Mnm\StructType\PaymentMeansCodeType $paymentMeansCode
     * @return \Mnm\StructType\PaymentMeansType
     */
    public function setPaymentMeansCode(\Mnm\StructType\PaymentMeansCodeType $paymentMeansCode = null)
    {
        $this->PaymentMeansCode = $paymentMeansCode;
        return $this;
    }
    /**
     * Get PaymentDueDate value
     * @return \Mnm\StructType\PaymentDueDateType|null
     */
    public function getPaymentDueDate()
    {
        return $this->PaymentDueDate;
    }
    /**
     * Set PaymentDueDate value
     * @param \Mnm\StructType\PaymentDueDateType $paymentDueDate
     * @return \Mnm\StructType\PaymentMeansType
     */
    public function setPaymentDueDate(\Mnm\StructType\PaymentDueDateType $paymentDueDate = null)
    {
        $this->PaymentDueDate = $paymentDueDate;
        return $this;
    }
    /**
     * Get PaymentChannelCode value
     * @return \Mnm\StructType\PaymentChannelCodeType|null
     */
    public function getPaymentChannelCode()
    {
        return $this->PaymentChannelCode;
    }
    /**
     * Set PaymentChannelCode value
     * @param \Mnm\StructType\PaymentChannelCodeType $paymentChannelCode
     * @return \Mnm\StructType\PaymentMeansType
     */
    public function setPaymentChannelCode(\Mnm\StructType\PaymentChannelCodeType $paymentChannelCode = null)
    {
        $this->PaymentChannelCode = $paymentChannelCode;
        return $this;
    }
    /**
     * Get InstructionNote value
     * @return \Mnm\StructType\InstructionNoteType|null
     */
    public function getInstructionNote()
    {
        return $this->InstructionNote;
    }
    /**
     * Set InstructionNote value
     * @param \Mnm\StructType\InstructionNoteType $instructionNote
     * @return \Mnm\StructType\PaymentMeansType
     */
    public function setInstructionNote(\Mnm\StructType\InstructionNoteType $instructionNote = null)
    {
        $this->InstructionNote = $instructionNote;
        return $this;
    }
    /**
     * Get PayerFinancialAccount value
     * @return \Mnm\StructType\FinancialAccountType|null
     */
    public function getPayerFinancialAccount()
    {
        return $this->PayerFinancialAccount;
    }
    /**
     * Set PayerFinancialAccount value
     * @param \Mnm\StructType\FinancialAccountType $payerFinancialAccount
     * @return \Mnm\StructType\PaymentMeansType
     */
    public function setPayerFinancialAccount(\Mnm\StructType\FinancialAccountType $payerFinancialAccount = null)
    {
        $this->PayerFinancialAccount = $payerFinancialAccount;
        return $this;
    }
    /**
     * Get PayeeFinancialAccount value
     * @return \Mnm\StructType\FinancialAccountType|null
     */
    public function getPayeeFinancialAccount()
    {
        return $this->PayeeFinancialAccount;
    }
    /**
     * Set PayeeFinancialAccount value
     * @param \Mnm\StructType\FinancialAccountType $payeeFinancialAccount
     * @return \Mnm\StructType\PaymentMeansType
     */
    public function setPayeeFinancialAccount(\Mnm\StructType\FinancialAccountType $payeeFinancialAccount = null)
    {
        $this->PayeeFinancialAccount = $payeeFinancialAccount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\PaymentMeansType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
