<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageType StructType
 * @subpackage Structs
 */
class PackageType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q224:ID
     * @var \Mnm\StructType\IDType
     */
    public $ID;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q225:Quantity
     * @var \Mnm\StructType\QuantityType
     */
    public $Quantity;
    /**
     * The ReturnableMaterialIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q226:ReturnableMaterialIndicator
     * @var \Mnm\StructType\ReturnableMaterialIndicatorType
     */
    public $ReturnableMaterialIndicator;
    /**
     * The PackageLevelCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q227:PackageLevelCode
     * @var \Mnm\StructType\PackageLevelCodeType
     */
    public $PackageLevelCode;
    /**
     * The PackagingTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q228:PackagingTypeCode
     * @var \Mnm\StructType\PackagingTypeCodeType
     */
    public $PackagingTypeCode;
    /**
     * The PackingMaterial
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q229:PackingMaterial
     * @var \Mnm\StructType\PackingMaterialType[]
     */
    public $PackingMaterial;
    /**
     * The ContainedPackage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\PackageType[]
     */
    public $ContainedPackage;
    /**
     * The GoodsItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\GoodsItemType[]
     */
    public $GoodsItem;
    /**
     * The MeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\DimensionType[]
     */
    public $MeasurementDimension;
    /**
     * Constructor method for PackageType
     * @uses PackageType::setID()
     * @uses PackageType::setQuantity()
     * @uses PackageType::setReturnableMaterialIndicator()
     * @uses PackageType::setPackageLevelCode()
     * @uses PackageType::setPackagingTypeCode()
     * @uses PackageType::setPackingMaterial()
     * @uses PackageType::setContainedPackage()
     * @uses PackageType::setGoodsItem()
     * @uses PackageType::setMeasurementDimension()
     * @param \Mnm\StructType\IDType $iD
     * @param \Mnm\StructType\QuantityType $quantity
     * @param \Mnm\StructType\ReturnableMaterialIndicatorType $returnableMaterialIndicator
     * @param \Mnm\StructType\PackageLevelCodeType $packageLevelCode
     * @param \Mnm\StructType\PackagingTypeCodeType $packagingTypeCode
     * @param \Mnm\StructType\PackingMaterialType[] $packingMaterial
     * @param \Mnm\StructType\PackageType[] $containedPackage
     * @param \Mnm\StructType\GoodsItemType[] $goodsItem
     * @param \Mnm\StructType\DimensionType[] $measurementDimension
     */
    public function __construct(\Mnm\StructType\IDType $iD = null, \Mnm\StructType\QuantityType $quantity = null, \Mnm\StructType\ReturnableMaterialIndicatorType $returnableMaterialIndicator = null, \Mnm\StructType\PackageLevelCodeType $packageLevelCode = null, \Mnm\StructType\PackagingTypeCodeType $packagingTypeCode = null, array $packingMaterial = array(), array $containedPackage = array(), array $goodsItem = array(), array $measurementDimension = array())
    {
        $this
            ->setID($iD)
            ->setQuantity($quantity)
            ->setReturnableMaterialIndicator($returnableMaterialIndicator)
            ->setPackageLevelCode($packageLevelCode)
            ->setPackagingTypeCode($packagingTypeCode)
            ->setPackingMaterial($packingMaterial)
            ->setContainedPackage($containedPackage)
            ->setGoodsItem($goodsItem)
            ->setMeasurementDimension($measurementDimension);
    }
    /**
     * Get ID value
     * @return \Mnm\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\StructType\IDType $iD
     * @return \Mnm\StructType\PackageType
     */
    public function setID(\Mnm\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Quantity value
     * @return \Mnm\StructType\QuantityType|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param \Mnm\StructType\QuantityType $quantity
     * @return \Mnm\StructType\PackageType
     */
    public function setQuantity(\Mnm\StructType\QuantityType $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get ReturnableMaterialIndicator value
     * @return \Mnm\StructType\ReturnableMaterialIndicatorType|null
     */
    public function getReturnableMaterialIndicator()
    {
        return $this->ReturnableMaterialIndicator;
    }
    /**
     * Set ReturnableMaterialIndicator value
     * @param \Mnm\StructType\ReturnableMaterialIndicatorType $returnableMaterialIndicator
     * @return \Mnm\StructType\PackageType
     */
    public function setReturnableMaterialIndicator(\Mnm\StructType\ReturnableMaterialIndicatorType $returnableMaterialIndicator = null)
    {
        $this->ReturnableMaterialIndicator = $returnableMaterialIndicator;
        return $this;
    }
    /**
     * Get PackageLevelCode value
     * @return \Mnm\StructType\PackageLevelCodeType|null
     */
    public function getPackageLevelCode()
    {
        return $this->PackageLevelCode;
    }
    /**
     * Set PackageLevelCode value
     * @param \Mnm\StructType\PackageLevelCodeType $packageLevelCode
     * @return \Mnm\StructType\PackageType
     */
    public function setPackageLevelCode(\Mnm\StructType\PackageLevelCodeType $packageLevelCode = null)
    {
        $this->PackageLevelCode = $packageLevelCode;
        return $this;
    }
    /**
     * Get PackagingTypeCode value
     * @return \Mnm\StructType\PackagingTypeCodeType|null
     */
    public function getPackagingTypeCode()
    {
        return $this->PackagingTypeCode;
    }
    /**
     * Set PackagingTypeCode value
     * @param \Mnm\StructType\PackagingTypeCodeType $packagingTypeCode
     * @return \Mnm\StructType\PackageType
     */
    public function setPackagingTypeCode(\Mnm\StructType\PackagingTypeCodeType $packagingTypeCode = null)
    {
        $this->PackagingTypeCode = $packagingTypeCode;
        return $this;
    }
    /**
     * Get PackingMaterial value
     * @return \Mnm\StructType\PackingMaterialType[]|null
     */
    public function getPackingMaterial()
    {
        return $this->PackingMaterial;
    }
    /**
     * Set PackingMaterial value
     * @param \Mnm\StructType\PackingMaterialType[] $packingMaterial
     * @return \Mnm\StructType\PackageType
     */
    public function setPackingMaterial(array $packingMaterial = array())
    {
        $this->PackingMaterial = $packingMaterial;
        return $this;
    }
    /**
     * Add item to PackingMaterial value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\PackingMaterialType $item
     * @return \Mnm\StructType\PackageType
     */
    public function addToPackingMaterial(\Mnm\StructType\PackingMaterialType $item)
    {
        $this->PackingMaterial[] = $item;
        return $this;
    }
    /**
     * Get ContainedPackage value
     * @return \Mnm\StructType\PackageType[]|null
     */
    public function getContainedPackage()
    {
        return $this->ContainedPackage;
    }
    /**
     * Set ContainedPackage value
     * @param \Mnm\StructType\PackageType[] $containedPackage
     * @return \Mnm\StructType\PackageType
     */
    public function setContainedPackage(array $containedPackage = array())
    {
        $this->ContainedPackage = $containedPackage;
        return $this;
    }
    /**
     * Add item to ContainedPackage value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\PackageType $item
     * @return \Mnm\StructType\PackageType
     */
    public function addToContainedPackage(\Mnm\StructType\PackageType $item)
    {
        $this->ContainedPackage[] = $item;
        return $this;
    }
    /**
     * Get GoodsItem value
     * @return \Mnm\StructType\GoodsItemType[]|null
     */
    public function getGoodsItem()
    {
        return $this->GoodsItem;
    }
    /**
     * Set GoodsItem value
     * @param \Mnm\StructType\GoodsItemType[] $goodsItem
     * @return \Mnm\StructType\PackageType
     */
    public function setGoodsItem(array $goodsItem = array())
    {
        $this->GoodsItem = $goodsItem;
        return $this;
    }
    /**
     * Add item to GoodsItem value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\GoodsItemType $item
     * @return \Mnm\StructType\PackageType
     */
    public function addToGoodsItem(\Mnm\StructType\GoodsItemType $item)
    {
        $this->GoodsItem[] = $item;
        return $this;
    }
    /**
     * Get MeasurementDimension value
     * @return \Mnm\StructType\DimensionType[]|null
     */
    public function getMeasurementDimension()
    {
        return $this->MeasurementDimension;
    }
    /**
     * Set MeasurementDimension value
     * @param \Mnm\StructType\DimensionType[] $measurementDimension
     * @return \Mnm\StructType\PackageType
     */
    public function setMeasurementDimension(array $measurementDimension = array())
    {
        $this->MeasurementDimension = $measurementDimension;
        return $this;
    }
    /**
     * Add item to MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\DimensionType $item
     * @return \Mnm\StructType\PackageType
     */
    public function addToMeasurementDimension(\Mnm\StructType\DimensionType $item)
    {
        $this->MeasurementDimension[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\PackageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
