<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceStatusInfo StructType
 * @subpackage Structs
 */
class InvoiceStatusInfo extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $StatusCode;
    /**
     * The InvoiceId
     * @var string
     */
    public $InvoiceId;
    /**
     * The Message
     * @var string
     */
    public $Message;
    /**
     * Constructor method for InvoiceStatusInfo
     * @uses InvoiceStatusInfo::setStatus()
     * @uses InvoiceStatusInfo::setStatusCode()
     * @uses InvoiceStatusInfo::setInvoiceId()
     * @uses InvoiceStatusInfo::setMessage()
     * @param string $status
     * @param int $statusCode
     * @param string $invoiceId
     * @param string $message
     */
    public function __construct($status = null, $statusCode = null, $invoiceId = null, $message = null)
    {
        $this
            ->setStatus($status)
            ->setStatusCode($statusCode)
            ->setInvoiceId($invoiceId)
            ->setMessage($message);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Mnm\StructType\InvoiceStatusInfo
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return int
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param int $statusCode
     * @return \Mnm\StructType\InvoiceStatusInfo
     */
    public function setStatusCode($statusCode = null)
    {
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get InvoiceId value
     * @return string|null
     */
    public function getInvoiceId()
    {
        return $this->InvoiceId;
    }
    /**
     * Set InvoiceId value
     * @param string $invoiceId
     * @return \Mnm\StructType\InvoiceStatusInfo
     */
    public function setInvoiceId($invoiceId = null)
    {
        $this->InvoiceId = $invoiceId;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Mnm\StructType\InvoiceStatusInfo
     */
    public function setMessage($message = null)
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\InvoiceStatusInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
