<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HazardousGoodsTransitType StructType
 * @subpackage Structs
 */
class HazardousGoodsTransitType extends AbstractStructBase
{
    /**
     * The TransportEmergencyCardCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q233:TransportEmergencyCardCode
     * @var \Mnm\StructType\TransportEmergencyCardCodeType
     */
    public $TransportEmergencyCardCode;
    /**
     * The PackingCriteriaCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q234:PackingCriteriaCode
     * @var \Mnm\StructType\PackingCriteriaCodeType
     */
    public $PackingCriteriaCode;
    /**
     * The HazardousRegulationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q235:HazardousRegulationCode
     * @var \Mnm\StructType\HazardousRegulationCodeType
     */
    public $HazardousRegulationCode;
    /**
     * The InhalationToxicityZoneCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q236:InhalationToxicityZoneCode
     * @var \Mnm\StructType\InhalationToxicityZoneCodeType
     */
    public $InhalationToxicityZoneCode;
    /**
     * The TransportAuthorizationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q237:TransportAuthorizationCode
     * @var \Mnm\StructType\TransportAuthorizationCodeType
     */
    public $TransportAuthorizationCode;
    /**
     * The MaximumTemperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\TemperatureType
     */
    public $MaximumTemperature;
    /**
     * The MinimumTemperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\TemperatureType
     */
    public $MinimumTemperature;
    /**
     * Constructor method for HazardousGoodsTransitType
     * @uses HazardousGoodsTransitType::setTransportEmergencyCardCode()
     * @uses HazardousGoodsTransitType::setPackingCriteriaCode()
     * @uses HazardousGoodsTransitType::setHazardousRegulationCode()
     * @uses HazardousGoodsTransitType::setInhalationToxicityZoneCode()
     * @uses HazardousGoodsTransitType::setTransportAuthorizationCode()
     * @uses HazardousGoodsTransitType::setMaximumTemperature()
     * @uses HazardousGoodsTransitType::setMinimumTemperature()
     * @param \Mnm\StructType\TransportEmergencyCardCodeType $transportEmergencyCardCode
     * @param \Mnm\StructType\PackingCriteriaCodeType $packingCriteriaCode
     * @param \Mnm\StructType\HazardousRegulationCodeType $hazardousRegulationCode
     * @param \Mnm\StructType\InhalationToxicityZoneCodeType $inhalationToxicityZoneCode
     * @param \Mnm\StructType\TransportAuthorizationCodeType $transportAuthorizationCode
     * @param \Mnm\StructType\TemperatureType $maximumTemperature
     * @param \Mnm\StructType\TemperatureType $minimumTemperature
     */
    public function __construct(\Mnm\StructType\TransportEmergencyCardCodeType $transportEmergencyCardCode = null, \Mnm\StructType\PackingCriteriaCodeType $packingCriteriaCode = null, \Mnm\StructType\HazardousRegulationCodeType $hazardousRegulationCode = null, \Mnm\StructType\InhalationToxicityZoneCodeType $inhalationToxicityZoneCode = null, \Mnm\StructType\TransportAuthorizationCodeType $transportAuthorizationCode = null, \Mnm\StructType\TemperatureType $maximumTemperature = null, \Mnm\StructType\TemperatureType $minimumTemperature = null)
    {
        $this
            ->setTransportEmergencyCardCode($transportEmergencyCardCode)
            ->setPackingCriteriaCode($packingCriteriaCode)
            ->setHazardousRegulationCode($hazardousRegulationCode)
            ->setInhalationToxicityZoneCode($inhalationToxicityZoneCode)
            ->setTransportAuthorizationCode($transportAuthorizationCode)
            ->setMaximumTemperature($maximumTemperature)
            ->setMinimumTemperature($minimumTemperature);
    }
    /**
     * Get TransportEmergencyCardCode value
     * @return \Mnm\StructType\TransportEmergencyCardCodeType|null
     */
    public function getTransportEmergencyCardCode()
    {
        return $this->TransportEmergencyCardCode;
    }
    /**
     * Set TransportEmergencyCardCode value
     * @param \Mnm\StructType\TransportEmergencyCardCodeType $transportEmergencyCardCode
     * @return \Mnm\StructType\HazardousGoodsTransitType
     */
    public function setTransportEmergencyCardCode(\Mnm\StructType\TransportEmergencyCardCodeType $transportEmergencyCardCode = null)
    {
        $this->TransportEmergencyCardCode = $transportEmergencyCardCode;
        return $this;
    }
    /**
     * Get PackingCriteriaCode value
     * @return \Mnm\StructType\PackingCriteriaCodeType|null
     */
    public function getPackingCriteriaCode()
    {
        return $this->PackingCriteriaCode;
    }
    /**
     * Set PackingCriteriaCode value
     * @param \Mnm\StructType\PackingCriteriaCodeType $packingCriteriaCode
     * @return \Mnm\StructType\HazardousGoodsTransitType
     */
    public function setPackingCriteriaCode(\Mnm\StructType\PackingCriteriaCodeType $packingCriteriaCode = null)
    {
        $this->PackingCriteriaCode = $packingCriteriaCode;
        return $this;
    }
    /**
     * Get HazardousRegulationCode value
     * @return \Mnm\StructType\HazardousRegulationCodeType|null
     */
    public function getHazardousRegulationCode()
    {
        return $this->HazardousRegulationCode;
    }
    /**
     * Set HazardousRegulationCode value
     * @param \Mnm\StructType\HazardousRegulationCodeType $hazardousRegulationCode
     * @return \Mnm\StructType\HazardousGoodsTransitType
     */
    public function setHazardousRegulationCode(\Mnm\StructType\HazardousRegulationCodeType $hazardousRegulationCode = null)
    {
        $this->HazardousRegulationCode = $hazardousRegulationCode;
        return $this;
    }
    /**
     * Get InhalationToxicityZoneCode value
     * @return \Mnm\StructType\InhalationToxicityZoneCodeType|null
     */
    public function getInhalationToxicityZoneCode()
    {
        return $this->InhalationToxicityZoneCode;
    }
    /**
     * Set InhalationToxicityZoneCode value
     * @param \Mnm\StructType\InhalationToxicityZoneCodeType $inhalationToxicityZoneCode
     * @return \Mnm\StructType\HazardousGoodsTransitType
     */
    public function setInhalationToxicityZoneCode(\Mnm\StructType\InhalationToxicityZoneCodeType $inhalationToxicityZoneCode = null)
    {
        $this->InhalationToxicityZoneCode = $inhalationToxicityZoneCode;
        return $this;
    }
    /**
     * Get TransportAuthorizationCode value
     * @return \Mnm\StructType\TransportAuthorizationCodeType|null
     */
    public function getTransportAuthorizationCode()
    {
        return $this->TransportAuthorizationCode;
    }
    /**
     * Set TransportAuthorizationCode value
     * @param \Mnm\StructType\TransportAuthorizationCodeType $transportAuthorizationCode
     * @return \Mnm\StructType\HazardousGoodsTransitType
     */
    public function setTransportAuthorizationCode(\Mnm\StructType\TransportAuthorizationCodeType $transportAuthorizationCode = null)
    {
        $this->TransportAuthorizationCode = $transportAuthorizationCode;
        return $this;
    }
    /**
     * Get MaximumTemperature value
     * @return \Mnm\StructType\TemperatureType|null
     */
    public function getMaximumTemperature()
    {
        return $this->MaximumTemperature;
    }
    /**
     * Set MaximumTemperature value
     * @param \Mnm\StructType\TemperatureType $maximumTemperature
     * @return \Mnm\StructType\HazardousGoodsTransitType
     */
    public function setMaximumTemperature(\Mnm\StructType\TemperatureType $maximumTemperature = null)
    {
        $this->MaximumTemperature = $maximumTemperature;
        return $this;
    }
    /**
     * Get MinimumTemperature value
     * @return \Mnm\StructType\TemperatureType|null
     */
    public function getMinimumTemperature()
    {
        return $this->MinimumTemperature;
    }
    /**
     * Set MinimumTemperature value
     * @param \Mnm\StructType\TemperatureType $minimumTemperature
     * @return \Mnm\StructType\HazardousGoodsTransitType
     */
    public function setMinimumTemperature(\Mnm\StructType\TemperatureType $minimumTemperature = null)
    {
        $this->MinimumTemperature = $minimumTemperature;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\HazardousGoodsTransitType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
