<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DespatchType StructType
 * @subpackage Structs
 */
class DespatchType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q89:ID
     * @var \Mnm\StructType\IDType
     */
    public $ID;
    /**
     * The ActualDespatchDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q90:ActualDespatchDate
     * @var \Mnm\StructType\ActualDespatchDateType
     */
    public $ActualDespatchDate;
    /**
     * The ActualDespatchTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q91:ActualDespatchTime
     * @var \Mnm\StructType\ActualDespatchTimeType
     */
    public $ActualDespatchTime;
    /**
     * The Instructions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q92:Instructions
     * @var \Mnm\StructType\InstructionsType
     */
    public $Instructions;
    /**
     * The DespatchAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\AddressType
     */
    public $DespatchAddress;
    /**
     * The DespatchParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\PartyType
     */
    public $DespatchParty;
    /**
     * The Contact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\ContactType
     */
    public $Contact;
    /**
     * The EstimatedDespatchPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\PeriodType
     */
    public $EstimatedDespatchPeriod;
    /**
     * Constructor method for DespatchType
     * @uses DespatchType::setID()
     * @uses DespatchType::setActualDespatchDate()
     * @uses DespatchType::setActualDespatchTime()
     * @uses DespatchType::setInstructions()
     * @uses DespatchType::setDespatchAddress()
     * @uses DespatchType::setDespatchParty()
     * @uses DespatchType::setContact()
     * @uses DespatchType::setEstimatedDespatchPeriod()
     * @param \Mnm\StructType\IDType $iD
     * @param \Mnm\StructType\ActualDespatchDateType $actualDespatchDate
     * @param \Mnm\StructType\ActualDespatchTimeType $actualDespatchTime
     * @param \Mnm\StructType\InstructionsType $instructions
     * @param \Mnm\StructType\AddressType $despatchAddress
     * @param \Mnm\StructType\PartyType $despatchParty
     * @param \Mnm\StructType\ContactType $contact
     * @param \Mnm\StructType\PeriodType $estimatedDespatchPeriod
     */
    public function __construct(\Mnm\StructType\IDType $iD = null, \Mnm\StructType\ActualDespatchDateType $actualDespatchDate = null, \Mnm\StructType\ActualDespatchTimeType $actualDespatchTime = null, \Mnm\StructType\InstructionsType $instructions = null, \Mnm\StructType\AddressType $despatchAddress = null, \Mnm\StructType\PartyType $despatchParty = null, \Mnm\StructType\ContactType $contact = null, \Mnm\StructType\PeriodType $estimatedDespatchPeriod = null)
    {
        $this
            ->setID($iD)
            ->setActualDespatchDate($actualDespatchDate)
            ->setActualDespatchTime($actualDespatchTime)
            ->setInstructions($instructions)
            ->setDespatchAddress($despatchAddress)
            ->setDespatchParty($despatchParty)
            ->setContact($contact)
            ->setEstimatedDespatchPeriod($estimatedDespatchPeriod);
    }
    /**
     * Get ID value
     * @return \Mnm\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\StructType\IDType $iD
     * @return \Mnm\StructType\DespatchType
     */
    public function setID(\Mnm\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get ActualDespatchDate value
     * @return \Mnm\StructType\ActualDespatchDateType|null
     */
    public function getActualDespatchDate()
    {
        return $this->ActualDespatchDate;
    }
    /**
     * Set ActualDespatchDate value
     * @param \Mnm\StructType\ActualDespatchDateType $actualDespatchDate
     * @return \Mnm\StructType\DespatchType
     */
    public function setActualDespatchDate(\Mnm\StructType\ActualDespatchDateType $actualDespatchDate = null)
    {
        $this->ActualDespatchDate = $actualDespatchDate;
        return $this;
    }
    /**
     * Get ActualDespatchTime value
     * @return \Mnm\StructType\ActualDespatchTimeType|null
     */
    public function getActualDespatchTime()
    {
        return $this->ActualDespatchTime;
    }
    /**
     * Set ActualDespatchTime value
     * @param \Mnm\StructType\ActualDespatchTimeType $actualDespatchTime
     * @return \Mnm\StructType\DespatchType
     */
    public function setActualDespatchTime(\Mnm\StructType\ActualDespatchTimeType $actualDespatchTime = null)
    {
        $this->ActualDespatchTime = $actualDespatchTime;
        return $this;
    }
    /**
     * Get Instructions value
     * @return \Mnm\StructType\InstructionsType|null
     */
    public function getInstructions()
    {
        return $this->Instructions;
    }
    /**
     * Set Instructions value
     * @param \Mnm\StructType\InstructionsType $instructions
     * @return \Mnm\StructType\DespatchType
     */
    public function setInstructions(\Mnm\StructType\InstructionsType $instructions = null)
    {
        $this->Instructions = $instructions;
        return $this;
    }
    /**
     * Get DespatchAddress value
     * @return \Mnm\StructType\AddressType|null
     */
    public function getDespatchAddress()
    {
        return $this->DespatchAddress;
    }
    /**
     * Set DespatchAddress value
     * @param \Mnm\StructType\AddressType $despatchAddress
     * @return \Mnm\StructType\DespatchType
     */
    public function setDespatchAddress(\Mnm\StructType\AddressType $despatchAddress = null)
    {
        $this->DespatchAddress = $despatchAddress;
        return $this;
    }
    /**
     * Get DespatchParty value
     * @return \Mnm\StructType\PartyType|null
     */
    public function getDespatchParty()
    {
        return $this->DespatchParty;
    }
    /**
     * Set DespatchParty value
     * @param \Mnm\StructType\PartyType $despatchParty
     * @return \Mnm\StructType\DespatchType
     */
    public function setDespatchParty(\Mnm\StructType\PartyType $despatchParty = null)
    {
        $this->DespatchParty = $despatchParty;
        return $this;
    }
    /**
     * Get Contact value
     * @return \Mnm\StructType\ContactType|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \Mnm\StructType\ContactType $contact
     * @return \Mnm\StructType\DespatchType
     */
    public function setContact(\Mnm\StructType\ContactType $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get EstimatedDespatchPeriod value
     * @return \Mnm\StructType\PeriodType|null
     */
    public function getEstimatedDespatchPeriod()
    {
        return $this->EstimatedDespatchPeriod;
    }
    /**
     * Set EstimatedDespatchPeriod value
     * @param \Mnm\StructType\PeriodType $estimatedDespatchPeriod
     * @return \Mnm\StructType\DespatchType
     */
    public function setEstimatedDespatchPeriod(\Mnm\StructType\PeriodType $estimatedDespatchPeriod = null)
    {
        $this->EstimatedDespatchPeriod = $estimatedDespatchPeriod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\DespatchType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
