<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportMeansType StructType
 * @subpackage Structs
 */
class TransportMeansType extends AbstractStructBase
{
    /**
     * The JourneyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q197:JourneyID
     * @var \Mnm\StructType\JourneyIDType
     */
    public $JourneyID;
    /**
     * The RegistrationNationalityID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q198:RegistrationNationalityID
     * @var \Mnm\StructType\RegistrationNationalityIDType
     */
    public $RegistrationNationalityID;
    /**
     * The RegistrationNationality
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q199:RegistrationNationality
     * @var \Mnm\StructType\RegistrationNationalityType[]
     */
    public $RegistrationNationality;
    /**
     * The DirectionCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q200:DirectionCode
     * @var \Mnm\StructType\DirectionCodeType
     */
    public $DirectionCode;
    /**
     * The TransportMeansTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q201:TransportMeansTypeCode
     * @var \Mnm\StructType\TransportMeansTypeCodeType
     */
    public $TransportMeansTypeCode;
    /**
     * The TradeServiceCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q202:TradeServiceCode
     * @var \Mnm\StructType\TradeServiceCodeType
     */
    public $TradeServiceCode;
    /**
     * The Stowage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\StowageType
     */
    public $Stowage;
    /**
     * The AirTransport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\AirTransportType
     */
    public $AirTransport;
    /**
     * The RoadTransport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\RoadTransportType
     */
    public $RoadTransport;
    /**
     * The RailTransport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\RailTransportType
     */
    public $RailTransport;
    /**
     * The MaritimeTransport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\MaritimeTransportType
     */
    public $MaritimeTransport;
    /**
     * The OwnerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\PartyType
     */
    public $OwnerParty;
    /**
     * The MeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\DimensionType[]
     */
    public $MeasurementDimension;
    /**
     * Constructor method for TransportMeansType
     * @uses TransportMeansType::setJourneyID()
     * @uses TransportMeansType::setRegistrationNationalityID()
     * @uses TransportMeansType::setRegistrationNationality()
     * @uses TransportMeansType::setDirectionCode()
     * @uses TransportMeansType::setTransportMeansTypeCode()
     * @uses TransportMeansType::setTradeServiceCode()
     * @uses TransportMeansType::setStowage()
     * @uses TransportMeansType::setAirTransport()
     * @uses TransportMeansType::setRoadTransport()
     * @uses TransportMeansType::setRailTransport()
     * @uses TransportMeansType::setMaritimeTransport()
     * @uses TransportMeansType::setOwnerParty()
     * @uses TransportMeansType::setMeasurementDimension()
     * @param \Mnm\StructType\JourneyIDType $journeyID
     * @param \Mnm\StructType\RegistrationNationalityIDType $registrationNationalityID
     * @param \Mnm\StructType\RegistrationNationalityType[] $registrationNationality
     * @param \Mnm\StructType\DirectionCodeType $directionCode
     * @param \Mnm\StructType\TransportMeansTypeCodeType $transportMeansTypeCode
     * @param \Mnm\StructType\TradeServiceCodeType $tradeServiceCode
     * @param \Mnm\StructType\StowageType $stowage
     * @param \Mnm\StructType\AirTransportType $airTransport
     * @param \Mnm\StructType\RoadTransportType $roadTransport
     * @param \Mnm\StructType\RailTransportType $railTransport
     * @param \Mnm\StructType\MaritimeTransportType $maritimeTransport
     * @param \Mnm\StructType\PartyType $ownerParty
     * @param \Mnm\StructType\DimensionType[] $measurementDimension
     */
    public function __construct(\Mnm\StructType\JourneyIDType $journeyID = null, \Mnm\StructType\RegistrationNationalityIDType $registrationNationalityID = null, array $registrationNationality = array(), \Mnm\StructType\DirectionCodeType $directionCode = null, \Mnm\StructType\TransportMeansTypeCodeType $transportMeansTypeCode = null, \Mnm\StructType\TradeServiceCodeType $tradeServiceCode = null, \Mnm\StructType\StowageType $stowage = null, \Mnm\StructType\AirTransportType $airTransport = null, \Mnm\StructType\RoadTransportType $roadTransport = null, \Mnm\StructType\RailTransportType $railTransport = null, \Mnm\StructType\MaritimeTransportType $maritimeTransport = null, \Mnm\StructType\PartyType $ownerParty = null, array $measurementDimension = array())
    {
        $this
            ->setJourneyID($journeyID)
            ->setRegistrationNationalityID($registrationNationalityID)
            ->setRegistrationNationality($registrationNationality)
            ->setDirectionCode($directionCode)
            ->setTransportMeansTypeCode($transportMeansTypeCode)
            ->setTradeServiceCode($tradeServiceCode)
            ->setStowage($stowage)
            ->setAirTransport($airTransport)
            ->setRoadTransport($roadTransport)
            ->setRailTransport($railTransport)
            ->setMaritimeTransport($maritimeTransport)
            ->setOwnerParty($ownerParty)
            ->setMeasurementDimension($measurementDimension);
    }
    /**
     * Get JourneyID value
     * @return \Mnm\StructType\JourneyIDType|null
     */
    public function getJourneyID()
    {
        return $this->JourneyID;
    }
    /**
     * Set JourneyID value
     * @param \Mnm\StructType\JourneyIDType $journeyID
     * @return \Mnm\StructType\TransportMeansType
     */
    public function setJourneyID(\Mnm\StructType\JourneyIDType $journeyID = null)
    {
        $this->JourneyID = $journeyID;
        return $this;
    }
    /**
     * Get RegistrationNationalityID value
     * @return \Mnm\StructType\RegistrationNationalityIDType|null
     */
    public function getRegistrationNationalityID()
    {
        return $this->RegistrationNationalityID;
    }
    /**
     * Set RegistrationNationalityID value
     * @param \Mnm\StructType\RegistrationNationalityIDType $registrationNationalityID
     * @return \Mnm\StructType\TransportMeansType
     */
    public function setRegistrationNationalityID(\Mnm\StructType\RegistrationNationalityIDType $registrationNationalityID = null)
    {
        $this->RegistrationNationalityID = $registrationNationalityID;
        return $this;
    }
    /**
     * Get RegistrationNationality value
     * @return \Mnm\StructType\RegistrationNationalityType[]|null
     */
    public function getRegistrationNationality()
    {
        return $this->RegistrationNationality;
    }
    /**
     * Set RegistrationNationality value
     * @param \Mnm\StructType\RegistrationNationalityType[] $registrationNationality
     * @return \Mnm\StructType\TransportMeansType
     */
    public function setRegistrationNationality(array $registrationNationality = array())
    {
        $this->RegistrationNationality = $registrationNationality;
        return $this;
    }
    /**
     * Add item to RegistrationNationality value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\RegistrationNationalityType $item
     * @return \Mnm\StructType\TransportMeansType
     */
    public function addToRegistrationNationality(\Mnm\StructType\RegistrationNationalityType $item)
    {
        $this->RegistrationNationality[] = $item;
        return $this;
    }
    /**
     * Get DirectionCode value
     * @return \Mnm\StructType\DirectionCodeType|null
     */
    public function getDirectionCode()
    {
        return $this->DirectionCode;
    }
    /**
     * Set DirectionCode value
     * @param \Mnm\StructType\DirectionCodeType $directionCode
     * @return \Mnm\StructType\TransportMeansType
     */
    public function setDirectionCode(\Mnm\StructType\DirectionCodeType $directionCode = null)
    {
        $this->DirectionCode = $directionCode;
        return $this;
    }
    /**
     * Get TransportMeansTypeCode value
     * @return \Mnm\StructType\TransportMeansTypeCodeType|null
     */
    public function getTransportMeansTypeCode()
    {
        return $this->TransportMeansTypeCode;
    }
    /**
     * Set TransportMeansTypeCode value
     * @param \Mnm\StructType\TransportMeansTypeCodeType $transportMeansTypeCode
     * @return \Mnm\StructType\TransportMeansType
     */
    public function setTransportMeansTypeCode(\Mnm\StructType\TransportMeansTypeCodeType $transportMeansTypeCode = null)
    {
        $this->TransportMeansTypeCode = $transportMeansTypeCode;
        return $this;
    }
    /**
     * Get TradeServiceCode value
     * @return \Mnm\StructType\TradeServiceCodeType|null
     */
    public function getTradeServiceCode()
    {
        return $this->TradeServiceCode;
    }
    /**
     * Set TradeServiceCode value
     * @param \Mnm\StructType\TradeServiceCodeType $tradeServiceCode
     * @return \Mnm\StructType\TransportMeansType
     */
    public function setTradeServiceCode(\Mnm\StructType\TradeServiceCodeType $tradeServiceCode = null)
    {
        $this->TradeServiceCode = $tradeServiceCode;
        return $this;
    }
    /**
     * Get Stowage value
     * @return \Mnm\StructType\StowageType|null
     */
    public function getStowage()
    {
        return $this->Stowage;
    }
    /**
     * Set Stowage value
     * @param \Mnm\StructType\StowageType $stowage
     * @return \Mnm\StructType\TransportMeansType
     */
    public function setStowage(\Mnm\StructType\StowageType $stowage = null)
    {
        $this->Stowage = $stowage;
        return $this;
    }
    /**
     * Get AirTransport value
     * @return \Mnm\StructType\AirTransportType|null
     */
    public function getAirTransport()
    {
        return $this->AirTransport;
    }
    /**
     * Set AirTransport value
     * @param \Mnm\StructType\AirTransportType $airTransport
     * @return \Mnm\StructType\TransportMeansType
     */
    public function setAirTransport(\Mnm\StructType\AirTransportType $airTransport = null)
    {
        $this->AirTransport = $airTransport;
        return $this;
    }
    /**
     * Get RoadTransport value
     * @return \Mnm\StructType\RoadTransportType|null
     */
    public function getRoadTransport()
    {
        return $this->RoadTransport;
    }
    /**
     * Set RoadTransport value
     * @param \Mnm\StructType\RoadTransportType $roadTransport
     * @return \Mnm\StructType\TransportMeansType
     */
    public function setRoadTransport(\Mnm\StructType\RoadTransportType $roadTransport = null)
    {
        $this->RoadTransport = $roadTransport;
        return $this;
    }
    /**
     * Get RailTransport value
     * @return \Mnm\StructType\RailTransportType|null
     */
    public function getRailTransport()
    {
        return $this->RailTransport;
    }
    /**
     * Set RailTransport value
     * @param \Mnm\StructType\RailTransportType $railTransport
     * @return \Mnm\StructType\TransportMeansType
     */
    public function setRailTransport(\Mnm\StructType\RailTransportType $railTransport = null)
    {
        $this->RailTransport = $railTransport;
        return $this;
    }
    /**
     * Get MaritimeTransport value
     * @return \Mnm\StructType\MaritimeTransportType|null
     */
    public function getMaritimeTransport()
    {
        return $this->MaritimeTransport;
    }
    /**
     * Set MaritimeTransport value
     * @param \Mnm\StructType\MaritimeTransportType $maritimeTransport
     * @return \Mnm\StructType\TransportMeansType
     */
    public function setMaritimeTransport(\Mnm\StructType\MaritimeTransportType $maritimeTransport = null)
    {
        $this->MaritimeTransport = $maritimeTransport;
        return $this;
    }
    /**
     * Get OwnerParty value
     * @return \Mnm\StructType\PartyType|null
     */
    public function getOwnerParty()
    {
        return $this->OwnerParty;
    }
    /**
     * Set OwnerParty value
     * @param \Mnm\StructType\PartyType $ownerParty
     * @return \Mnm\StructType\TransportMeansType
     */
    public function setOwnerParty(\Mnm\StructType\PartyType $ownerParty = null)
    {
        $this->OwnerParty = $ownerParty;
        return $this;
    }
    /**
     * Get MeasurementDimension value
     * @return \Mnm\StructType\DimensionType[]|null
     */
    public function getMeasurementDimension()
    {
        return $this->MeasurementDimension;
    }
    /**
     * Set MeasurementDimension value
     * @param \Mnm\StructType\DimensionType[] $measurementDimension
     * @return \Mnm\StructType\TransportMeansType
     */
    public function setMeasurementDimension(array $measurementDimension = array())
    {
        $this->MeasurementDimension = $measurementDimension;
        return $this;
    }
    /**
     * Add item to MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\DimensionType $item
     * @return \Mnm\StructType\TransportMeansType
     */
    public function addToMeasurementDimension(\Mnm\StructType\DimensionType $item)
    {
        $this->MeasurementDimension[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\TransportMeansType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
