<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendInvoice StructType
 * @subpackage Structs
 */
class SendInvoice extends AbstractStructBase
{
    /**
     * The userInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\UserInformation
     */
    public $userInfo;
    /**
     * The invoices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\ArrayType\ArrayOfInvoiceInfo
     */
    public $invoices;
    /**
     * Constructor method for SendInvoice
     * @uses SendInvoice::setUserInfo()
     * @uses SendInvoice::setInvoices()
     * @param \Mnm\StructType\UserInformation $userInfo
     * @param \Mnm\ArrayType\ArrayOfInvoiceInfo $invoices
     */
    public function __construct(\Mnm\StructType\UserInformation $userInfo = null, \Mnm\ArrayType\ArrayOfInvoiceInfo $invoices = null)
    {
        $this
            ->setUserInfo($userInfo)
            ->setInvoices($invoices);
    }
    /**
     * Get userInfo value
     * @return \Mnm\StructType\UserInformation|null
     */
    public function getUserInfo()
    {
        return $this->userInfo;
    }
    /**
     * Set userInfo value
     * @param \Mnm\StructType\UserInformation $userInfo
     * @return \Mnm\StructType\SendInvoice
     */
    public function setUserInfo(\Mnm\StructType\UserInformation $userInfo = null)
    {
        $this->userInfo = $userInfo;
        return $this;
    }
    /**
     * Get invoices value
     * @return \Mnm\ArrayType\ArrayOfInvoiceInfo|null
     */
    public function getInvoices()
    {
        return $this->invoices;
    }
    /**
     * Set invoices value
     * @param \Mnm\ArrayType\ArrayOfInvoiceInfo $invoices
     * @return \Mnm\StructType\SendInvoice
     */
    public function setInvoices(\Mnm\ArrayType\ArrayOfInvoiceInfo $invoices = null)
    {
        $this->invoices = $invoices;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\SendInvoice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
