<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderReferenceType StructType
 * @subpackage Structs
 */
class OrderReferenceType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q7:ID
     * @var \Mnm\StructType\IDType
     */
    public $ID;
    /**
     * The SalesOrderID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q8:SalesOrderID
     * @var \Mnm\StructType\SalesOrderIDType
     */
    public $SalesOrderID;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q9:IssueDate
     * @var \Mnm\StructType\IssueDateType
     */
    public $IssueDate;
    /**
     * The OrderTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q10:OrderTypeCode
     * @var \Mnm\StructType\OrderTypeCodeType
     */
    public $OrderTypeCode;
    /**
     * The DocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\DocumentReferenceType
     */
    public $DocumentReference;
    /**
     * Constructor method for OrderReferenceType
     * @uses OrderReferenceType::setID()
     * @uses OrderReferenceType::setSalesOrderID()
     * @uses OrderReferenceType::setIssueDate()
     * @uses OrderReferenceType::setOrderTypeCode()
     * @uses OrderReferenceType::setDocumentReference()
     * @param \Mnm\StructType\IDType $iD
     * @param \Mnm\StructType\SalesOrderIDType $salesOrderID
     * @param \Mnm\StructType\IssueDateType $issueDate
     * @param \Mnm\StructType\OrderTypeCodeType $orderTypeCode
     * @param \Mnm\StructType\DocumentReferenceType $documentReference
     */
    public function __construct(\Mnm\StructType\IDType $iD = null, \Mnm\StructType\SalesOrderIDType $salesOrderID = null, \Mnm\StructType\IssueDateType $issueDate = null, \Mnm\StructType\OrderTypeCodeType $orderTypeCode = null, \Mnm\StructType\DocumentReferenceType $documentReference = null)
    {
        $this
            ->setID($iD)
            ->setSalesOrderID($salesOrderID)
            ->setIssueDate($issueDate)
            ->setOrderTypeCode($orderTypeCode)
            ->setDocumentReference($documentReference);
    }
    /**
     * Get ID value
     * @return \Mnm\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\StructType\IDType $iD
     * @return \Mnm\StructType\OrderReferenceType
     */
    public function setID(\Mnm\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get SalesOrderID value
     * @return \Mnm\StructType\SalesOrderIDType|null
     */
    public function getSalesOrderID()
    {
        return $this->SalesOrderID;
    }
    /**
     * Set SalesOrderID value
     * @param \Mnm\StructType\SalesOrderIDType $salesOrderID
     * @return \Mnm\StructType\OrderReferenceType
     */
    public function setSalesOrderID(\Mnm\StructType\SalesOrderIDType $salesOrderID = null)
    {
        $this->SalesOrderID = $salesOrderID;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return \Mnm\StructType\IssueDateType|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param \Mnm\StructType\IssueDateType $issueDate
     * @return \Mnm\StructType\OrderReferenceType
     */
    public function setIssueDate(\Mnm\StructType\IssueDateType $issueDate = null)
    {
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get OrderTypeCode value
     * @return \Mnm\StructType\OrderTypeCodeType|null
     */
    public function getOrderTypeCode()
    {
        return $this->OrderTypeCode;
    }
    /**
     * Set OrderTypeCode value
     * @param \Mnm\StructType\OrderTypeCodeType $orderTypeCode
     * @return \Mnm\StructType\OrderReferenceType
     */
    public function setOrderTypeCode(\Mnm\StructType\OrderTypeCodeType $orderTypeCode = null)
    {
        $this->OrderTypeCode = $orderTypeCode;
        return $this;
    }
    /**
     * Get DocumentReference value
     * @return \Mnm\StructType\DocumentReferenceType|null
     */
    public function getDocumentReference()
    {
        return $this->DocumentReference;
    }
    /**
     * Set DocumentReference value
     * @param \Mnm\StructType\DocumentReferenceType $documentReference
     * @return \Mnm\StructType\OrderReferenceType
     */
    public function setDocumentReference(\Mnm\StructType\DocumentReferenceType $documentReference = null)
    {
        $this->DocumentReference = $documentReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\OrderReferenceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
