<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceListItemBase StructType
 * @subpackage Structs
 */
class InvoiceListItemBase extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The TypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TypeCode;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StatusCode;
    /**
     * The EnvelopeStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EnvelopeStatus;
    /**
     * The EnvelopeStatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EnvelopeStatusCode;
    /**
     * The CreateDateUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDateUtc;
    /**
     * The ExecutionDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExecutionDate;
    /**
     * The PayableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PayableAmount;
    /**
     * The TaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxTotal;
    /**
     * The TaxExclusiveAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxExclusiveAmount;
    /**
     * The ExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ExchangeRate;
    /**
     * The Vat1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Vat1;
    /**
     * The Vat8
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Vat8;
    /**
     * The Vat18
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Vat18;
    /**
     * The Vat0TaxableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Vat0TaxableAmount;
    /**
     * The Vat1TaxableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Vat1TaxableAmount;
    /**
     * The Vat8TaxableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Vat8TaxableAmount;
    /**
     * The Vat18TaxableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Vat18TaxableAmount;
    /**
     * The IsArchived
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsArchived;
    /**
     * The InvoiceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceId;
    /**
     * The DocumentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentId;
    /**
     * The TargetTcknVkn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TargetTcknVkn;
    /**
     * The TargetTitle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TargetTitle;
    /**
     * The EnvelopeIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EnvelopeIdentifier;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The DocumentCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentCurrencyCode;
    /**
     * The OrderDocumentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderDocumentId;
    /**
     * Constructor method for InvoiceListItemBase
     * @uses InvoiceListItemBase::setType()
     * @uses InvoiceListItemBase::setTypeCode()
     * @uses InvoiceListItemBase::setStatus()
     * @uses InvoiceListItemBase::setStatusCode()
     * @uses InvoiceListItemBase::setEnvelopeStatus()
     * @uses InvoiceListItemBase::setEnvelopeStatusCode()
     * @uses InvoiceListItemBase::setCreateDateUtc()
     * @uses InvoiceListItemBase::setExecutionDate()
     * @uses InvoiceListItemBase::setPayableAmount()
     * @uses InvoiceListItemBase::setTaxTotal()
     * @uses InvoiceListItemBase::setTaxExclusiveAmount()
     * @uses InvoiceListItemBase::setExchangeRate()
     * @uses InvoiceListItemBase::setVat1()
     * @uses InvoiceListItemBase::setVat8()
     * @uses InvoiceListItemBase::setVat18()
     * @uses InvoiceListItemBase::setVat0TaxableAmount()
     * @uses InvoiceListItemBase::setVat1TaxableAmount()
     * @uses InvoiceListItemBase::setVat8TaxableAmount()
     * @uses InvoiceListItemBase::setVat18TaxableAmount()
     * @uses InvoiceListItemBase::setIsArchived()
     * @uses InvoiceListItemBase::setInvoiceId()
     * @uses InvoiceListItemBase::setDocumentId()
     * @uses InvoiceListItemBase::setTargetTcknVkn()
     * @uses InvoiceListItemBase::setTargetTitle()
     * @uses InvoiceListItemBase::setEnvelopeIdentifier()
     * @uses InvoiceListItemBase::setMessage()
     * @uses InvoiceListItemBase::setDocumentCurrencyCode()
     * @uses InvoiceListItemBase::setOrderDocumentId()
     * @param string $type
     * @param int $typeCode
     * @param string $status
     * @param int $statusCode
     * @param string $envelopeStatus
     * @param int $envelopeStatusCode
     * @param string $createDateUtc
     * @param string $executionDate
     * @param float $payableAmount
     * @param float $taxTotal
     * @param float $taxExclusiveAmount
     * @param float $exchangeRate
     * @param float $vat1
     * @param float $vat8
     * @param float $vat18
     * @param float $vat0TaxableAmount
     * @param float $vat1TaxableAmount
     * @param float $vat8TaxableAmount
     * @param float $vat18TaxableAmount
     * @param bool $isArchived
     * @param string $invoiceId
     * @param string $documentId
     * @param string $targetTcknVkn
     * @param string $targetTitle
     * @param string $envelopeIdentifier
     * @param string $message
     * @param string $documentCurrencyCode
     * @param string $orderDocumentId
     */
    public function __construct($type = null, $typeCode = null, $status = null, $statusCode = null, $envelopeStatus = null, $envelopeStatusCode = null, $createDateUtc = null, $executionDate = null, $payableAmount = null, $taxTotal = null, $taxExclusiveAmount = null, $exchangeRate = null, $vat1 = null, $vat8 = null, $vat18 = null, $vat0TaxableAmount = null, $vat1TaxableAmount = null, $vat8TaxableAmount = null, $vat18TaxableAmount = null, $isArchived = null, $invoiceId = null, $documentId = null, $targetTcknVkn = null, $targetTitle = null, $envelopeIdentifier = null, $message = null, $documentCurrencyCode = null, $orderDocumentId = null)
    {
        $this
            ->setType($type)
            ->setTypeCode($typeCode)
            ->setStatus($status)
            ->setStatusCode($statusCode)
            ->setEnvelopeStatus($envelopeStatus)
            ->setEnvelopeStatusCode($envelopeStatusCode)
            ->setCreateDateUtc($createDateUtc)
            ->setExecutionDate($executionDate)
            ->setPayableAmount($payableAmount)
            ->setTaxTotal($taxTotal)
            ->setTaxExclusiveAmount($taxExclusiveAmount)
            ->setExchangeRate($exchangeRate)
            ->setVat1($vat1)
            ->setVat8($vat8)
            ->setVat18($vat18)
            ->setVat0TaxableAmount($vat0TaxableAmount)
            ->setVat1TaxableAmount($vat1TaxableAmount)
            ->setVat8TaxableAmount($vat8TaxableAmount)
            ->setVat18TaxableAmount($vat18TaxableAmount)
            ->setIsArchived($isArchived)
            ->setInvoiceId($invoiceId)
            ->setDocumentId($documentId)
            ->setTargetTcknVkn($targetTcknVkn)
            ->setTargetTitle($targetTitle)
            ->setEnvelopeIdentifier($envelopeIdentifier)
            ->setMessage($message)
            ->setDocumentCurrencyCode($documentCurrencyCode)
            ->setOrderDocumentId($orderDocumentId);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get TypeCode value
     * @return int
     */
    public function getTypeCode()
    {
        return $this->TypeCode;
    }
    /**
     * Set TypeCode value
     * @param int $typeCode
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setTypeCode($typeCode = null)
    {
        $this->TypeCode = $typeCode;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return int
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param int $statusCode
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setStatusCode($statusCode = null)
    {
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get EnvelopeStatus value
     * @return string
     */
    public function getEnvelopeStatus()
    {
        return $this->EnvelopeStatus;
    }
    /**
     * Set EnvelopeStatus value
     * @param string $envelopeStatus
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setEnvelopeStatus($envelopeStatus = null)
    {
        $this->EnvelopeStatus = $envelopeStatus;
        return $this;
    }
    /**
     * Get EnvelopeStatusCode value
     * @return int
     */
    public function getEnvelopeStatusCode()
    {
        return $this->EnvelopeStatusCode;
    }
    /**
     * Set EnvelopeStatusCode value
     * @param int $envelopeStatusCode
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setEnvelopeStatusCode($envelopeStatusCode = null)
    {
        $this->EnvelopeStatusCode = $envelopeStatusCode;
        return $this;
    }
    /**
     * Get CreateDateUtc value
     * @return string
     */
    public function getCreateDateUtc()
    {
        return $this->CreateDateUtc;
    }
    /**
     * Set CreateDateUtc value
     * @param string $createDateUtc
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setCreateDateUtc($createDateUtc = null)
    {
        $this->CreateDateUtc = $createDateUtc;
        return $this;
    }
    /**
     * Get ExecutionDate value
     * @return string
     */
    public function getExecutionDate()
    {
        return $this->ExecutionDate;
    }
    /**
     * Set ExecutionDate value
     * @param string $executionDate
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setExecutionDate($executionDate = null)
    {
        $this->ExecutionDate = $executionDate;
        return $this;
    }
    /**
     * Get PayableAmount value
     * @return float
     */
    public function getPayableAmount()
    {
        return $this->PayableAmount;
    }
    /**
     * Set PayableAmount value
     * @param float $payableAmount
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setPayableAmount($payableAmount = null)
    {
        $this->PayableAmount = $payableAmount;
        return $this;
    }
    /**
     * Get TaxTotal value
     * @return float
     */
    public function getTaxTotal()
    {
        return $this->TaxTotal;
    }
    /**
     * Set TaxTotal value
     * @param float $taxTotal
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setTaxTotal($taxTotal = null)
    {
        $this->TaxTotal = $taxTotal;
        return $this;
    }
    /**
     * Get TaxExclusiveAmount value
     * @return float
     */
    public function getTaxExclusiveAmount()
    {
        return $this->TaxExclusiveAmount;
    }
    /**
     * Set TaxExclusiveAmount value
     * @param float $taxExclusiveAmount
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setTaxExclusiveAmount($taxExclusiveAmount = null)
    {
        $this->TaxExclusiveAmount = $taxExclusiveAmount;
        return $this;
    }
    /**
     * Get ExchangeRate value
     * @return float
     */
    public function getExchangeRate()
    {
        return $this->ExchangeRate;
    }
    /**
     * Set ExchangeRate value
     * @param float $exchangeRate
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setExchangeRate($exchangeRate = null)
    {
        $this->ExchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get Vat1 value
     * @return float
     */
    public function getVat1()
    {
        return $this->Vat1;
    }
    /**
     * Set Vat1 value
     * @param float $vat1
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setVat1($vat1 = null)
    {
        $this->Vat1 = $vat1;
        return $this;
    }
    /**
     * Get Vat8 value
     * @return float
     */
    public function getVat8()
    {
        return $this->Vat8;
    }
    /**
     * Set Vat8 value
     * @param float $vat8
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setVat8($vat8 = null)
    {
        $this->Vat8 = $vat8;
        return $this;
    }
    /**
     * Get Vat18 value
     * @return float
     */
    public function getVat18()
    {
        return $this->Vat18;
    }
    /**
     * Set Vat18 value
     * @param float $vat18
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setVat18($vat18 = null)
    {
        $this->Vat18 = $vat18;
        return $this;
    }
    /**
     * Get Vat0TaxableAmount value
     * @return float
     */
    public function getVat0TaxableAmount()
    {
        return $this->Vat0TaxableAmount;
    }
    /**
     * Set Vat0TaxableAmount value
     * @param float $vat0TaxableAmount
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setVat0TaxableAmount($vat0TaxableAmount = null)
    {
        $this->Vat0TaxableAmount = $vat0TaxableAmount;
        return $this;
    }
    /**
     * Get Vat1TaxableAmount value
     * @return float
     */
    public function getVat1TaxableAmount()
    {
        return $this->Vat1TaxableAmount;
    }
    /**
     * Set Vat1TaxableAmount value
     * @param float $vat1TaxableAmount
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setVat1TaxableAmount($vat1TaxableAmount = null)
    {
        $this->Vat1TaxableAmount = $vat1TaxableAmount;
        return $this;
    }
    /**
     * Get Vat8TaxableAmount value
     * @return float
     */
    public function getVat8TaxableAmount()
    {
        return $this->Vat8TaxableAmount;
    }
    /**
     * Set Vat8TaxableAmount value
     * @param float $vat8TaxableAmount
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setVat8TaxableAmount($vat8TaxableAmount = null)
    {
        $this->Vat8TaxableAmount = $vat8TaxableAmount;
        return $this;
    }
    /**
     * Get Vat18TaxableAmount value
     * @return float
     */
    public function getVat18TaxableAmount()
    {
        return $this->Vat18TaxableAmount;
    }
    /**
     * Set Vat18TaxableAmount value
     * @param float $vat18TaxableAmount
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setVat18TaxableAmount($vat18TaxableAmount = null)
    {
        $this->Vat18TaxableAmount = $vat18TaxableAmount;
        return $this;
    }
    /**
     * Get IsArchived value
     * @return bool
     */
    public function getIsArchived()
    {
        return $this->IsArchived;
    }
    /**
     * Set IsArchived value
     * @param bool $isArchived
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setIsArchived($isArchived = null)
    {
        $this->IsArchived = $isArchived;
        return $this;
    }
    /**
     * Get InvoiceId value
     * @return string|null
     */
    public function getInvoiceId()
    {
        return $this->InvoiceId;
    }
    /**
     * Set InvoiceId value
     * @param string $invoiceId
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setInvoiceId($invoiceId = null)
    {
        $this->InvoiceId = $invoiceId;
        return $this;
    }
    /**
     * Get DocumentId value
     * @return string|null
     */
    public function getDocumentId()
    {
        return $this->DocumentId;
    }
    /**
     * Set DocumentId value
     * @param string $documentId
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setDocumentId($documentId = null)
    {
        $this->DocumentId = $documentId;
        return $this;
    }
    /**
     * Get TargetTcknVkn value
     * @return string|null
     */
    public function getTargetTcknVkn()
    {
        return $this->TargetTcknVkn;
    }
    /**
     * Set TargetTcknVkn value
     * @param string $targetTcknVkn
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setTargetTcknVkn($targetTcknVkn = null)
    {
        $this->TargetTcknVkn = $targetTcknVkn;
        return $this;
    }
    /**
     * Get TargetTitle value
     * @return string|null
     */
    public function getTargetTitle()
    {
        return $this->TargetTitle;
    }
    /**
     * Set TargetTitle value
     * @param string $targetTitle
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setTargetTitle($targetTitle = null)
    {
        $this->TargetTitle = $targetTitle;
        return $this;
    }
    /**
     * Get EnvelopeIdentifier value
     * @return string|null
     */
    public function getEnvelopeIdentifier()
    {
        return $this->EnvelopeIdentifier;
    }
    /**
     * Set EnvelopeIdentifier value
     * @param string $envelopeIdentifier
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setEnvelopeIdentifier($envelopeIdentifier = null)
    {
        $this->EnvelopeIdentifier = $envelopeIdentifier;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setMessage($message = null)
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Get DocumentCurrencyCode value
     * @return string|null
     */
    public function getDocumentCurrencyCode()
    {
        return $this->DocumentCurrencyCode;
    }
    /**
     * Set DocumentCurrencyCode value
     * @param string $documentCurrencyCode
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setDocumentCurrencyCode($documentCurrencyCode = null)
    {
        $this->DocumentCurrencyCode = $documentCurrencyCode;
        return $this;
    }
    /**
     * Get OrderDocumentId value
     * @return string|null
     */
    public function getOrderDocumentId()
    {
        return $this->OrderDocumentId;
    }
    /**
     * Set OrderDocumentId value
     * @param string $orderDocumentId
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public function setOrderDocumentId($orderDocumentId = null)
    {
        $this->OrderDocumentId = $orderDocumentId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\InvoiceListItemBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
