<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceData StructType
 * @subpackage Structs
 */
class InvoiceData extends AbstractStructBase
{
    /**
     * The Data
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Data;
    /**
     * The LocalDocumentId
     * @var string
     */
    public $LocalDocumentId;
    /**
     * The ExtraInformation
     * @var string
     */
    public $ExtraInformation;
    /**
     * The InvoiceId
     * @var string
     */
    public $InvoiceId;
    /**
     * Constructor method for InvoiceData
     * @uses InvoiceData::setData()
     * @uses InvoiceData::setLocalDocumentId()
     * @uses InvoiceData::setExtraInformation()
     * @uses InvoiceData::setInvoiceId()
     * @param string $data
     * @param string $localDocumentId
     * @param string $extraInformation
     * @param string $invoiceId
     */
    public function __construct($data = null, $localDocumentId = null, $extraInformation = null, $invoiceId = null)
    {
        $this
            ->setData($data)
            ->setLocalDocumentId($localDocumentId)
            ->setExtraInformation($extraInformation)
            ->setInvoiceId($invoiceId);
    }
    /**
     * Get Data value
     * @return string|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @param string $data
     * @return \Mnm\StructType\InvoiceData
     */
    public function setData($data = null)
    {
        $this->Data = $data;
        return $this;
    }
    /**
     * Get LocalDocumentId value
     * @return string|null
     */
    public function getLocalDocumentId()
    {
        return $this->LocalDocumentId;
    }
    /**
     * Set LocalDocumentId value
     * @param string $localDocumentId
     * @return \Mnm\StructType\InvoiceData
     */
    public function setLocalDocumentId($localDocumentId = null)
    {
        $this->LocalDocumentId = $localDocumentId;
        return $this;
    }
    /**
     * Get ExtraInformation value
     * @return string|null
     */
    public function getExtraInformation()
    {
        return $this->ExtraInformation;
    }
    /**
     * Set ExtraInformation value
     * @param string $extraInformation
     * @return \Mnm\StructType\InvoiceData
     */
    public function setExtraInformation($extraInformation = null)
    {
        $this->ExtraInformation = $extraInformation;
        return $this;
    }
    /**
     * Get InvoiceId value
     * @return string|null
     */
    public function getInvoiceId()
    {
        return $this->InvoiceId;
    }
    /**
     * Set InvoiceId value
     * @param string $invoiceId
     * @return \Mnm\StructType\InvoiceData
     */
    public function setInvoiceId($invoiceId = null)
    {
        $this->InvoiceId = $invoiceId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\InvoiceData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
