<?php

namespace Mnm\EnumType;

/**
 * This class stands for EnvelopeStatus EnumType
 * @subpackage Enumerations
 */
class EnvelopeStatus
{
    /**
     * Constant for value 'NoEnvelope'
     * @return string 'NoEnvelope'
     */
    const VALUE_NO_ENVELOPE = 'NoEnvelope';
    /**
     * Constant for value 'Preparing'
     * @return string 'Preparing'
     */
    const VALUE_PREPARING = 'Preparing';
    /**
     * Constant for value 'EnvelopIsQueued'
     * @return string 'EnvelopIsQueued'
     */
    const VALUE_ENVELOP_IS_QUEUED = 'EnvelopIsQueued';
    /**
     * Constant for value 'EnvelopIsProcessing'
     * @return string 'EnvelopIsProcessing'
     */
    const VALUE_ENVELOP_IS_PROCESSING = 'EnvelopIsProcessing';
    /**
     * Constant for value 'FileIsNotZip'
     * @return string 'FileIsNotZip'
     */
    const VALUE_FILE_IS_NOT_ZIP = 'FileIsNotZip';
    /**
     * Constant for value 'InvalidEnvelopIdLength'
     * @return string 'InvalidEnvelopIdLength'
     */
    const VALUE_INVALID_ENVELOP_ID_LENGTH = 'InvalidEnvelopIdLength';
    /**
     * Constant for value 'EnvelopCouldNotCopiedFromArchive'
     * @return string 'EnvelopCouldNotCopiedFromArchive'
     */
    const VALUE_ENVELOP_COULD_NOT_COPIED_FROM_ARCHIVE = 'EnvelopCouldNotCopiedFromArchive';
    /**
     * Constant for value 'CouldNotOpenZip'
     * @return string 'CouldNotOpenZip'
     */
    const VALUE_COULD_NOT_OPEN_ZIP = 'CouldNotOpenZip';
    /**
     * Constant for value 'ZipIsEmpty'
     * @return string 'ZipIsEmpty'
     */
    const VALUE_ZIP_IS_EMPTY = 'ZipIsEmpty';
    /**
     * Constant for value 'FileIsNotXml'
     * @return string 'FileIsNotXml'
     */
    const VALUE_FILE_IS_NOT_XML = 'FileIsNotXml';
    /**
     * Constant for value 'EnvelopeIdAndXmlNameMustBeSame'
     * @return string 'EnvelopeIdAndXmlNameMustBeSame'
     */
    const VALUE_ENVELOPE_ID_AND_XML_NAME_MUST_BE_SAME = 'EnvelopeIdAndXmlNameMustBeSame';
    /**
     * Constant for value 'CouldNotParseDocument'
     * @return string 'CouldNotParseDocument'
     */
    const VALUE_COULD_NOT_PARSE_DOCUMENT = 'CouldNotParseDocument';
    /**
     * Constant for value 'EnvelopeIdNotFound'
     * @return string 'EnvelopeIdNotFound'
     */
    const VALUE_ENVELOPE_ID_NOT_FOUND = 'EnvelopeIdNotFound';
    /**
     * Constant for value 'EnvelopeIdAndZipNameMustBeSame'
     * @return string 'EnvelopeIdAndZipNameMustBeSame'
     */
    const VALUE_ENVELOPE_ID_AND_ZIP_NAME_MUST_BE_SAME = 'EnvelopeIdAndZipNameMustBeSame';
    /**
     * Constant for value 'InvalidVersion'
     * @return string 'InvalidVersion'
     */
    const VALUE_INVALID_VERSION = 'InvalidVersion';
    /**
     * Constant for value 'SchematronCheckFailed'
     * @return string 'SchematronCheckFailed'
     */
    const VALUE_SCHEMATRON_CHECK_FAILED = 'SchematronCheckFailed';
    /**
     * Constant for value 'XmlSchemaCheckFailed'
     * @return string 'XmlSchemaCheckFailed'
     */
    const VALUE_XML_SCHEMA_CHECK_FAILED = 'XmlSchemaCheckFailed';
    /**
     * Constant for value 'CouldNotTakeTcknVknForSigner'
     * @return string 'CouldNotTakeTcknVknForSigner'
     */
    const VALUE_COULD_NOT_TAKE_TCKN_VKN_FOR_SIGNER = 'CouldNotTakeTcknVknForSigner';
    /**
     * Constant for value 'CouldNotSaveSigniture'
     * @return string 'CouldNotSaveSigniture'
     */
    const VALUE_COULD_NOT_SAVE_SIGNITURE = 'CouldNotSaveSigniture';
    /**
     * Constant for value 'EnvelopeIdIsAlreadyUsed'
     * @return string 'EnvelopeIdIsAlreadyUsed'
     */
    const VALUE_ENVELOPE_ID_IS_ALREADY_USED = 'EnvelopeIdIsAlreadyUsed';
    /**
     * Constant for value 'EnvelopeContainsIdIsAlreadyUsed'
     * @return string 'EnvelopeContainsIdIsAlreadyUsed'
     */
    const VALUE_ENVELOPE_CONTAINS_ID_IS_ALREADY_USED = 'EnvelopeContainsIdIsAlreadyUsed';
    /**
     * Constant for value 'CouldNotCheckPermission'
     * @return string 'CouldNotCheckPermission'
     */
    const VALUE_COULD_NOT_CHECK_PERMISSION = 'CouldNotCheckPermission';
    /**
     * Constant for value 'DoesNotHaveSenderUnitPermission'
     * @return string 'DoesNotHaveSenderUnitPermission'
     */
    const VALUE_DOES_NOT_HAVE_SENDER_UNIT_PERMISSION = 'DoesNotHaveSenderUnitPermission';
    /**
     * Constant for value 'DoesNotHavePostBoxPermission'
     * @return string 'DoesNotHavePostBoxPermission'
     */
    const VALUE_DOES_NOT_HAVE_POST_BOX_PERMISSION = 'DoesNotHavePostBoxPermission';
    /**
     * Constant for value 'CouldNotCheckSignPermission'
     * @return string 'CouldNotCheckSignPermission'
     */
    const VALUE_COULD_NOT_CHECK_SIGN_PERMISSION = 'CouldNotCheckSignPermission';
    /**
     * Constant for value 'SignerHasNoPermission'
     * @return string 'SignerHasNoPermission'
     */
    const VALUE_SIGNER_HAS_NO_PERMISSION = 'SignerHasNoPermission';
    /**
     * Constant for value 'IllegalSign'
     * @return string 'IllegalSign'
     */
    const VALUE_ILLEGAL_SIGN = 'IllegalSign';
    /**
     * Constant for value 'CouldNotCheckAddress'
     * @return string 'CouldNotCheckAddress'
     */
    const VALUE_COULD_NOT_CHECK_ADDRESS = 'CouldNotCheckAddress';
    /**
     * Constant for value 'AddressNotFound'
     * @return string 'AddressNotFound'
     */
    const VALUE_ADDRESS_NOT_FOUND = 'AddressNotFound';
    /**
     * Constant for value 'DoesNotHaveEntegratorApplication'
     * @return string 'DoesNotHaveEntegratorApplication'
     */
    const VALUE_DOES_NOT_HAVE_ENTEGRATOR_APPLICATION = 'DoesNotHaveEntegratorApplication';
    /**
     * Constant for value 'CouldNotPrepareSystemResponse'
     * @return string 'CouldNotPrepareSystemResponse'
     */
    const VALUE_COULD_NOT_PREPARE_SYSTEM_RESPONSE = 'CouldNotPrepareSystemResponse';
    /**
     * Constant for value 'SystemError'
     * @return string 'SystemError'
     */
    const VALUE_SYSTEM_ERROR = 'SystemError';
    /**
     * Constant for value 'EnvelopedProcessSuccessfully'
     * @return string 'EnvelopedProcessSuccessfully'
     */
    const VALUE_ENVELOPED_PROCESS_SUCCESSFULLY = 'EnvelopedProcessSuccessfully';
    /**
     * Constant for value 'CouldNotSendDocumentToTheAddress'
     * @return string 'CouldNotSendDocumentToTheAddress'
     */
    const VALUE_COULD_NOT_SEND_DOCUMENT_TO_THE_ADDRESS = 'CouldNotSendDocumentToTheAddress';
    /**
     * Constant for value 'DocumentSendingFailedWillNotRetry'
     * @return string 'DocumentSendingFailedWillNotRetry'
     */
    const VALUE_DOCUMENT_SENDING_FAILED_WILL_NOT_RETRY = 'DocumentSendingFailedWillNotRetry';
    /**
     * Constant for value 'TargetDoesNotSendSystemResponse'
     * @return string 'TargetDoesNotSendSystemResponse'
     */
    const VALUE_TARGET_DOES_NOT_SEND_SYSTEM_RESPONSE = 'TargetDoesNotSendSystemResponse';
    /**
     * Constant for value 'TargetSendFailedSystemResponse'
     * @return string 'TargetSendFailedSystemResponse'
     */
    const VALUE_TARGET_SEND_FAILED_SYSTEM_RESPONSE = 'TargetSendFailedSystemResponse';
    /**
     * Constant for value 'InvoiceLinkedToCancel'
     * @return string 'InvoiceLinkedToCancel'
     */
    const VALUE_INVOICE_LINKED_TO_CANCEL = 'InvoiceLinkedToCancel';
    /**
     * Constant for value 'CompletedSuccessfully'
     * @return string 'CompletedSuccessfully'
     */
    const VALUE_COMPLETED_SUCCESSFULLY = 'CompletedSuccessfully';
    /**
     * Constant for value 'CouldNotFindEnvelopeId'
     * @return string 'CouldNotFindEnvelopeId'
     */
    const VALUE_COULD_NOT_FIND_ENVELOPE_ID = 'CouldNotFindEnvelopeId';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NO_ENVELOPE
     * @uses self::VALUE_PREPARING
     * @uses self::VALUE_ENVELOP_IS_QUEUED
     * @uses self::VALUE_ENVELOP_IS_PROCESSING
     * @uses self::VALUE_FILE_IS_NOT_ZIP
     * @uses self::VALUE_INVALID_ENVELOP_ID_LENGTH
     * @uses self::VALUE_ENVELOP_COULD_NOT_COPIED_FROM_ARCHIVE
     * @uses self::VALUE_COULD_NOT_OPEN_ZIP
     * @uses self::VALUE_ZIP_IS_EMPTY
     * @uses self::VALUE_FILE_IS_NOT_XML
     * @uses self::VALUE_ENVELOPE_ID_AND_XML_NAME_MUST_BE_SAME
     * @uses self::VALUE_COULD_NOT_PARSE_DOCUMENT
     * @uses self::VALUE_ENVELOPE_ID_NOT_FOUND
     * @uses self::VALUE_ENVELOPE_ID_AND_ZIP_NAME_MUST_BE_SAME
     * @uses self::VALUE_INVALID_VERSION
     * @uses self::VALUE_SCHEMATRON_CHECK_FAILED
     * @uses self::VALUE_XML_SCHEMA_CHECK_FAILED
     * @uses self::VALUE_COULD_NOT_TAKE_TCKN_VKN_FOR_SIGNER
     * @uses self::VALUE_COULD_NOT_SAVE_SIGNITURE
     * @uses self::VALUE_ENVELOPE_ID_IS_ALREADY_USED
     * @uses self::VALUE_ENVELOPE_CONTAINS_ID_IS_ALREADY_USED
     * @uses self::VALUE_COULD_NOT_CHECK_PERMISSION
     * @uses self::VALUE_DOES_NOT_HAVE_SENDER_UNIT_PERMISSION
     * @uses self::VALUE_DOES_NOT_HAVE_POST_BOX_PERMISSION
     * @uses self::VALUE_COULD_NOT_CHECK_SIGN_PERMISSION
     * @uses self::VALUE_SIGNER_HAS_NO_PERMISSION
     * @uses self::VALUE_ILLEGAL_SIGN
     * @uses self::VALUE_COULD_NOT_CHECK_ADDRESS
     * @uses self::VALUE_ADDRESS_NOT_FOUND
     * @uses self::VALUE_DOES_NOT_HAVE_ENTEGRATOR_APPLICATION
     * @uses self::VALUE_COULD_NOT_PREPARE_SYSTEM_RESPONSE
     * @uses self::VALUE_SYSTEM_ERROR
     * @uses self::VALUE_ENVELOPED_PROCESS_SUCCESSFULLY
     * @uses self::VALUE_COULD_NOT_SEND_DOCUMENT_TO_THE_ADDRESS
     * @uses self::VALUE_DOCUMENT_SENDING_FAILED_WILL_NOT_RETRY
     * @uses self::VALUE_TARGET_DOES_NOT_SEND_SYSTEM_RESPONSE
     * @uses self::VALUE_TARGET_SEND_FAILED_SYSTEM_RESPONSE
     * @uses self::VALUE_INVOICE_LINKED_TO_CANCEL
     * @uses self::VALUE_COMPLETED_SUCCESSFULLY
     * @uses self::VALUE_COULD_NOT_FIND_ENVELOPE_ID
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NO_ENVELOPE,
            self::VALUE_PREPARING,
            self::VALUE_ENVELOP_IS_QUEUED,
            self::VALUE_ENVELOP_IS_PROCESSING,
            self::VALUE_FILE_IS_NOT_ZIP,
            self::VALUE_INVALID_ENVELOP_ID_LENGTH,
            self::VALUE_ENVELOP_COULD_NOT_COPIED_FROM_ARCHIVE,
            self::VALUE_COULD_NOT_OPEN_ZIP,
            self::VALUE_ZIP_IS_EMPTY,
            self::VALUE_FILE_IS_NOT_XML,
            self::VALUE_ENVELOPE_ID_AND_XML_NAME_MUST_BE_SAME,
            self::VALUE_COULD_NOT_PARSE_DOCUMENT,
            self::VALUE_ENVELOPE_ID_NOT_FOUND,
            self::VALUE_ENVELOPE_ID_AND_ZIP_NAME_MUST_BE_SAME,
            self::VALUE_INVALID_VERSION,
            self::VALUE_SCHEMATRON_CHECK_FAILED,
            self::VALUE_XML_SCHEMA_CHECK_FAILED,
            self::VALUE_COULD_NOT_TAKE_TCKN_VKN_FOR_SIGNER,
            self::VALUE_COULD_NOT_SAVE_SIGNITURE,
            self::VALUE_ENVELOPE_ID_IS_ALREADY_USED,
            self::VALUE_ENVELOPE_CONTAINS_ID_IS_ALREADY_USED,
            self::VALUE_COULD_NOT_CHECK_PERMISSION,
            self::VALUE_DOES_NOT_HAVE_SENDER_UNIT_PERMISSION,
            self::VALUE_DOES_NOT_HAVE_POST_BOX_PERMISSION,
            self::VALUE_COULD_NOT_CHECK_SIGN_PERMISSION,
            self::VALUE_SIGNER_HAS_NO_PERMISSION,
            self::VALUE_ILLEGAL_SIGN,
            self::VALUE_COULD_NOT_CHECK_ADDRESS,
            self::VALUE_ADDRESS_NOT_FOUND,
            self::VALUE_DOES_NOT_HAVE_ENTEGRATOR_APPLICATION,
            self::VALUE_COULD_NOT_PREPARE_SYSTEM_RESPONSE,
            self::VALUE_SYSTEM_ERROR,
            self::VALUE_ENVELOPED_PROCESS_SUCCESSFULLY,
            self::VALUE_COULD_NOT_SEND_DOCUMENT_TO_THE_ADDRESS,
            self::VALUE_DOCUMENT_SENDING_FAILED_WILL_NOT_RETRY,
            self::VALUE_TARGET_DOES_NOT_SEND_SYSTEM_RESPONSE,
            self::VALUE_TARGET_SEND_FAILED_SYSTEM_RESPONSE,
            self::VALUE_INVOICE_LINKED_TO_CANCEL,
            self::VALUE_COMPLETED_SUCCESSFULLY,
            self::VALUE_COULD_NOT_FIND_ENVELOPE_ID,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
