<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WhoAmIInfo StructType
 * @subpackage Structs
 */
class WhoAmIInfo extends AbstractStructBase
{
    /**
     * The User
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\UserShortInfo
     */
    public $User;
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\CustomerWithoutServiceInformation
     */
    public $Customer;
    /**
     * Constructor method for WhoAmIInfo
     * @uses WhoAmIInfo::setUser()
     * @uses WhoAmIInfo::setCustomer()
     * @param \Mnm\StructType\UserShortInfo $user
     * @param \Mnm\StructType\CustomerWithoutServiceInformation $customer
     */
    public function __construct(\Mnm\StructType\UserShortInfo $user = null, \Mnm\StructType\CustomerWithoutServiceInformation $customer = null)
    {
        $this
            ->setUser($user)
            ->setCustomer($customer);
    }
    /**
     * Get User value
     * @return \Mnm\StructType\UserShortInfo|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param \Mnm\StructType\UserShortInfo $user
     * @return \Mnm\StructType\WhoAmIInfo
     */
    public function setUser(\Mnm\StructType\UserShortInfo $user = null)
    {
        $this->User = $user;
        return $this;
    }
    /**
     * Get Customer value
     * @return \Mnm\StructType\CustomerWithoutServiceInformation|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \Mnm\StructType\CustomerWithoutServiceInformation $customer
     * @return \Mnm\StructType\WhoAmIInfo
     */
    public function setCustomer(\Mnm\StructType\CustomerWithoutServiceInformation $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\WhoAmIInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
