<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxTotalType StructType
 * @subpackage Structs
 */
class TaxTotalType extends AbstractStructBase
{
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q177:TaxAmount
     * @var \Mnm\StructType\TaxAmountType
     */
    public $TaxAmount;
    /**
     * The TaxSubtotal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\TaxSubtotalType[]
     */
    public $TaxSubtotal;
    /**
     * Constructor method for TaxTotalType
     * @uses TaxTotalType::setTaxAmount()
     * @uses TaxTotalType::setTaxSubtotal()
     * @param \Mnm\StructType\TaxAmountType $taxAmount
     * @param \Mnm\StructType\TaxSubtotalType[] $taxSubtotal
     */
    public function __construct(\Mnm\StructType\TaxAmountType $taxAmount = null, array $taxSubtotal = array())
    {
        $this
            ->setTaxAmount($taxAmount)
            ->setTaxSubtotal($taxSubtotal);
    }
    /**
     * Get TaxAmount value
     * @return \Mnm\StructType\TaxAmountType|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param \Mnm\StructType\TaxAmountType $taxAmount
     * @return \Mnm\StructType\TaxTotalType
     */
    public function setTaxAmount(\Mnm\StructType\TaxAmountType $taxAmount = null)
    {
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get TaxSubtotal value
     * @return \Mnm\StructType\TaxSubtotalType[]|null
     */
    public function getTaxSubtotal()
    {
        return $this->TaxSubtotal;
    }
    /**
     * Set TaxSubtotal value
     * @param \Mnm\StructType\TaxSubtotalType[] $taxSubtotal
     * @return \Mnm\StructType\TaxTotalType
     */
    public function setTaxSubtotal(array $taxSubtotal = array())
    {
        $this->TaxSubtotal = $taxSubtotal;
        return $this;
    }
    /**
     * Add item to TaxSubtotal value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\TaxSubtotalType $item
     * @return \Mnm\StructType\TaxTotalType
     */
    public function addToTaxSubtotal(\Mnm\StructType\TaxSubtotalType $item)
    {
        $this->TaxSubtotal[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\TaxTotalType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
