<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxSubtotalType StructType
 * @subpackage Structs
 */
class TaxSubtotalType extends AbstractStructBase
{
    /**
     * The TaxableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q178:TaxableAmount
     * @var \Mnm\StructType\TaxableAmountType
     */
    public $TaxableAmount;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q179:TaxAmount
     * @var \Mnm\StructType\TaxAmountType
     */
    public $TaxAmount;
    /**
     * The CalculationSequenceNumeric
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q180:CalculationSequenceNumeric
     * @var \Mnm\StructType\CalculationSequenceNumericType
     */
    public $CalculationSequenceNumeric;
    /**
     * The TransactionCurrencyTaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q181:TransactionCurrencyTaxAmount
     * @var \Mnm\StructType\TransactionCurrencyTaxAmountType
     */
    public $TransactionCurrencyTaxAmount;
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q182:Percent
     * @var \Mnm\StructType\PercentType
     */
    public $Percent;
    /**
     * The BaseUnitMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q183:BaseUnitMeasure
     * @var \Mnm\StructType\BaseUnitMeasureType
     */
    public $BaseUnitMeasure;
    /**
     * The PerUnitAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q184:PerUnitAmount
     * @var \Mnm\StructType\PerUnitAmountType
     */
    public $PerUnitAmount;
    /**
     * The TaxCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\TaxCategoryType
     */
    public $TaxCategory;
    /**
     * Constructor method for TaxSubtotalType
     * @uses TaxSubtotalType::setTaxableAmount()
     * @uses TaxSubtotalType::setTaxAmount()
     * @uses TaxSubtotalType::setCalculationSequenceNumeric()
     * @uses TaxSubtotalType::setTransactionCurrencyTaxAmount()
     * @uses TaxSubtotalType::setPercent()
     * @uses TaxSubtotalType::setBaseUnitMeasure()
     * @uses TaxSubtotalType::setPerUnitAmount()
     * @uses TaxSubtotalType::setTaxCategory()
     * @param \Mnm\StructType\TaxableAmountType $taxableAmount
     * @param \Mnm\StructType\TaxAmountType $taxAmount
     * @param \Mnm\StructType\CalculationSequenceNumericType $calculationSequenceNumeric
     * @param \Mnm\StructType\TransactionCurrencyTaxAmountType $transactionCurrencyTaxAmount
     * @param \Mnm\StructType\PercentType $percent
     * @param \Mnm\StructType\BaseUnitMeasureType $baseUnitMeasure
     * @param \Mnm\StructType\PerUnitAmountType $perUnitAmount
     * @param \Mnm\StructType\TaxCategoryType $taxCategory
     */
    public function __construct(\Mnm\StructType\TaxableAmountType $taxableAmount = null, \Mnm\StructType\TaxAmountType $taxAmount = null, \Mnm\StructType\CalculationSequenceNumericType $calculationSequenceNumeric = null, \Mnm\StructType\TransactionCurrencyTaxAmountType $transactionCurrencyTaxAmount = null, \Mnm\StructType\PercentType $percent = null, \Mnm\StructType\BaseUnitMeasureType $baseUnitMeasure = null, \Mnm\StructType\PerUnitAmountType $perUnitAmount = null, \Mnm\StructType\TaxCategoryType $taxCategory = null)
    {
        $this
            ->setTaxableAmount($taxableAmount)
            ->setTaxAmount($taxAmount)
            ->setCalculationSequenceNumeric($calculationSequenceNumeric)
            ->setTransactionCurrencyTaxAmount($transactionCurrencyTaxAmount)
            ->setPercent($percent)
            ->setBaseUnitMeasure($baseUnitMeasure)
            ->setPerUnitAmount($perUnitAmount)
            ->setTaxCategory($taxCategory);
    }
    /**
     * Get TaxableAmount value
     * @return \Mnm\StructType\TaxableAmountType|null
     */
    public function getTaxableAmount()
    {
        return $this->TaxableAmount;
    }
    /**
     * Set TaxableAmount value
     * @param \Mnm\StructType\TaxableAmountType $taxableAmount
     * @return \Mnm\StructType\TaxSubtotalType
     */
    public function setTaxableAmount(\Mnm\StructType\TaxableAmountType $taxableAmount = null)
    {
        $this->TaxableAmount = $taxableAmount;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return \Mnm\StructType\TaxAmountType|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param \Mnm\StructType\TaxAmountType $taxAmount
     * @return \Mnm\StructType\TaxSubtotalType
     */
    public function setTaxAmount(\Mnm\StructType\TaxAmountType $taxAmount = null)
    {
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get CalculationSequenceNumeric value
     * @return \Mnm\StructType\CalculationSequenceNumericType|null
     */
    public function getCalculationSequenceNumeric()
    {
        return $this->CalculationSequenceNumeric;
    }
    /**
     * Set CalculationSequenceNumeric value
     * @param \Mnm\StructType\CalculationSequenceNumericType $calculationSequenceNumeric
     * @return \Mnm\StructType\TaxSubtotalType
     */
    public function setCalculationSequenceNumeric(\Mnm\StructType\CalculationSequenceNumericType $calculationSequenceNumeric = null)
    {
        $this->CalculationSequenceNumeric = $calculationSequenceNumeric;
        return $this;
    }
    /**
     * Get TransactionCurrencyTaxAmount value
     * @return \Mnm\StructType\TransactionCurrencyTaxAmountType|null
     */
    public function getTransactionCurrencyTaxAmount()
    {
        return $this->TransactionCurrencyTaxAmount;
    }
    /**
     * Set TransactionCurrencyTaxAmount value
     * @param \Mnm\StructType\TransactionCurrencyTaxAmountType $transactionCurrencyTaxAmount
     * @return \Mnm\StructType\TaxSubtotalType
     */
    public function setTransactionCurrencyTaxAmount(\Mnm\StructType\TransactionCurrencyTaxAmountType $transactionCurrencyTaxAmount = null)
    {
        $this->TransactionCurrencyTaxAmount = $transactionCurrencyTaxAmount;
        return $this;
    }
    /**
     * Get Percent value
     * @return \Mnm\StructType\PercentType|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param \Mnm\StructType\PercentType $percent
     * @return \Mnm\StructType\TaxSubtotalType
     */
    public function setPercent(\Mnm\StructType\PercentType $percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get BaseUnitMeasure value
     * @return \Mnm\StructType\BaseUnitMeasureType|null
     */
    public function getBaseUnitMeasure()
    {
        return $this->BaseUnitMeasure;
    }
    /**
     * Set BaseUnitMeasure value
     * @param \Mnm\StructType\BaseUnitMeasureType $baseUnitMeasure
     * @return \Mnm\StructType\TaxSubtotalType
     */
    public function setBaseUnitMeasure(\Mnm\StructType\BaseUnitMeasureType $baseUnitMeasure = null)
    {
        $this->BaseUnitMeasure = $baseUnitMeasure;
        return $this;
    }
    /**
     * Get PerUnitAmount value
     * @return \Mnm\StructType\PerUnitAmountType|null
     */
    public function getPerUnitAmount()
    {
        return $this->PerUnitAmount;
    }
    /**
     * Set PerUnitAmount value
     * @param \Mnm\StructType\PerUnitAmountType $perUnitAmount
     * @return \Mnm\StructType\TaxSubtotalType
     */
    public function setPerUnitAmount(\Mnm\StructType\PerUnitAmountType $perUnitAmount = null)
    {
        $this->PerUnitAmount = $perUnitAmount;
        return $this;
    }
    /**
     * Get TaxCategory value
     * @return \Mnm\StructType\TaxCategoryType|null
     */
    public function getTaxCategory()
    {
        return $this->TaxCategory;
    }
    /**
     * Set TaxCategory value
     * @param \Mnm\StructType\TaxCategoryType $taxCategory
     * @return \Mnm\StructType\TaxSubtotalType
     */
    public function setTaxCategory(\Mnm\StructType\TaxCategoryType $taxCategory = null)
    {
        $this->TaxCategory = $taxCategory;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\TaxSubtotalType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
