<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SystemUserWithAlias StructType
 * @subpackage Structs
 */
class SystemUserWithAlias extends AbstractStructBase
{
    /**
     * The Definition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\SystemUserDefinition
     */
    public $Definition;
    /**
     * The ReceiverboxAliases
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\SystemUserAlias[]
     */
    public $ReceiverboxAliases;
    /**
     * The SenderboxAliases
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\SystemUserAlias[]
     */
    public $SenderboxAliases;
    /**
     * The DespatchReceiverboxAliases
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\SystemUserAlias[]
     */
    public $DespatchReceiverboxAliases;
    /**
     * The DespatchSenderboxAliases
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\SystemUserAlias[]
     */
    public $DespatchSenderboxAliases;
    /**
     * Constructor method for SystemUserWithAlias
     * @uses SystemUserWithAlias::setDefinition()
     * @uses SystemUserWithAlias::setReceiverboxAliases()
     * @uses SystemUserWithAlias::setSenderboxAliases()
     * @uses SystemUserWithAlias::setDespatchReceiverboxAliases()
     * @uses SystemUserWithAlias::setDespatchSenderboxAliases()
     * @param \Mnm\StructType\SystemUserDefinition $definition
     * @param \Mnm\StructType\SystemUserAlias[] $receiverboxAliases
     * @param \Mnm\StructType\SystemUserAlias[] $senderboxAliases
     * @param \Mnm\StructType\SystemUserAlias[] $despatchReceiverboxAliases
     * @param \Mnm\StructType\SystemUserAlias[] $despatchSenderboxAliases
     */
    public function __construct(\Mnm\StructType\SystemUserDefinition $definition = null, array $receiverboxAliases = array(), array $senderboxAliases = array(), array $despatchReceiverboxAliases = array(), array $despatchSenderboxAliases = array())
    {
        $this
            ->setDefinition($definition)
            ->setReceiverboxAliases($receiverboxAliases)
            ->setSenderboxAliases($senderboxAliases)
            ->setDespatchReceiverboxAliases($despatchReceiverboxAliases)
            ->setDespatchSenderboxAliases($despatchSenderboxAliases);
    }
    /**
     * Get Definition value
     * @return \Mnm\StructType\SystemUserDefinition|null
     */
    public function getDefinition()
    {
        return $this->Definition;
    }
    /**
     * Set Definition value
     * @param \Mnm\StructType\SystemUserDefinition $definition
     * @return \Mnm\StructType\SystemUserWithAlias
     */
    public function setDefinition(\Mnm\StructType\SystemUserDefinition $definition = null)
    {
        $this->Definition = $definition;
        return $this;
    }
    /**
     * Get ReceiverboxAliases value
     * @return \Mnm\StructType\SystemUserAlias[]|null
     */
    public function getReceiverboxAliases()
    {
        return $this->ReceiverboxAliases;
    }
    /**
     * Set ReceiverboxAliases value
     * @param \Mnm\StructType\SystemUserAlias[] $receiverboxAliases
     * @return \Mnm\StructType\SystemUserWithAlias
     */
    public function setReceiverboxAliases(array $receiverboxAliases = array())
    {
        $this->ReceiverboxAliases = $receiverboxAliases;
        return $this;
    }
    /**
     * Add item to ReceiverboxAliases value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\SystemUserAlias $item
     * @return \Mnm\StructType\SystemUserWithAlias
     */
    public function addToReceiverboxAliases(\Mnm\StructType\SystemUserAlias $item)
    {
        $this->ReceiverboxAliases[] = $item;
        return $this;
    }
    /**
     * Get SenderboxAliases value
     * @return \Mnm\StructType\SystemUserAlias[]|null
     */
    public function getSenderboxAliases()
    {
        return $this->SenderboxAliases;
    }
    /**
     * Set SenderboxAliases value
     * @param \Mnm\StructType\SystemUserAlias[] $senderboxAliases
     * @return \Mnm\StructType\SystemUserWithAlias
     */
    public function setSenderboxAliases(array $senderboxAliases = array())
    {
        $this->SenderboxAliases = $senderboxAliases;
        return $this;
    }
    /**
     * Add item to SenderboxAliases value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\SystemUserAlias $item
     * @return \Mnm\StructType\SystemUserWithAlias
     */
    public function addToSenderboxAliases(\Mnm\StructType\SystemUserAlias $item)
    {
        $this->SenderboxAliases[] = $item;
        return $this;
    }
    /**
     * Get DespatchReceiverboxAliases value
     * @return \Mnm\StructType\SystemUserAlias[]|null
     */
    public function getDespatchReceiverboxAliases()
    {
        return $this->DespatchReceiverboxAliases;
    }
    /**
     * Set DespatchReceiverboxAliases value
     * @param \Mnm\StructType\SystemUserAlias[] $despatchReceiverboxAliases
     * @return \Mnm\StructType\SystemUserWithAlias
     */
    public function setDespatchReceiverboxAliases(array $despatchReceiverboxAliases = array())
    {
        $this->DespatchReceiverboxAliases = $despatchReceiverboxAliases;
        return $this;
    }
    /**
     * Add item to DespatchReceiverboxAliases value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\SystemUserAlias $item
     * @return \Mnm\StructType\SystemUserWithAlias
     */
    public function addToDespatchReceiverboxAliases(\Mnm\StructType\SystemUserAlias $item)
    {
        $this->DespatchReceiverboxAliases[] = $item;
        return $this;
    }
    /**
     * Get DespatchSenderboxAliases value
     * @return \Mnm\StructType\SystemUserAlias[]|null
     */
    public function getDespatchSenderboxAliases()
    {
        return $this->DespatchSenderboxAliases;
    }
    /**
     * Set DespatchSenderboxAliases value
     * @param \Mnm\StructType\SystemUserAlias[] $despatchSenderboxAliases
     * @return \Mnm\StructType\SystemUserWithAlias
     */
    public function setDespatchSenderboxAliases(array $despatchSenderboxAliases = array())
    {
        $this->DespatchSenderboxAliases = $despatchSenderboxAliases;
        return $this;
    }
    /**
     * Add item to DespatchSenderboxAliases value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\SystemUserAlias $item
     * @return \Mnm\StructType\SystemUserWithAlias
     */
    public function addToDespatchSenderboxAliases(\Mnm\StructType\SystemUserAlias $item)
    {
        $this->DespatchSenderboxAliases[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\SystemUserWithAlias
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
