<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StowageType StructType
 * @subpackage Structs
 */
class StowageType extends AbstractStructBase
{
    /**
     * The LocationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q203:LocationID
     * @var \Mnm\StructType\LocationIDType
     */
    public $LocationID;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q204:Location
     * @var \Mnm\StructType\LocationType[]
     */
    public $Location;
    /**
     * The MeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\DimensionType[]
     */
    public $MeasurementDimension;
    /**
     * Constructor method for StowageType
     * @uses StowageType::setLocationID()
     * @uses StowageType::setLocation()
     * @uses StowageType::setMeasurementDimension()
     * @param \Mnm\StructType\LocationIDType $locationID
     * @param \Mnm\StructType\LocationType[] $location
     * @param \Mnm\StructType\DimensionType[] $measurementDimension
     */
    public function __construct(\Mnm\StructType\LocationIDType $locationID = null, array $location = array(), array $measurementDimension = array())
    {
        $this
            ->setLocationID($locationID)
            ->setLocation($location)
            ->setMeasurementDimension($measurementDimension);
    }
    /**
     * Get LocationID value
     * @return \Mnm\StructType\LocationIDType|null
     */
    public function getLocationID()
    {
        return $this->LocationID;
    }
    /**
     * Set LocationID value
     * @param \Mnm\StructType\LocationIDType $locationID
     * @return \Mnm\StructType\StowageType
     */
    public function setLocationID(\Mnm\StructType\LocationIDType $locationID = null)
    {
        $this->LocationID = $locationID;
        return $this;
    }
    /**
     * Get Location value
     * @return \Mnm\StructType\LocationType[]|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \Mnm\StructType\LocationType[] $location
     * @return \Mnm\StructType\StowageType
     */
    public function setLocation(array $location = array())
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Add item to Location value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\LocationType $item
     * @return \Mnm\StructType\StowageType
     */
    public function addToLocation(\Mnm\StructType\LocationType $item)
    {
        $this->Location[] = $item;
        return $this;
    }
    /**
     * Get MeasurementDimension value
     * @return \Mnm\StructType\DimensionType[]|null
     */
    public function getMeasurementDimension()
    {
        return $this->MeasurementDimension;
    }
    /**
     * Set MeasurementDimension value
     * @param \Mnm\StructType\DimensionType[] $measurementDimension
     * @return \Mnm\StructType\StowageType
     */
    public function setMeasurementDimension(array $measurementDimension = array())
    {
        $this->MeasurementDimension = $measurementDimension;
        return $this;
    }
    /**
     * Add item to MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\DimensionType $item
     * @return \Mnm\StructType\StowageType
     */
    public function addToMeasurementDimension(\Mnm\StructType\DimensionType $item)
    {
        $this->MeasurementDimension[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\StowageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
