<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SmsMessageInformation StructType
 * @subpackage Structs
 */
class SmsMessageInformation extends AbstractStructBase
{
    /**
     * The Subject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Subject;
    /**
     * The To
     * @var string
     */
    public $To;
    /**
     * The BodyXsltIdentifier
     * @var string
     */
    public $BodyXsltIdentifier;
    /**
     * The SmsAccountIdentifier
     * @var string
     */
    public $SmsAccountIdentifier;
    /**
     * Constructor method for SmsMessageInformation
     * @uses SmsMessageInformation::setSubject()
     * @uses SmsMessageInformation::setTo()
     * @uses SmsMessageInformation::setBodyXsltIdentifier()
     * @uses SmsMessageInformation::setSmsAccountIdentifier()
     * @param string $subject
     * @param string $to
     * @param string $bodyXsltIdentifier
     * @param string $smsAccountIdentifier
     */
    public function __construct($subject = null, $to = null, $bodyXsltIdentifier = null, $smsAccountIdentifier = null)
    {
        $this
            ->setSubject($subject)
            ->setTo($to)
            ->setBodyXsltIdentifier($bodyXsltIdentifier)
            ->setSmsAccountIdentifier($smsAccountIdentifier);
    }
    /**
     * Get Subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->Subject;
    }
    /**
     * Set Subject value
     * @param string $subject
     * @return \Mnm\StructType\SmsMessageInformation
     */
    public function setSubject($subject = null)
    {
        $this->Subject = $subject;
        return $this;
    }
    /**
     * Get To value
     * @return string|null
     */
    public function getTo()
    {
        return $this->To;
    }
    /**
     * Set To value
     * @param string $to
     * @return \Mnm\StructType\SmsMessageInformation
     */
    public function setTo($to = null)
    {
        $this->To = $to;
        return $this;
    }
    /**
     * Get BodyXsltIdentifier value
     * @return string|null
     */
    public function getBodyXsltIdentifier()
    {
        return $this->BodyXsltIdentifier;
    }
    /**
     * Set BodyXsltIdentifier value
     * @param string $bodyXsltIdentifier
     * @return \Mnm\StructType\SmsMessageInformation
     */
    public function setBodyXsltIdentifier($bodyXsltIdentifier = null)
    {
        $this->BodyXsltIdentifier = $bodyXsltIdentifier;
        return $this;
    }
    /**
     * Get SmsAccountIdentifier value
     * @return string|null
     */
    public function getSmsAccountIdentifier()
    {
        return $this->SmsAccountIdentifier;
    }
    /**
     * Set SmsAccountIdentifier value
     * @param string $smsAccountIdentifier
     * @return \Mnm\StructType\SmsMessageInformation
     */
    public function setSmsAccountIdentifier($smsAccountIdentifier = null)
    {
        $this->SmsAccountIdentifier = $smsAccountIdentifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\SmsMessageInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
