<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentType StructType
 * @subpackage Structs
 */
class ShipmentType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q96:ID
     * @var \Mnm\StructType\IDType
     */
    public $ID;
    /**
     * The HandlingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q97:HandlingCode
     * @var \Mnm\StructType\HandlingCodeType
     */
    public $HandlingCode;
    /**
     * The HandlingInstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q98:HandlingInstructions
     * @var \Mnm\StructType\HandlingInstructionsType
     */
    public $HandlingInstructions;
    /**
     * The GrossWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q99:GrossWeightMeasure
     * @var \Mnm\StructType\GrossWeightMeasureType
     */
    public $GrossWeightMeasure;
    /**
     * The NetWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q100:NetWeightMeasure
     * @var \Mnm\StructType\NetWeightMeasureType
     */
    public $NetWeightMeasure;
    /**
     * The GrossVolumeMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q101:GrossVolumeMeasure
     * @var \Mnm\StructType\GrossVolumeMeasureType
     */
    public $GrossVolumeMeasure;
    /**
     * The NetVolumeMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q102:NetVolumeMeasure
     * @var \Mnm\StructType\NetVolumeMeasureType
     */
    public $NetVolumeMeasure;
    /**
     * The TotalGoodsItemQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q103:TotalGoodsItemQuantity
     * @var \Mnm\StructType\TotalGoodsItemQuantityType
     */
    public $TotalGoodsItemQuantity;
    /**
     * The TotalTransportHandlingUnitQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q104:TotalTransportHandlingUnitQuantity
     * @var \Mnm\StructType\TotalTransportHandlingUnitQuantityType
     */
    public $TotalTransportHandlingUnitQuantity;
    /**
     * The InsuranceValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q105:InsuranceValueAmount
     * @var \Mnm\StructType\InsuranceValueAmountType
     */
    public $InsuranceValueAmount;
    /**
     * The DeclaredCustomsValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q106:DeclaredCustomsValueAmount
     * @var \Mnm\StructType\DeclaredCustomsValueAmountType
     */
    public $DeclaredCustomsValueAmount;
    /**
     * The DeclaredForCarriageValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q107:DeclaredForCarriageValueAmount
     * @var \Mnm\StructType\DeclaredForCarriageValueAmountType
     */
    public $DeclaredForCarriageValueAmount;
    /**
     * The DeclaredStatisticsValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q108:DeclaredStatisticsValueAmount
     * @var \Mnm\StructType\DeclaredStatisticsValueAmountType
     */
    public $DeclaredStatisticsValueAmount;
    /**
     * The FreeOnBoardValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q109:FreeOnBoardValueAmount
     * @var \Mnm\StructType\FreeOnBoardValueAmountType
     */
    public $FreeOnBoardValueAmount;
    /**
     * The SpecialInstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q110:SpecialInstructions
     * @var \Mnm\StructType\SpecialInstructionsType[]
     */
    public $SpecialInstructions;
    /**
     * The GoodsItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\GoodsItemType[]
     */
    public $GoodsItem;
    /**
     * The ShipmentStage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\ShipmentStageType[]
     */
    public $ShipmentStage;
    /**
     * The Delivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\DeliveryType
     */
    public $Delivery;
    /**
     * The TransportHandlingUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\TransportHandlingUnitType[]
     */
    public $TransportHandlingUnit;
    /**
     * The ReturnAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\AddressType
     */
    public $ReturnAddress;
    /**
     * The FirstArrivalPortLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\LocationType
     */
    public $FirstArrivalPortLocation;
    /**
     * The LastExitPortLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\LocationType
     */
    public $LastExitPortLocation;
    /**
     * Constructor method for ShipmentType
     * @uses ShipmentType::setID()
     * @uses ShipmentType::setHandlingCode()
     * @uses ShipmentType::setHandlingInstructions()
     * @uses ShipmentType::setGrossWeightMeasure()
     * @uses ShipmentType::setNetWeightMeasure()
     * @uses ShipmentType::setGrossVolumeMeasure()
     * @uses ShipmentType::setNetVolumeMeasure()
     * @uses ShipmentType::setTotalGoodsItemQuantity()
     * @uses ShipmentType::setTotalTransportHandlingUnitQuantity()
     * @uses ShipmentType::setInsuranceValueAmount()
     * @uses ShipmentType::setDeclaredCustomsValueAmount()
     * @uses ShipmentType::setDeclaredForCarriageValueAmount()
     * @uses ShipmentType::setDeclaredStatisticsValueAmount()
     * @uses ShipmentType::setFreeOnBoardValueAmount()
     * @uses ShipmentType::setSpecialInstructions()
     * @uses ShipmentType::setGoodsItem()
     * @uses ShipmentType::setShipmentStage()
     * @uses ShipmentType::setDelivery()
     * @uses ShipmentType::setTransportHandlingUnit()
     * @uses ShipmentType::setReturnAddress()
     * @uses ShipmentType::setFirstArrivalPortLocation()
     * @uses ShipmentType::setLastExitPortLocation()
     * @param \Mnm\StructType\IDType $iD
     * @param \Mnm\StructType\HandlingCodeType $handlingCode
     * @param \Mnm\StructType\HandlingInstructionsType $handlingInstructions
     * @param \Mnm\StructType\GrossWeightMeasureType $grossWeightMeasure
     * @param \Mnm\StructType\NetWeightMeasureType $netWeightMeasure
     * @param \Mnm\StructType\GrossVolumeMeasureType $grossVolumeMeasure
     * @param \Mnm\StructType\NetVolumeMeasureType $netVolumeMeasure
     * @param \Mnm\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity
     * @param \Mnm\StructType\TotalTransportHandlingUnitQuantityType $totalTransportHandlingUnitQuantity
     * @param \Mnm\StructType\InsuranceValueAmountType $insuranceValueAmount
     * @param \Mnm\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount
     * @param \Mnm\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount
     * @param \Mnm\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount
     * @param \Mnm\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount
     * @param \Mnm\StructType\SpecialInstructionsType[] $specialInstructions
     * @param \Mnm\StructType\GoodsItemType[] $goodsItem
     * @param \Mnm\StructType\ShipmentStageType[] $shipmentStage
     * @param \Mnm\StructType\DeliveryType $delivery
     * @param \Mnm\StructType\TransportHandlingUnitType[] $transportHandlingUnit
     * @param \Mnm\StructType\AddressType $returnAddress
     * @param \Mnm\StructType\LocationType $firstArrivalPortLocation
     * @param \Mnm\StructType\LocationType $lastExitPortLocation
     */
    public function __construct(\Mnm\StructType\IDType $iD = null, \Mnm\StructType\HandlingCodeType $handlingCode = null, \Mnm\StructType\HandlingInstructionsType $handlingInstructions = null, \Mnm\StructType\GrossWeightMeasureType $grossWeightMeasure = null, \Mnm\StructType\NetWeightMeasureType $netWeightMeasure = null, \Mnm\StructType\GrossVolumeMeasureType $grossVolumeMeasure = null, \Mnm\StructType\NetVolumeMeasureType $netVolumeMeasure = null, \Mnm\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity = null, \Mnm\StructType\TotalTransportHandlingUnitQuantityType $totalTransportHandlingUnitQuantity = null, \Mnm\StructType\InsuranceValueAmountType $insuranceValueAmount = null, \Mnm\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount = null, \Mnm\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount = null, \Mnm\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount = null, \Mnm\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount = null, array $specialInstructions = array(), array $goodsItem = array(), array $shipmentStage = array(), \Mnm\StructType\DeliveryType $delivery = null, array $transportHandlingUnit = array(), \Mnm\StructType\AddressType $returnAddress = null, \Mnm\StructType\LocationType $firstArrivalPortLocation = null, \Mnm\StructType\LocationType $lastExitPortLocation = null)
    {
        $this
            ->setID($iD)
            ->setHandlingCode($handlingCode)
            ->setHandlingInstructions($handlingInstructions)
            ->setGrossWeightMeasure($grossWeightMeasure)
            ->setNetWeightMeasure($netWeightMeasure)
            ->setGrossVolumeMeasure($grossVolumeMeasure)
            ->setNetVolumeMeasure($netVolumeMeasure)
            ->setTotalGoodsItemQuantity($totalGoodsItemQuantity)
            ->setTotalTransportHandlingUnitQuantity($totalTransportHandlingUnitQuantity)
            ->setInsuranceValueAmount($insuranceValueAmount)
            ->setDeclaredCustomsValueAmount($declaredCustomsValueAmount)
            ->setDeclaredForCarriageValueAmount($declaredForCarriageValueAmount)
            ->setDeclaredStatisticsValueAmount($declaredStatisticsValueAmount)
            ->setFreeOnBoardValueAmount($freeOnBoardValueAmount)
            ->setSpecialInstructions($specialInstructions)
            ->setGoodsItem($goodsItem)
            ->setShipmentStage($shipmentStage)
            ->setDelivery($delivery)
            ->setTransportHandlingUnit($transportHandlingUnit)
            ->setReturnAddress($returnAddress)
            ->setFirstArrivalPortLocation($firstArrivalPortLocation)
            ->setLastExitPortLocation($lastExitPortLocation);
    }
    /**
     * Get ID value
     * @return \Mnm\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\StructType\IDType $iD
     * @return \Mnm\StructType\ShipmentType
     */
    public function setID(\Mnm\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get HandlingCode value
     * @return \Mnm\StructType\HandlingCodeType|null
     */
    public function getHandlingCode()
    {
        return $this->HandlingCode;
    }
    /**
     * Set HandlingCode value
     * @param \Mnm\StructType\HandlingCodeType $handlingCode
     * @return \Mnm\StructType\ShipmentType
     */
    public function setHandlingCode(\Mnm\StructType\HandlingCodeType $handlingCode = null)
    {
        $this->HandlingCode = $handlingCode;
        return $this;
    }
    /**
     * Get HandlingInstructions value
     * @return \Mnm\StructType\HandlingInstructionsType|null
     */
    public function getHandlingInstructions()
    {
        return $this->HandlingInstructions;
    }
    /**
     * Set HandlingInstructions value
     * @param \Mnm\StructType\HandlingInstructionsType $handlingInstructions
     * @return \Mnm\StructType\ShipmentType
     */
    public function setHandlingInstructions(\Mnm\StructType\HandlingInstructionsType $handlingInstructions = null)
    {
        $this->HandlingInstructions = $handlingInstructions;
        return $this;
    }
    /**
     * Get GrossWeightMeasure value
     * @return \Mnm\StructType\GrossWeightMeasureType|null
     */
    public function getGrossWeightMeasure()
    {
        return $this->GrossWeightMeasure;
    }
    /**
     * Set GrossWeightMeasure value
     * @param \Mnm\StructType\GrossWeightMeasureType $grossWeightMeasure
     * @return \Mnm\StructType\ShipmentType
     */
    public function setGrossWeightMeasure(\Mnm\StructType\GrossWeightMeasureType $grossWeightMeasure = null)
    {
        $this->GrossWeightMeasure = $grossWeightMeasure;
        return $this;
    }
    /**
     * Get NetWeightMeasure value
     * @return \Mnm\StructType\NetWeightMeasureType|null
     */
    public function getNetWeightMeasure()
    {
        return $this->NetWeightMeasure;
    }
    /**
     * Set NetWeightMeasure value
     * @param \Mnm\StructType\NetWeightMeasureType $netWeightMeasure
     * @return \Mnm\StructType\ShipmentType
     */
    public function setNetWeightMeasure(\Mnm\StructType\NetWeightMeasureType $netWeightMeasure = null)
    {
        $this->NetWeightMeasure = $netWeightMeasure;
        return $this;
    }
    /**
     * Get GrossVolumeMeasure value
     * @return \Mnm\StructType\GrossVolumeMeasureType|null
     */
    public function getGrossVolumeMeasure()
    {
        return $this->GrossVolumeMeasure;
    }
    /**
     * Set GrossVolumeMeasure value
     * @param \Mnm\StructType\GrossVolumeMeasureType $grossVolumeMeasure
     * @return \Mnm\StructType\ShipmentType
     */
    public function setGrossVolumeMeasure(\Mnm\StructType\GrossVolumeMeasureType $grossVolumeMeasure = null)
    {
        $this->GrossVolumeMeasure = $grossVolumeMeasure;
        return $this;
    }
    /**
     * Get NetVolumeMeasure value
     * @return \Mnm\StructType\NetVolumeMeasureType|null
     */
    public function getNetVolumeMeasure()
    {
        return $this->NetVolumeMeasure;
    }
    /**
     * Set NetVolumeMeasure value
     * @param \Mnm\StructType\NetVolumeMeasureType $netVolumeMeasure
     * @return \Mnm\StructType\ShipmentType
     */
    public function setNetVolumeMeasure(\Mnm\StructType\NetVolumeMeasureType $netVolumeMeasure = null)
    {
        $this->NetVolumeMeasure = $netVolumeMeasure;
        return $this;
    }
    /**
     * Get TotalGoodsItemQuantity value
     * @return \Mnm\StructType\TotalGoodsItemQuantityType|null
     */
    public function getTotalGoodsItemQuantity()
    {
        return $this->TotalGoodsItemQuantity;
    }
    /**
     * Set TotalGoodsItemQuantity value
     * @param \Mnm\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity
     * @return \Mnm\StructType\ShipmentType
     */
    public function setTotalGoodsItemQuantity(\Mnm\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity = null)
    {
        $this->TotalGoodsItemQuantity = $totalGoodsItemQuantity;
        return $this;
    }
    /**
     * Get TotalTransportHandlingUnitQuantity value
     * @return \Mnm\StructType\TotalTransportHandlingUnitQuantityType|null
     */
    public function getTotalTransportHandlingUnitQuantity()
    {
        return $this->TotalTransportHandlingUnitQuantity;
    }
    /**
     * Set TotalTransportHandlingUnitQuantity value
     * @param \Mnm\StructType\TotalTransportHandlingUnitQuantityType $totalTransportHandlingUnitQuantity
     * @return \Mnm\StructType\ShipmentType
     */
    public function setTotalTransportHandlingUnitQuantity(\Mnm\StructType\TotalTransportHandlingUnitQuantityType $totalTransportHandlingUnitQuantity = null)
    {
        $this->TotalTransportHandlingUnitQuantity = $totalTransportHandlingUnitQuantity;
        return $this;
    }
    /**
     * Get InsuranceValueAmount value
     * @return \Mnm\StructType\InsuranceValueAmountType|null
     */
    public function getInsuranceValueAmount()
    {
        return $this->InsuranceValueAmount;
    }
    /**
     * Set InsuranceValueAmount value
     * @param \Mnm\StructType\InsuranceValueAmountType $insuranceValueAmount
     * @return \Mnm\StructType\ShipmentType
     */
    public function setInsuranceValueAmount(\Mnm\StructType\InsuranceValueAmountType $insuranceValueAmount = null)
    {
        $this->InsuranceValueAmount = $insuranceValueAmount;
        return $this;
    }
    /**
     * Get DeclaredCustomsValueAmount value
     * @return \Mnm\StructType\DeclaredCustomsValueAmountType|null
     */
    public function getDeclaredCustomsValueAmount()
    {
        return $this->DeclaredCustomsValueAmount;
    }
    /**
     * Set DeclaredCustomsValueAmount value
     * @param \Mnm\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount
     * @return \Mnm\StructType\ShipmentType
     */
    public function setDeclaredCustomsValueAmount(\Mnm\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount = null)
    {
        $this->DeclaredCustomsValueAmount = $declaredCustomsValueAmount;
        return $this;
    }
    /**
     * Get DeclaredForCarriageValueAmount value
     * @return \Mnm\StructType\DeclaredForCarriageValueAmountType|null
     */
    public function getDeclaredForCarriageValueAmount()
    {
        return $this->DeclaredForCarriageValueAmount;
    }
    /**
     * Set DeclaredForCarriageValueAmount value
     * @param \Mnm\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount
     * @return \Mnm\StructType\ShipmentType
     */
    public function setDeclaredForCarriageValueAmount(\Mnm\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount = null)
    {
        $this->DeclaredForCarriageValueAmount = $declaredForCarriageValueAmount;
        return $this;
    }
    /**
     * Get DeclaredStatisticsValueAmount value
     * @return \Mnm\StructType\DeclaredStatisticsValueAmountType|null
     */
    public function getDeclaredStatisticsValueAmount()
    {
        return $this->DeclaredStatisticsValueAmount;
    }
    /**
     * Set DeclaredStatisticsValueAmount value
     * @param \Mnm\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount
     * @return \Mnm\StructType\ShipmentType
     */
    public function setDeclaredStatisticsValueAmount(\Mnm\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount = null)
    {
        $this->DeclaredStatisticsValueAmount = $declaredStatisticsValueAmount;
        return $this;
    }
    /**
     * Get FreeOnBoardValueAmount value
     * @return \Mnm\StructType\FreeOnBoardValueAmountType|null
     */
    public function getFreeOnBoardValueAmount()
    {
        return $this->FreeOnBoardValueAmount;
    }
    /**
     * Set FreeOnBoardValueAmount value
     * @param \Mnm\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount
     * @return \Mnm\StructType\ShipmentType
     */
    public function setFreeOnBoardValueAmount(\Mnm\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount = null)
    {
        $this->FreeOnBoardValueAmount = $freeOnBoardValueAmount;
        return $this;
    }
    /**
     * Get SpecialInstructions value
     * @return \Mnm\StructType\SpecialInstructionsType[]|null
     */
    public function getSpecialInstructions()
    {
        return $this->SpecialInstructions;
    }
    /**
     * Set SpecialInstructions value
     * @param \Mnm\StructType\SpecialInstructionsType[] $specialInstructions
     * @return \Mnm\StructType\ShipmentType
     */
    public function setSpecialInstructions(array $specialInstructions = array())
    {
        $this->SpecialInstructions = $specialInstructions;
        return $this;
    }
    /**
     * Add item to SpecialInstructions value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\SpecialInstructionsType $item
     * @return \Mnm\StructType\ShipmentType
     */
    public function addToSpecialInstructions(\Mnm\StructType\SpecialInstructionsType $item)
    {
        $this->SpecialInstructions[] = $item;
        return $this;
    }
    /**
     * Get GoodsItem value
     * @return \Mnm\StructType\GoodsItemType[]|null
     */
    public function getGoodsItem()
    {
        return $this->GoodsItem;
    }
    /**
     * Set GoodsItem value
     * @param \Mnm\StructType\GoodsItemType[] $goodsItem
     * @return \Mnm\StructType\ShipmentType
     */
    public function setGoodsItem(array $goodsItem = array())
    {
        $this->GoodsItem = $goodsItem;
        return $this;
    }
    /**
     * Add item to GoodsItem value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\GoodsItemType $item
     * @return \Mnm\StructType\ShipmentType
     */
    public function addToGoodsItem(\Mnm\StructType\GoodsItemType $item)
    {
        $this->GoodsItem[] = $item;
        return $this;
    }
    /**
     * Get ShipmentStage value
     * @return \Mnm\StructType\ShipmentStageType[]|null
     */
    public function getShipmentStage()
    {
        return $this->ShipmentStage;
    }
    /**
     * Set ShipmentStage value
     * @param \Mnm\StructType\ShipmentStageType[] $shipmentStage
     * @return \Mnm\StructType\ShipmentType
     */
    public function setShipmentStage(array $shipmentStage = array())
    {
        $this->ShipmentStage = $shipmentStage;
        return $this;
    }
    /**
     * Add item to ShipmentStage value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\ShipmentStageType $item
     * @return \Mnm\StructType\ShipmentType
     */
    public function addToShipmentStage(\Mnm\StructType\ShipmentStageType $item)
    {
        $this->ShipmentStage[] = $item;
        return $this;
    }
    /**
     * Get Delivery value
     * @return \Mnm\StructType\DeliveryType|null
     */
    public function getDelivery()
    {
        return $this->Delivery;
    }
    /**
     * Set Delivery value
     * @param \Mnm\StructType\DeliveryType $delivery
     * @return \Mnm\StructType\ShipmentType
     */
    public function setDelivery(\Mnm\StructType\DeliveryType $delivery = null)
    {
        $this->Delivery = $delivery;
        return $this;
    }
    /**
     * Get TransportHandlingUnit value
     * @return \Mnm\StructType\TransportHandlingUnitType[]|null
     */
    public function getTransportHandlingUnit()
    {
        return $this->TransportHandlingUnit;
    }
    /**
     * Set TransportHandlingUnit value
     * @param \Mnm\StructType\TransportHandlingUnitType[] $transportHandlingUnit
     * @return \Mnm\StructType\ShipmentType
     */
    public function setTransportHandlingUnit(array $transportHandlingUnit = array())
    {
        $this->TransportHandlingUnit = $transportHandlingUnit;
        return $this;
    }
    /**
     * Add item to TransportHandlingUnit value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\TransportHandlingUnitType $item
     * @return \Mnm\StructType\ShipmentType
     */
    public function addToTransportHandlingUnit(\Mnm\StructType\TransportHandlingUnitType $item)
    {
        $this->TransportHandlingUnit[] = $item;
        return $this;
    }
    /**
     * Get ReturnAddress value
     * @return \Mnm\StructType\AddressType|null
     */
    public function getReturnAddress()
    {
        return $this->ReturnAddress;
    }
    /**
     * Set ReturnAddress value
     * @param \Mnm\StructType\AddressType $returnAddress
     * @return \Mnm\StructType\ShipmentType
     */
    public function setReturnAddress(\Mnm\StructType\AddressType $returnAddress = null)
    {
        $this->ReturnAddress = $returnAddress;
        return $this;
    }
    /**
     * Get FirstArrivalPortLocation value
     * @return \Mnm\StructType\LocationType|null
     */
    public function getFirstArrivalPortLocation()
    {
        return $this->FirstArrivalPortLocation;
    }
    /**
     * Set FirstArrivalPortLocation value
     * @param \Mnm\StructType\LocationType $firstArrivalPortLocation
     * @return \Mnm\StructType\ShipmentType
     */
    public function setFirstArrivalPortLocation(\Mnm\StructType\LocationType $firstArrivalPortLocation = null)
    {
        $this->FirstArrivalPortLocation = $firstArrivalPortLocation;
        return $this;
    }
    /**
     * Get LastExitPortLocation value
     * @return \Mnm\StructType\LocationType|null
     */
    public function getLastExitPortLocation()
    {
        return $this->LastExitPortLocation;
    }
    /**
     * Set LastExitPortLocation value
     * @param \Mnm\StructType\LocationType $lastExitPortLocation
     * @return \Mnm\StructType\ShipmentType
     */
    public function setLastExitPortLocation(\Mnm\StructType\LocationType $lastExitPortLocation = null)
    {
        $this->LastExitPortLocation = $lastExitPortLocation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\ShipmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
