<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartyType StructType
 * @subpackage Structs
 */
class PartyType extends AbstractStructBase
{
    /**
     * The WebsiteURI
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q18:WebsiteURI
     * @var \Mnm\StructType\WebsiteURIType
     */
    public $WebsiteURI;
    /**
     * The EndpointID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q19:EndpointID
     * @var \Mnm\StructType\EndpointIDType
     */
    public $EndpointID;
    /**
     * The IndustryClassificationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q20:IndustryClassificationCode
     * @var \Mnm\StructType\IndustryClassificationCodeType
     */
    public $IndustryClassificationCode;
    /**
     * The PartyIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\PartyIdentificationType[]
     */
    public $PartyIdentification;
    /**
     * The PartyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\PartyNameType
     */
    public $PartyName;
    /**
     * The PostalAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\AddressType
     */
    public $PostalAddress;
    /**
     * The PhysicalLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\LocationType
     */
    public $PhysicalLocation;
    /**
     * The PartyTaxScheme
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\PartyTaxSchemeType
     */
    public $PartyTaxScheme;
    /**
     * The PartyLegalEntity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\PartyLegalEntityType[]
     */
    public $PartyLegalEntity;
    /**
     * The Contact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\ContactType
     */
    public $Contact;
    /**
     * The Person
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\PersonType
     */
    public $Person;
    /**
     * The AgentParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\PartyType
     */
    public $AgentParty;
    /**
     * Constructor method for PartyType
     * @uses PartyType::setWebsiteURI()
     * @uses PartyType::setEndpointID()
     * @uses PartyType::setIndustryClassificationCode()
     * @uses PartyType::setPartyIdentification()
     * @uses PartyType::setPartyName()
     * @uses PartyType::setPostalAddress()
     * @uses PartyType::setPhysicalLocation()
     * @uses PartyType::setPartyTaxScheme()
     * @uses PartyType::setPartyLegalEntity()
     * @uses PartyType::setContact()
     * @uses PartyType::setPerson()
     * @uses PartyType::setAgentParty()
     * @param \Mnm\StructType\WebsiteURIType $websiteURI
     * @param \Mnm\StructType\EndpointIDType $endpointID
     * @param \Mnm\StructType\IndustryClassificationCodeType $industryClassificationCode
     * @param \Mnm\StructType\PartyIdentificationType[] $partyIdentification
     * @param \Mnm\StructType\PartyNameType $partyName
     * @param \Mnm\StructType\AddressType $postalAddress
     * @param \Mnm\StructType\LocationType $physicalLocation
     * @param \Mnm\StructType\PartyTaxSchemeType $partyTaxScheme
     * @param \Mnm\StructType\PartyLegalEntityType[] $partyLegalEntity
     * @param \Mnm\StructType\ContactType $contact
     * @param \Mnm\StructType\PersonType $person
     * @param \Mnm\StructType\PartyType $agentParty
     */
    public function __construct(\Mnm\StructType\WebsiteURIType $websiteURI = null, \Mnm\StructType\EndpointIDType $endpointID = null, \Mnm\StructType\IndustryClassificationCodeType $industryClassificationCode = null, array $partyIdentification = array(), \Mnm\StructType\PartyNameType $partyName = null, \Mnm\StructType\AddressType $postalAddress = null, \Mnm\StructType\LocationType $physicalLocation = null, \Mnm\StructType\PartyTaxSchemeType $partyTaxScheme = null, array $partyLegalEntity = array(), \Mnm\StructType\ContactType $contact = null, \Mnm\StructType\PersonType $person = null, \Mnm\StructType\PartyType $agentParty = null)
    {
        $this
            ->setWebsiteURI($websiteURI)
            ->setEndpointID($endpointID)
            ->setIndustryClassificationCode($industryClassificationCode)
            ->setPartyIdentification($partyIdentification)
            ->setPartyName($partyName)
            ->setPostalAddress($postalAddress)
            ->setPhysicalLocation($physicalLocation)
            ->setPartyTaxScheme($partyTaxScheme)
            ->setPartyLegalEntity($partyLegalEntity)
            ->setContact($contact)
            ->setPerson($person)
            ->setAgentParty($agentParty);
    }
    /**
     * Get WebsiteURI value
     * @return \Mnm\StructType\WebsiteURIType|null
     */
    public function getWebsiteURI()
    {
        return $this->WebsiteURI;
    }
    /**
     * Set WebsiteURI value
     * @param \Mnm\StructType\WebsiteURIType $websiteURI
     * @return \Mnm\StructType\PartyType
     */
    public function setWebsiteURI(\Mnm\StructType\WebsiteURIType $websiteURI = null)
    {
        $this->WebsiteURI = $websiteURI;
        return $this;
    }
    /**
     * Get EndpointID value
     * @return \Mnm\StructType\EndpointIDType|null
     */
    public function getEndpointID()
    {
        return $this->EndpointID;
    }
    /**
     * Set EndpointID value
     * @param \Mnm\StructType\EndpointIDType $endpointID
     * @return \Mnm\StructType\PartyType
     */
    public function setEndpointID(\Mnm\StructType\EndpointIDType $endpointID = null)
    {
        $this->EndpointID = $endpointID;
        return $this;
    }
    /**
     * Get IndustryClassificationCode value
     * @return \Mnm\StructType\IndustryClassificationCodeType|null
     */
    public function getIndustryClassificationCode()
    {
        return $this->IndustryClassificationCode;
    }
    /**
     * Set IndustryClassificationCode value
     * @param \Mnm\StructType\IndustryClassificationCodeType $industryClassificationCode
     * @return \Mnm\StructType\PartyType
     */
    public function setIndustryClassificationCode(\Mnm\StructType\IndustryClassificationCodeType $industryClassificationCode = null)
    {
        $this->IndustryClassificationCode = $industryClassificationCode;
        return $this;
    }
    /**
     * Get PartyIdentification value
     * @return \Mnm\StructType\PartyIdentificationType[]|null
     */
    public function getPartyIdentification()
    {
        return $this->PartyIdentification;
    }
    /**
     * Set PartyIdentification value
     * @param \Mnm\StructType\PartyIdentificationType[] $partyIdentification
     * @return \Mnm\StructType\PartyType
     */
    public function setPartyIdentification(array $partyIdentification = array())
    {
        $this->PartyIdentification = $partyIdentification;
        return $this;
    }
    /**
     * Add item to PartyIdentification value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\PartyIdentificationType $item
     * @return \Mnm\StructType\PartyType
     */
    public function addToPartyIdentification(\Mnm\StructType\PartyIdentificationType $item)
    {
        $this->PartyIdentification[] = $item;
        return $this;
    }
    /**
     * Get PartyName value
     * @return \Mnm\StructType\PartyNameType|null
     */
    public function getPartyName()
    {
        return $this->PartyName;
    }
    /**
     * Set PartyName value
     * @param \Mnm\StructType\PartyNameType $partyName
     * @return \Mnm\StructType\PartyType
     */
    public function setPartyName(\Mnm\StructType\PartyNameType $partyName = null)
    {
        $this->PartyName = $partyName;
        return $this;
    }
    /**
     * Get PostalAddress value
     * @return \Mnm\StructType\AddressType|null
     */
    public function getPostalAddress()
    {
        return $this->PostalAddress;
    }
    /**
     * Set PostalAddress value
     * @param \Mnm\StructType\AddressType $postalAddress
     * @return \Mnm\StructType\PartyType
     */
    public function setPostalAddress(\Mnm\StructType\AddressType $postalAddress = null)
    {
        $this->PostalAddress = $postalAddress;
        return $this;
    }
    /**
     * Get PhysicalLocation value
     * @return \Mnm\StructType\LocationType|null
     */
    public function getPhysicalLocation()
    {
        return $this->PhysicalLocation;
    }
    /**
     * Set PhysicalLocation value
     * @param \Mnm\StructType\LocationType $physicalLocation
     * @return \Mnm\StructType\PartyType
     */
    public function setPhysicalLocation(\Mnm\StructType\LocationType $physicalLocation = null)
    {
        $this->PhysicalLocation = $physicalLocation;
        return $this;
    }
    /**
     * Get PartyTaxScheme value
     * @return \Mnm\StructType\PartyTaxSchemeType|null
     */
    public function getPartyTaxScheme()
    {
        return $this->PartyTaxScheme;
    }
    /**
     * Set PartyTaxScheme value
     * @param \Mnm\StructType\PartyTaxSchemeType $partyTaxScheme
     * @return \Mnm\StructType\PartyType
     */
    public function setPartyTaxScheme(\Mnm\StructType\PartyTaxSchemeType $partyTaxScheme = null)
    {
        $this->PartyTaxScheme = $partyTaxScheme;
        return $this;
    }
    /**
     * Get PartyLegalEntity value
     * @return \Mnm\StructType\PartyLegalEntityType[]|null
     */
    public function getPartyLegalEntity()
    {
        return $this->PartyLegalEntity;
    }
    /**
     * Set PartyLegalEntity value
     * @param \Mnm\StructType\PartyLegalEntityType[] $partyLegalEntity
     * @return \Mnm\StructType\PartyType
     */
    public function setPartyLegalEntity(array $partyLegalEntity = array())
    {
        $this->PartyLegalEntity = $partyLegalEntity;
        return $this;
    }
    /**
     * Add item to PartyLegalEntity value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\PartyLegalEntityType $item
     * @return \Mnm\StructType\PartyType
     */
    public function addToPartyLegalEntity(\Mnm\StructType\PartyLegalEntityType $item)
    {
        $this->PartyLegalEntity[] = $item;
        return $this;
    }
    /**
     * Get Contact value
     * @return \Mnm\StructType\ContactType|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \Mnm\StructType\ContactType $contact
     * @return \Mnm\StructType\PartyType
     */
    public function setContact(\Mnm\StructType\ContactType $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get Person value
     * @return \Mnm\StructType\PersonType|null
     */
    public function getPerson()
    {
        return $this->Person;
    }
    /**
     * Set Person value
     * @param \Mnm\StructType\PersonType $person
     * @return \Mnm\StructType\PartyType
     */
    public function setPerson(\Mnm\StructType\PersonType $person = null)
    {
        $this->Person = $person;
        return $this;
    }
    /**
     * Get AgentParty value
     * @return \Mnm\StructType\PartyType|null
     */
    public function getAgentParty()
    {
        return $this->AgentParty;
    }
    /**
     * Set AgentParty value
     * @param \Mnm\StructType\PartyType $agentParty
     * @return \Mnm\StructType\PartyType
     */
    public function setAgentParty(\Mnm\StructType\PartyType $agentParty = null)
    {
        $this->AgentParty = $agentParty;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\PartyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
