<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MonetaryTotalType StructType
 * @subpackage Structs
 */
class MonetaryTotalType extends AbstractStructBase
{
    /**
     * The LineExtensionAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q252:LineExtensionAmount
     * @var \Mnm\StructType\LineExtensionAmountType
     */
    public $LineExtensionAmount;
    /**
     * The TaxExclusiveAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q253:TaxExclusiveAmount
     * @var \Mnm\StructType\TaxExclusiveAmountType
     */
    public $TaxExclusiveAmount;
    /**
     * The TaxInclusiveAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q254:TaxInclusiveAmount
     * @var \Mnm\StructType\TaxInclusiveAmountType
     */
    public $TaxInclusiveAmount;
    /**
     * The AllowanceTotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q255:AllowanceTotalAmount
     * @var \Mnm\StructType\AllowanceTotalAmountType
     */
    public $AllowanceTotalAmount;
    /**
     * The ChargeTotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q256:ChargeTotalAmount
     * @var \Mnm\StructType\ChargeTotalAmountType
     */
    public $ChargeTotalAmount;
    /**
     * The PayableRoundingAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q257:PayableRoundingAmount
     * @var \Mnm\StructType\PayableRoundingAmountType
     */
    public $PayableRoundingAmount;
    /**
     * The PayableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q258:PayableAmount
     * @var \Mnm\StructType\PayableAmountType
     */
    public $PayableAmount;
    /**
     * Constructor method for MonetaryTotalType
     * @uses MonetaryTotalType::setLineExtensionAmount()
     * @uses MonetaryTotalType::setTaxExclusiveAmount()
     * @uses MonetaryTotalType::setTaxInclusiveAmount()
     * @uses MonetaryTotalType::setAllowanceTotalAmount()
     * @uses MonetaryTotalType::setChargeTotalAmount()
     * @uses MonetaryTotalType::setPayableRoundingAmount()
     * @uses MonetaryTotalType::setPayableAmount()
     * @param \Mnm\StructType\LineExtensionAmountType $lineExtensionAmount
     * @param \Mnm\StructType\TaxExclusiveAmountType $taxExclusiveAmount
     * @param \Mnm\StructType\TaxInclusiveAmountType $taxInclusiveAmount
     * @param \Mnm\StructType\AllowanceTotalAmountType $allowanceTotalAmount
     * @param \Mnm\StructType\ChargeTotalAmountType $chargeTotalAmount
     * @param \Mnm\StructType\PayableRoundingAmountType $payableRoundingAmount
     * @param \Mnm\StructType\PayableAmountType $payableAmount
     */
    public function __construct(\Mnm\StructType\LineExtensionAmountType $lineExtensionAmount = null, \Mnm\StructType\TaxExclusiveAmountType $taxExclusiveAmount = null, \Mnm\StructType\TaxInclusiveAmountType $taxInclusiveAmount = null, \Mnm\StructType\AllowanceTotalAmountType $allowanceTotalAmount = null, \Mnm\StructType\ChargeTotalAmountType $chargeTotalAmount = null, \Mnm\StructType\PayableRoundingAmountType $payableRoundingAmount = null, \Mnm\StructType\PayableAmountType $payableAmount = null)
    {
        $this
            ->setLineExtensionAmount($lineExtensionAmount)
            ->setTaxExclusiveAmount($taxExclusiveAmount)
            ->setTaxInclusiveAmount($taxInclusiveAmount)
            ->setAllowanceTotalAmount($allowanceTotalAmount)
            ->setChargeTotalAmount($chargeTotalAmount)
            ->setPayableRoundingAmount($payableRoundingAmount)
            ->setPayableAmount($payableAmount);
    }
    /**
     * Get LineExtensionAmount value
     * @return \Mnm\StructType\LineExtensionAmountType|null
     */
    public function getLineExtensionAmount()
    {
        return $this->LineExtensionAmount;
    }
    /**
     * Set LineExtensionAmount value
     * @param \Mnm\StructType\LineExtensionAmountType $lineExtensionAmount
     * @return \Mnm\StructType\MonetaryTotalType
     */
    public function setLineExtensionAmount(\Mnm\StructType\LineExtensionAmountType $lineExtensionAmount = null)
    {
        $this->LineExtensionAmount = $lineExtensionAmount;
        return $this;
    }
    /**
     * Get TaxExclusiveAmount value
     * @return \Mnm\StructType\TaxExclusiveAmountType|null
     */
    public function getTaxExclusiveAmount()
    {
        return $this->TaxExclusiveAmount;
    }
    /**
     * Set TaxExclusiveAmount value
     * @param \Mnm\StructType\TaxExclusiveAmountType $taxExclusiveAmount
     * @return \Mnm\StructType\MonetaryTotalType
     */
    public function setTaxExclusiveAmount(\Mnm\StructType\TaxExclusiveAmountType $taxExclusiveAmount = null)
    {
        $this->TaxExclusiveAmount = $taxExclusiveAmount;
        return $this;
    }
    /**
     * Get TaxInclusiveAmount value
     * @return \Mnm\StructType\TaxInclusiveAmountType|null
     */
    public function getTaxInclusiveAmount()
    {
        return $this->TaxInclusiveAmount;
    }
    /**
     * Set TaxInclusiveAmount value
     * @param \Mnm\StructType\TaxInclusiveAmountType $taxInclusiveAmount
     * @return \Mnm\StructType\MonetaryTotalType
     */
    public function setTaxInclusiveAmount(\Mnm\StructType\TaxInclusiveAmountType $taxInclusiveAmount = null)
    {
        $this->TaxInclusiveAmount = $taxInclusiveAmount;
        return $this;
    }
    /**
     * Get AllowanceTotalAmount value
     * @return \Mnm\StructType\AllowanceTotalAmountType|null
     */
    public function getAllowanceTotalAmount()
    {
        return $this->AllowanceTotalAmount;
    }
    /**
     * Set AllowanceTotalAmount value
     * @param \Mnm\StructType\AllowanceTotalAmountType $allowanceTotalAmount
     * @return \Mnm\StructType\MonetaryTotalType
     */
    public function setAllowanceTotalAmount(\Mnm\StructType\AllowanceTotalAmountType $allowanceTotalAmount = null)
    {
        $this->AllowanceTotalAmount = $allowanceTotalAmount;
        return $this;
    }
    /**
     * Get ChargeTotalAmount value
     * @return \Mnm\StructType\ChargeTotalAmountType|null
     */
    public function getChargeTotalAmount()
    {
        return $this->ChargeTotalAmount;
    }
    /**
     * Set ChargeTotalAmount value
     * @param \Mnm\StructType\ChargeTotalAmountType $chargeTotalAmount
     * @return \Mnm\StructType\MonetaryTotalType
     */
    public function setChargeTotalAmount(\Mnm\StructType\ChargeTotalAmountType $chargeTotalAmount = null)
    {
        $this->ChargeTotalAmount = $chargeTotalAmount;
        return $this;
    }
    /**
     * Get PayableRoundingAmount value
     * @return \Mnm\StructType\PayableRoundingAmountType|null
     */
    public function getPayableRoundingAmount()
    {
        return $this->PayableRoundingAmount;
    }
    /**
     * Set PayableRoundingAmount value
     * @param \Mnm\StructType\PayableRoundingAmountType $payableRoundingAmount
     * @return \Mnm\StructType\MonetaryTotalType
     */
    public function setPayableRoundingAmount(\Mnm\StructType\PayableRoundingAmountType $payableRoundingAmount = null)
    {
        $this->PayableRoundingAmount = $payableRoundingAmount;
        return $this;
    }
    /**
     * Get PayableAmount value
     * @return \Mnm\StructType\PayableAmountType|null
     */
    public function getPayableAmount()
    {
        return $this->PayableAmount;
    }
    /**
     * Set PayableAmount value
     * @param \Mnm\StructType\PayableAmountType $payableAmount
     * @return \Mnm\StructType\MonetaryTotalType
     */
    public function setPayableAmount(\Mnm\StructType\PayableAmountType $payableAmount = null)
    {
        $this->PayableAmount = $payableAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\MonetaryTotalType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
