<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MailingInformation StructType
 * @subpackage Structs
 */
class MailingInformation extends AbstractStructBase
{
    /**
     * The EnableNotification
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $EnableNotification;
    /**
     * The Subject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Subject;
    /**
     * The Attachment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\MailAttachmentInformation
     */
    public $Attachment;
    /**
     * The To
     * @var string
     */
    public $To;
    /**
     * The BodyXsltIdentifier
     * @var string
     */
    public $BodyXsltIdentifier;
    /**
     * The EmailAccountIdentifier
     * @var string
     */
    public $EmailAccountIdentifier;
    /**
     * Constructor method for MailingInformation
     * @uses MailingInformation::setEnableNotification()
     * @uses MailingInformation::setSubject()
     * @uses MailingInformation::setAttachment()
     * @uses MailingInformation::setTo()
     * @uses MailingInformation::setBodyXsltIdentifier()
     * @uses MailingInformation::setEmailAccountIdentifier()
     * @param bool $enableNotification
     * @param string $subject
     * @param \Mnm\StructType\MailAttachmentInformation $attachment
     * @param string $to
     * @param string $bodyXsltIdentifier
     * @param string $emailAccountIdentifier
     */
    public function __construct($enableNotification = null, $subject = null, \Mnm\StructType\MailAttachmentInformation $attachment = null, $to = null, $bodyXsltIdentifier = null, $emailAccountIdentifier = null)
    {
        $this
            ->setEnableNotification($enableNotification)
            ->setSubject($subject)
            ->setAttachment($attachment)
            ->setTo($to)
            ->setBodyXsltIdentifier($bodyXsltIdentifier)
            ->setEmailAccountIdentifier($emailAccountIdentifier);
    }
    /**
     * Get EnableNotification value
     * @return bool
     */
    public function getEnableNotification()
    {
        return $this->EnableNotification;
    }
    /**
     * Set EnableNotification value
     * @param bool $enableNotification
     * @return \Mnm\StructType\MailingInformation
     */
    public function setEnableNotification($enableNotification = null)
    {
        $this->EnableNotification = $enableNotification;
        return $this;
    }
    /**
     * Get Subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->Subject;
    }
    /**
     * Set Subject value
     * @param string $subject
     * @return \Mnm\StructType\MailingInformation
     */
    public function setSubject($subject = null)
    {
        $this->Subject = $subject;
        return $this;
    }
    /**
     * Get Attachment value
     * @return \Mnm\StructType\MailAttachmentInformation|null
     */
    public function getAttachment()
    {
        return $this->Attachment;
    }
    /**
     * Set Attachment value
     * @param \Mnm\StructType\MailAttachmentInformation $attachment
     * @return \Mnm\StructType\MailingInformation
     */
    public function setAttachment(\Mnm\StructType\MailAttachmentInformation $attachment = null)
    {
        $this->Attachment = $attachment;
        return $this;
    }
    /**
     * Get To value
     * @return string|null
     */
    public function getTo()
    {
        return $this->To;
    }
    /**
     * Set To value
     * @param string $to
     * @return \Mnm\StructType\MailingInformation
     */
    public function setTo($to = null)
    {
        $this->To = $to;
        return $this;
    }
    /**
     * Get BodyXsltIdentifier value
     * @return string|null
     */
    public function getBodyXsltIdentifier()
    {
        return $this->BodyXsltIdentifier;
    }
    /**
     * Set BodyXsltIdentifier value
     * @param string $bodyXsltIdentifier
     * @return \Mnm\StructType\MailingInformation
     */
    public function setBodyXsltIdentifier($bodyXsltIdentifier = null)
    {
        $this->BodyXsltIdentifier = $bodyXsltIdentifier;
        return $this;
    }
    /**
     * Get EmailAccountIdentifier value
     * @return string|null
     */
    public function getEmailAccountIdentifier()
    {
        return $this->EmailAccountIdentifier;
    }
    /**
     * Set EmailAccountIdentifier value
     * @param string $emailAccountIdentifier
     * @return \Mnm\StructType\MailingInformation
     */
    public function setEmailAccountIdentifier($emailAccountIdentifier = null)
    {
        $this->EmailAccountIdentifier = $emailAccountIdentifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\MailingInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
