<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LotIdentificationType StructType
 * @subpackage Structs
 */
class LotIdentificationType extends AbstractStructBase
{
    /**
     * The LotNumberID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q165:LotNumberID
     * @var \Mnm\StructType\LotNumberIDType
     */
    public $LotNumberID;
    /**
     * The ExpiryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q166:ExpiryDate
     * @var \Mnm\StructType\ExpiryDateType
     */
    public $ExpiryDate;
    /**
     * The AdditionalItemProperty
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\ItemPropertyType[]
     */
    public $AdditionalItemProperty;
    /**
     * Constructor method for LotIdentificationType
     * @uses LotIdentificationType::setLotNumberID()
     * @uses LotIdentificationType::setExpiryDate()
     * @uses LotIdentificationType::setAdditionalItemProperty()
     * @param \Mnm\StructType\LotNumberIDType $lotNumberID
     * @param \Mnm\StructType\ExpiryDateType $expiryDate
     * @param \Mnm\StructType\ItemPropertyType[] $additionalItemProperty
     */
    public function __construct(\Mnm\StructType\LotNumberIDType $lotNumberID = null, \Mnm\StructType\ExpiryDateType $expiryDate = null, array $additionalItemProperty = array())
    {
        $this
            ->setLotNumberID($lotNumberID)
            ->setExpiryDate($expiryDate)
            ->setAdditionalItemProperty($additionalItemProperty);
    }
    /**
     * Get LotNumberID value
     * @return \Mnm\StructType\LotNumberIDType|null
     */
    public function getLotNumberID()
    {
        return $this->LotNumberID;
    }
    /**
     * Set LotNumberID value
     * @param \Mnm\StructType\LotNumberIDType $lotNumberID
     * @return \Mnm\StructType\LotIdentificationType
     */
    public function setLotNumberID(\Mnm\StructType\LotNumberIDType $lotNumberID = null)
    {
        $this->LotNumberID = $lotNumberID;
        return $this;
    }
    /**
     * Get ExpiryDate value
     * @return \Mnm\StructType\ExpiryDateType|null
     */
    public function getExpiryDate()
    {
        return $this->ExpiryDate;
    }
    /**
     * Set ExpiryDate value
     * @param \Mnm\StructType\ExpiryDateType $expiryDate
     * @return \Mnm\StructType\LotIdentificationType
     */
    public function setExpiryDate(\Mnm\StructType\ExpiryDateType $expiryDate = null)
    {
        $this->ExpiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get AdditionalItemProperty value
     * @return \Mnm\StructType\ItemPropertyType[]|null
     */
    public function getAdditionalItemProperty()
    {
        return $this->AdditionalItemProperty;
    }
    /**
     * Set AdditionalItemProperty value
     * @param \Mnm\StructType\ItemPropertyType[] $additionalItemProperty
     * @return \Mnm\StructType\LotIdentificationType
     */
    public function setAdditionalItemProperty(array $additionalItemProperty = array())
    {
        $this->AdditionalItemProperty = $additionalItemProperty;
        return $this;
    }
    /**
     * Add item to AdditionalItemProperty value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\ItemPropertyType $item
     * @return \Mnm\StructType\LotIdentificationType
     */
    public function addToAdditionalItemProperty(\Mnm\StructType\ItemPropertyType $item)
    {
        $this->AdditionalItemProperty[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\LotIdentificationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
