<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemType StructType
 * @subpackage Structs
 */
class ItemType extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q133:Description
     * @var \Mnm\StructType\DescriptionType
     */
    public $Description;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q134:Name
     * @var \Mnm\StructType\NameType
     */
    public $Name;
    /**
     * The Keyword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q135:Keyword
     * @var \Mnm\StructType\KeywordType
     */
    public $Keyword;
    /**
     * The BrandName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q136:BrandName
     * @var \Mnm\StructType\BrandNameType
     */
    public $BrandName;
    /**
     * The ModelName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q137:ModelName
     * @var \Mnm\StructType\ModelNameType
     */
    public $ModelName;
    /**
     * The BuyersItemIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\ItemIdentificationType
     */
    public $BuyersItemIdentification;
    /**
     * The SellersItemIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\ItemIdentificationType
     */
    public $SellersItemIdentification;
    /**
     * The ManufacturersItemIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\ItemIdentificationType
     */
    public $ManufacturersItemIdentification;
    /**
     * The AdditionalItemIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\ItemIdentificationType[]
     */
    public $AdditionalItemIdentification;
    /**
     * The OriginCountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\CountryType
     */
    public $OriginCountry;
    /**
     * The CommodityClassification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\CommodityClassificationType[]
     */
    public $CommodityClassification;
    /**
     * The ItemInstance
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\ItemInstanceType[]
     */
    public $ItemInstance;
    /**
     * Constructor method for ItemType
     * @uses ItemType::setDescription()
     * @uses ItemType::setName()
     * @uses ItemType::setKeyword()
     * @uses ItemType::setBrandName()
     * @uses ItemType::setModelName()
     * @uses ItemType::setBuyersItemIdentification()
     * @uses ItemType::setSellersItemIdentification()
     * @uses ItemType::setManufacturersItemIdentification()
     * @uses ItemType::setAdditionalItemIdentification()
     * @uses ItemType::setOriginCountry()
     * @uses ItemType::setCommodityClassification()
     * @uses ItemType::setItemInstance()
     * @param \Mnm\StructType\DescriptionType $description
     * @param \Mnm\StructType\NameType $name
     * @param \Mnm\StructType\KeywordType $keyword
     * @param \Mnm\StructType\BrandNameType $brandName
     * @param \Mnm\StructType\ModelNameType $modelName
     * @param \Mnm\StructType\ItemIdentificationType $buyersItemIdentification
     * @param \Mnm\StructType\ItemIdentificationType $sellersItemIdentification
     * @param \Mnm\StructType\ItemIdentificationType $manufacturersItemIdentification
     * @param \Mnm\StructType\ItemIdentificationType[] $additionalItemIdentification
     * @param \Mnm\StructType\CountryType $originCountry
     * @param \Mnm\StructType\CommodityClassificationType[] $commodityClassification
     * @param \Mnm\StructType\ItemInstanceType[] $itemInstance
     */
    public function __construct(\Mnm\StructType\DescriptionType $description = null, \Mnm\StructType\NameType $name = null, \Mnm\StructType\KeywordType $keyword = null, \Mnm\StructType\BrandNameType $brandName = null, \Mnm\StructType\ModelNameType $modelName = null, \Mnm\StructType\ItemIdentificationType $buyersItemIdentification = null, \Mnm\StructType\ItemIdentificationType $sellersItemIdentification = null, \Mnm\StructType\ItemIdentificationType $manufacturersItemIdentification = null, array $additionalItemIdentification = array(), \Mnm\StructType\CountryType $originCountry = null, array $commodityClassification = array(), array $itemInstance = array())
    {
        $this
            ->setDescription($description)
            ->setName($name)
            ->setKeyword($keyword)
            ->setBrandName($brandName)
            ->setModelName($modelName)
            ->setBuyersItemIdentification($buyersItemIdentification)
            ->setSellersItemIdentification($sellersItemIdentification)
            ->setManufacturersItemIdentification($manufacturersItemIdentification)
            ->setAdditionalItemIdentification($additionalItemIdentification)
            ->setOriginCountry($originCountry)
            ->setCommodityClassification($commodityClassification)
            ->setItemInstance($itemInstance);
    }
    /**
     * Get Description value
     * @return \Mnm\StructType\DescriptionType|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \Mnm\StructType\DescriptionType $description
     * @return \Mnm\StructType\ItemType
     */
    public function setDescription(\Mnm\StructType\DescriptionType $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Name value
     * @return \Mnm\StructType\NameType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \Mnm\StructType\NameType $name
     * @return \Mnm\StructType\ItemType
     */
    public function setName(\Mnm\StructType\NameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Keyword value
     * @return \Mnm\StructType\KeywordType|null
     */
    public function getKeyword()
    {
        return $this->Keyword;
    }
    /**
     * Set Keyword value
     * @param \Mnm\StructType\KeywordType $keyword
     * @return \Mnm\StructType\ItemType
     */
    public function setKeyword(\Mnm\StructType\KeywordType $keyword = null)
    {
        $this->Keyword = $keyword;
        return $this;
    }
    /**
     * Get BrandName value
     * @return \Mnm\StructType\BrandNameType|null
     */
    public function getBrandName()
    {
        return $this->BrandName;
    }
    /**
     * Set BrandName value
     * @param \Mnm\StructType\BrandNameType $brandName
     * @return \Mnm\StructType\ItemType
     */
    public function setBrandName(\Mnm\StructType\BrandNameType $brandName = null)
    {
        $this->BrandName = $brandName;
        return $this;
    }
    /**
     * Get ModelName value
     * @return \Mnm\StructType\ModelNameType|null
     */
    public function getModelName()
    {
        return $this->ModelName;
    }
    /**
     * Set ModelName value
     * @param \Mnm\StructType\ModelNameType $modelName
     * @return \Mnm\StructType\ItemType
     */
    public function setModelName(\Mnm\StructType\ModelNameType $modelName = null)
    {
        $this->ModelName = $modelName;
        return $this;
    }
    /**
     * Get BuyersItemIdentification value
     * @return \Mnm\StructType\ItemIdentificationType|null
     */
    public function getBuyersItemIdentification()
    {
        return $this->BuyersItemIdentification;
    }
    /**
     * Set BuyersItemIdentification value
     * @param \Mnm\StructType\ItemIdentificationType $buyersItemIdentification
     * @return \Mnm\StructType\ItemType
     */
    public function setBuyersItemIdentification(\Mnm\StructType\ItemIdentificationType $buyersItemIdentification = null)
    {
        $this->BuyersItemIdentification = $buyersItemIdentification;
        return $this;
    }
    /**
     * Get SellersItemIdentification value
     * @return \Mnm\StructType\ItemIdentificationType|null
     */
    public function getSellersItemIdentification()
    {
        return $this->SellersItemIdentification;
    }
    /**
     * Set SellersItemIdentification value
     * @param \Mnm\StructType\ItemIdentificationType $sellersItemIdentification
     * @return \Mnm\StructType\ItemType
     */
    public function setSellersItemIdentification(\Mnm\StructType\ItemIdentificationType $sellersItemIdentification = null)
    {
        $this->SellersItemIdentification = $sellersItemIdentification;
        return $this;
    }
    /**
     * Get ManufacturersItemIdentification value
     * @return \Mnm\StructType\ItemIdentificationType|null
     */
    public function getManufacturersItemIdentification()
    {
        return $this->ManufacturersItemIdentification;
    }
    /**
     * Set ManufacturersItemIdentification value
     * @param \Mnm\StructType\ItemIdentificationType $manufacturersItemIdentification
     * @return \Mnm\StructType\ItemType
     */
    public function setManufacturersItemIdentification(\Mnm\StructType\ItemIdentificationType $manufacturersItemIdentification = null)
    {
        $this->ManufacturersItemIdentification = $manufacturersItemIdentification;
        return $this;
    }
    /**
     * Get AdditionalItemIdentification value
     * @return \Mnm\StructType\ItemIdentificationType[]|null
     */
    public function getAdditionalItemIdentification()
    {
        return $this->AdditionalItemIdentification;
    }
    /**
     * Set AdditionalItemIdentification value
     * @param \Mnm\StructType\ItemIdentificationType[] $additionalItemIdentification
     * @return \Mnm\StructType\ItemType
     */
    public function setAdditionalItemIdentification(array $additionalItemIdentification = array())
    {
        $this->AdditionalItemIdentification = $additionalItemIdentification;
        return $this;
    }
    /**
     * Add item to AdditionalItemIdentification value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\ItemIdentificationType $item
     * @return \Mnm\StructType\ItemType
     */
    public function addToAdditionalItemIdentification(\Mnm\StructType\ItemIdentificationType $item)
    {
        $this->AdditionalItemIdentification[] = $item;
        return $this;
    }
    /**
     * Get OriginCountry value
     * @return \Mnm\StructType\CountryType|null
     */
    public function getOriginCountry()
    {
        return $this->OriginCountry;
    }
    /**
     * Set OriginCountry value
     * @param \Mnm\StructType\CountryType $originCountry
     * @return \Mnm\StructType\ItemType
     */
    public function setOriginCountry(\Mnm\StructType\CountryType $originCountry = null)
    {
        $this->OriginCountry = $originCountry;
        return $this;
    }
    /**
     * Get CommodityClassification value
     * @return \Mnm\StructType\CommodityClassificationType[]|null
     */
    public function getCommodityClassification()
    {
        return $this->CommodityClassification;
    }
    /**
     * Set CommodityClassification value
     * @param \Mnm\StructType\CommodityClassificationType[] $commodityClassification
     * @return \Mnm\StructType\ItemType
     */
    public function setCommodityClassification(array $commodityClassification = array())
    {
        $this->CommodityClassification = $commodityClassification;
        return $this;
    }
    /**
     * Add item to CommodityClassification value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\CommodityClassificationType $item
     * @return \Mnm\StructType\ItemType
     */
    public function addToCommodityClassification(\Mnm\StructType\CommodityClassificationType $item)
    {
        $this->CommodityClassification[] = $item;
        return $this;
    }
    /**
     * Get ItemInstance value
     * @return \Mnm\StructType\ItemInstanceType[]|null
     */
    public function getItemInstance()
    {
        return $this->ItemInstance;
    }
    /**
     * Set ItemInstance value
     * @param \Mnm\StructType\ItemInstanceType[] $itemInstance
     * @return \Mnm\StructType\ItemType
     */
    public function setItemInstance(array $itemInstance = array())
    {
        $this->ItemInstance = $itemInstance;
        return $this;
    }
    /**
     * Add item to ItemInstance value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\ItemInstanceType $item
     * @return \Mnm\StructType\ItemType
     */
    public function addToItemInstance(\Mnm\StructType\ItemInstanceType $item)
    {
        $this->ItemInstance[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\ItemType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
