<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemPropertyType StructType
 * @subpackage Structs
 */
class ItemPropertyType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q146:ID
     * @var \Mnm\StructType\IDType
     */
    public $ID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q147:Name
     * @var \Mnm\StructType\NameType
     */
    public $Name;
    /**
     * The NameCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q148:NameCode
     * @var \Mnm\StructType\NameCodeType
     */
    public $NameCode;
    /**
     * The TestMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q149:TestMethod
     * @var \Mnm\StructType\TestMethodType
     */
    public $TestMethod;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q150:Value
     * @var \Mnm\StructType\ValueType
     */
    public $Value;
    /**
     * The ValueQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q151:ValueQuantity
     * @var \Mnm\StructType\ValueQuantityType
     */
    public $ValueQuantity;
    /**
     * The ValueQualifier
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q152:ValueQualifier
     * @var \Mnm\StructType\ValueQualifierType[]
     */
    public $ValueQualifier;
    /**
     * The ImportanceCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q153:ImportanceCode
     * @var \Mnm\StructType\ImportanceCodeType
     */
    public $ImportanceCode;
    /**
     * The ListValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q154:ListValue
     * @var \Mnm\StructType\ListValueType[]
     */
    public $ListValue;
    /**
     * The UsabilityPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\PeriodType
     */
    public $UsabilityPeriod;
    /**
     * The ItemPropertyGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\ItemPropertyGroupType[]
     */
    public $ItemPropertyGroup;
    /**
     * The RangeDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\DimensionType
     */
    public $RangeDimension;
    /**
     * The ItemPropertyRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\ItemPropertyRangeType
     */
    public $ItemPropertyRange;
    /**
     * Constructor method for ItemPropertyType
     * @uses ItemPropertyType::setID()
     * @uses ItemPropertyType::setName()
     * @uses ItemPropertyType::setNameCode()
     * @uses ItemPropertyType::setTestMethod()
     * @uses ItemPropertyType::setValue()
     * @uses ItemPropertyType::setValueQuantity()
     * @uses ItemPropertyType::setValueQualifier()
     * @uses ItemPropertyType::setImportanceCode()
     * @uses ItemPropertyType::setListValue()
     * @uses ItemPropertyType::setUsabilityPeriod()
     * @uses ItemPropertyType::setItemPropertyGroup()
     * @uses ItemPropertyType::setRangeDimension()
     * @uses ItemPropertyType::setItemPropertyRange()
     * @param \Mnm\StructType\IDType $iD
     * @param \Mnm\StructType\NameType $name
     * @param \Mnm\StructType\NameCodeType $nameCode
     * @param \Mnm\StructType\TestMethodType $testMethod
     * @param \Mnm\StructType\ValueType $value
     * @param \Mnm\StructType\ValueQuantityType $valueQuantity
     * @param \Mnm\StructType\ValueQualifierType[] $valueQualifier
     * @param \Mnm\StructType\ImportanceCodeType $importanceCode
     * @param \Mnm\StructType\ListValueType[] $listValue
     * @param \Mnm\StructType\PeriodType $usabilityPeriod
     * @param \Mnm\StructType\ItemPropertyGroupType[] $itemPropertyGroup
     * @param \Mnm\StructType\DimensionType $rangeDimension
     * @param \Mnm\StructType\ItemPropertyRangeType $itemPropertyRange
     */
    public function __construct(\Mnm\StructType\IDType $iD = null, \Mnm\StructType\NameType $name = null, \Mnm\StructType\NameCodeType $nameCode = null, \Mnm\StructType\TestMethodType $testMethod = null, \Mnm\StructType\ValueType $value = null, \Mnm\StructType\ValueQuantityType $valueQuantity = null, array $valueQualifier = array(), \Mnm\StructType\ImportanceCodeType $importanceCode = null, array $listValue = array(), \Mnm\StructType\PeriodType $usabilityPeriod = null, array $itemPropertyGroup = array(), \Mnm\StructType\DimensionType $rangeDimension = null, \Mnm\StructType\ItemPropertyRangeType $itemPropertyRange = null)
    {
        $this
            ->setID($iD)
            ->setName($name)
            ->setNameCode($nameCode)
            ->setTestMethod($testMethod)
            ->setValue($value)
            ->setValueQuantity($valueQuantity)
            ->setValueQualifier($valueQualifier)
            ->setImportanceCode($importanceCode)
            ->setListValue($listValue)
            ->setUsabilityPeriod($usabilityPeriod)
            ->setItemPropertyGroup($itemPropertyGroup)
            ->setRangeDimension($rangeDimension)
            ->setItemPropertyRange($itemPropertyRange);
    }
    /**
     * Get ID value
     * @return \Mnm\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\StructType\IDType $iD
     * @return \Mnm\StructType\ItemPropertyType
     */
    public function setID(\Mnm\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Name value
     * @return \Mnm\StructType\NameType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \Mnm\StructType\NameType $name
     * @return \Mnm\StructType\ItemPropertyType
     */
    public function setName(\Mnm\StructType\NameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get NameCode value
     * @return \Mnm\StructType\NameCodeType|null
     */
    public function getNameCode()
    {
        return $this->NameCode;
    }
    /**
     * Set NameCode value
     * @param \Mnm\StructType\NameCodeType $nameCode
     * @return \Mnm\StructType\ItemPropertyType
     */
    public function setNameCode(\Mnm\StructType\NameCodeType $nameCode = null)
    {
        $this->NameCode = $nameCode;
        return $this;
    }
    /**
     * Get TestMethod value
     * @return \Mnm\StructType\TestMethodType|null
     */
    public function getTestMethod()
    {
        return $this->TestMethod;
    }
    /**
     * Set TestMethod value
     * @param \Mnm\StructType\TestMethodType $testMethod
     * @return \Mnm\StructType\ItemPropertyType
     */
    public function setTestMethod(\Mnm\StructType\TestMethodType $testMethod = null)
    {
        $this->TestMethod = $testMethod;
        return $this;
    }
    /**
     * Get Value value
     * @return \Mnm\StructType\ValueType|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param \Mnm\StructType\ValueType $value
     * @return \Mnm\StructType\ItemPropertyType
     */
    public function setValue(\Mnm\StructType\ValueType $value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Get ValueQuantity value
     * @return \Mnm\StructType\ValueQuantityType|null
     */
    public function getValueQuantity()
    {
        return $this->ValueQuantity;
    }
    /**
     * Set ValueQuantity value
     * @param \Mnm\StructType\ValueQuantityType $valueQuantity
     * @return \Mnm\StructType\ItemPropertyType
     */
    public function setValueQuantity(\Mnm\StructType\ValueQuantityType $valueQuantity = null)
    {
        $this->ValueQuantity = $valueQuantity;
        return $this;
    }
    /**
     * Get ValueQualifier value
     * @return \Mnm\StructType\ValueQualifierType[]|null
     */
    public function getValueQualifier()
    {
        return $this->ValueQualifier;
    }
    /**
     * Set ValueQualifier value
     * @param \Mnm\StructType\ValueQualifierType[] $valueQualifier
     * @return \Mnm\StructType\ItemPropertyType
     */
    public function setValueQualifier(array $valueQualifier = array())
    {
        $this->ValueQualifier = $valueQualifier;
        return $this;
    }
    /**
     * Add item to ValueQualifier value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\ValueQualifierType $item
     * @return \Mnm\StructType\ItemPropertyType
     */
    public function addToValueQualifier(\Mnm\StructType\ValueQualifierType $item)
    {
        $this->ValueQualifier[] = $item;
        return $this;
    }
    /**
     * Get ImportanceCode value
     * @return \Mnm\StructType\ImportanceCodeType|null
     */
    public function getImportanceCode()
    {
        return $this->ImportanceCode;
    }
    /**
     * Set ImportanceCode value
     * @param \Mnm\StructType\ImportanceCodeType $importanceCode
     * @return \Mnm\StructType\ItemPropertyType
     */
    public function setImportanceCode(\Mnm\StructType\ImportanceCodeType $importanceCode = null)
    {
        $this->ImportanceCode = $importanceCode;
        return $this;
    }
    /**
     * Get ListValue value
     * @return \Mnm\StructType\ListValueType[]|null
     */
    public function getListValue()
    {
        return $this->ListValue;
    }
    /**
     * Set ListValue value
     * @param \Mnm\StructType\ListValueType[] $listValue
     * @return \Mnm\StructType\ItemPropertyType
     */
    public function setListValue(array $listValue = array())
    {
        $this->ListValue = $listValue;
        return $this;
    }
    /**
     * Add item to ListValue value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\ListValueType $item
     * @return \Mnm\StructType\ItemPropertyType
     */
    public function addToListValue(\Mnm\StructType\ListValueType $item)
    {
        $this->ListValue[] = $item;
        return $this;
    }
    /**
     * Get UsabilityPeriod value
     * @return \Mnm\StructType\PeriodType|null
     */
    public function getUsabilityPeriod()
    {
        return $this->UsabilityPeriod;
    }
    /**
     * Set UsabilityPeriod value
     * @param \Mnm\StructType\PeriodType $usabilityPeriod
     * @return \Mnm\StructType\ItemPropertyType
     */
    public function setUsabilityPeriod(\Mnm\StructType\PeriodType $usabilityPeriod = null)
    {
        $this->UsabilityPeriod = $usabilityPeriod;
        return $this;
    }
    /**
     * Get ItemPropertyGroup value
     * @return \Mnm\StructType\ItemPropertyGroupType[]|null
     */
    public function getItemPropertyGroup()
    {
        return $this->ItemPropertyGroup;
    }
    /**
     * Set ItemPropertyGroup value
     * @param \Mnm\StructType\ItemPropertyGroupType[] $itemPropertyGroup
     * @return \Mnm\StructType\ItemPropertyType
     */
    public function setItemPropertyGroup(array $itemPropertyGroup = array())
    {
        $this->ItemPropertyGroup = $itemPropertyGroup;
        return $this;
    }
    /**
     * Add item to ItemPropertyGroup value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\ItemPropertyGroupType $item
     * @return \Mnm\StructType\ItemPropertyType
     */
    public function addToItemPropertyGroup(\Mnm\StructType\ItemPropertyGroupType $item)
    {
        $this->ItemPropertyGroup[] = $item;
        return $this;
    }
    /**
     * Get RangeDimension value
     * @return \Mnm\StructType\DimensionType|null
     */
    public function getRangeDimension()
    {
        return $this->RangeDimension;
    }
    /**
     * Set RangeDimension value
     * @param \Mnm\StructType\DimensionType $rangeDimension
     * @return \Mnm\StructType\ItemPropertyType
     */
    public function setRangeDimension(\Mnm\StructType\DimensionType $rangeDimension = null)
    {
        $this->RangeDimension = $rangeDimension;
        return $this;
    }
    /**
     * Get ItemPropertyRange value
     * @return \Mnm\StructType\ItemPropertyRangeType|null
     */
    public function getItemPropertyRange()
    {
        return $this->ItemPropertyRange;
    }
    /**
     * Set ItemPropertyRange value
     * @param \Mnm\StructType\ItemPropertyRangeType $itemPropertyRange
     * @return \Mnm\StructType\ItemPropertyType
     */
    public function setItemPropertyRange(\Mnm\StructType\ItemPropertyRangeType $itemPropertyRange = null)
    {
        $this->ItemPropertyRange = $itemPropertyRange;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\ItemPropertyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
