<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemInstanceType StructType
 * @subpackage Structs
 */
class ItemInstanceType extends AbstractStructBase
{
    /**
     * The ProductTraceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q140:ProductTraceID
     * @var \Mnm\StructType\ProductTraceIDType
     */
    public $ProductTraceID;
    /**
     * The ManufactureDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q141:ManufactureDate
     * @var \Mnm\StructType\ManufactureDateType
     */
    public $ManufactureDate;
    /**
     * The ManufactureTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q142:ManufactureTime
     * @var \Mnm\StructType\ManufactureTimeType
     */
    public $ManufactureTime;
    /**
     * The BestBeforeDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q143:BestBeforeDate
     * @var \Mnm\StructType\BestBeforeDateType
     */
    public $BestBeforeDate;
    /**
     * The RegistrationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q144:RegistrationID
     * @var \Mnm\StructType\RegistrationIDType
     */
    public $RegistrationID;
    /**
     * The SerialID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q145:SerialID
     * @var \Mnm\StructType\SerialIDType
     */
    public $SerialID;
    /**
     * The AdditionalItemProperty
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\ItemPropertyType[]
     */
    public $AdditionalItemProperty;
    /**
     * The LotIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\LotIdentificationType
     */
    public $LotIdentification;
    /**
     * Constructor method for ItemInstanceType
     * @uses ItemInstanceType::setProductTraceID()
     * @uses ItemInstanceType::setManufactureDate()
     * @uses ItemInstanceType::setManufactureTime()
     * @uses ItemInstanceType::setBestBeforeDate()
     * @uses ItemInstanceType::setRegistrationID()
     * @uses ItemInstanceType::setSerialID()
     * @uses ItemInstanceType::setAdditionalItemProperty()
     * @uses ItemInstanceType::setLotIdentification()
     * @param \Mnm\StructType\ProductTraceIDType $productTraceID
     * @param \Mnm\StructType\ManufactureDateType $manufactureDate
     * @param \Mnm\StructType\ManufactureTimeType $manufactureTime
     * @param \Mnm\StructType\BestBeforeDateType $bestBeforeDate
     * @param \Mnm\StructType\RegistrationIDType $registrationID
     * @param \Mnm\StructType\SerialIDType $serialID
     * @param \Mnm\StructType\ItemPropertyType[] $additionalItemProperty
     * @param \Mnm\StructType\LotIdentificationType $lotIdentification
     */
    public function __construct(\Mnm\StructType\ProductTraceIDType $productTraceID = null, \Mnm\StructType\ManufactureDateType $manufactureDate = null, \Mnm\StructType\ManufactureTimeType $manufactureTime = null, \Mnm\StructType\BestBeforeDateType $bestBeforeDate = null, \Mnm\StructType\RegistrationIDType $registrationID = null, \Mnm\StructType\SerialIDType $serialID = null, array $additionalItemProperty = array(), \Mnm\StructType\LotIdentificationType $lotIdentification = null)
    {
        $this
            ->setProductTraceID($productTraceID)
            ->setManufactureDate($manufactureDate)
            ->setManufactureTime($manufactureTime)
            ->setBestBeforeDate($bestBeforeDate)
            ->setRegistrationID($registrationID)
            ->setSerialID($serialID)
            ->setAdditionalItemProperty($additionalItemProperty)
            ->setLotIdentification($lotIdentification);
    }
    /**
     * Get ProductTraceID value
     * @return \Mnm\StructType\ProductTraceIDType|null
     */
    public function getProductTraceID()
    {
        return $this->ProductTraceID;
    }
    /**
     * Set ProductTraceID value
     * @param \Mnm\StructType\ProductTraceIDType $productTraceID
     * @return \Mnm\StructType\ItemInstanceType
     */
    public function setProductTraceID(\Mnm\StructType\ProductTraceIDType $productTraceID = null)
    {
        $this->ProductTraceID = $productTraceID;
        return $this;
    }
    /**
     * Get ManufactureDate value
     * @return \Mnm\StructType\ManufactureDateType|null
     */
    public function getManufactureDate()
    {
        return $this->ManufactureDate;
    }
    /**
     * Set ManufactureDate value
     * @param \Mnm\StructType\ManufactureDateType $manufactureDate
     * @return \Mnm\StructType\ItemInstanceType
     */
    public function setManufactureDate(\Mnm\StructType\ManufactureDateType $manufactureDate = null)
    {
        $this->ManufactureDate = $manufactureDate;
        return $this;
    }
    /**
     * Get ManufactureTime value
     * @return \Mnm\StructType\ManufactureTimeType|null
     */
    public function getManufactureTime()
    {
        return $this->ManufactureTime;
    }
    /**
     * Set ManufactureTime value
     * @param \Mnm\StructType\ManufactureTimeType $manufactureTime
     * @return \Mnm\StructType\ItemInstanceType
     */
    public function setManufactureTime(\Mnm\StructType\ManufactureTimeType $manufactureTime = null)
    {
        $this->ManufactureTime = $manufactureTime;
        return $this;
    }
    /**
     * Get BestBeforeDate value
     * @return \Mnm\StructType\BestBeforeDateType|null
     */
    public function getBestBeforeDate()
    {
        return $this->BestBeforeDate;
    }
    /**
     * Set BestBeforeDate value
     * @param \Mnm\StructType\BestBeforeDateType $bestBeforeDate
     * @return \Mnm\StructType\ItemInstanceType
     */
    public function setBestBeforeDate(\Mnm\StructType\BestBeforeDateType $bestBeforeDate = null)
    {
        $this->BestBeforeDate = $bestBeforeDate;
        return $this;
    }
    /**
     * Get RegistrationID value
     * @return \Mnm\StructType\RegistrationIDType|null
     */
    public function getRegistrationID()
    {
        return $this->RegistrationID;
    }
    /**
     * Set RegistrationID value
     * @param \Mnm\StructType\RegistrationIDType $registrationID
     * @return \Mnm\StructType\ItemInstanceType
     */
    public function setRegistrationID(\Mnm\StructType\RegistrationIDType $registrationID = null)
    {
        $this->RegistrationID = $registrationID;
        return $this;
    }
    /**
     * Get SerialID value
     * @return \Mnm\StructType\SerialIDType|null
     */
    public function getSerialID()
    {
        return $this->SerialID;
    }
    /**
     * Set SerialID value
     * @param \Mnm\StructType\SerialIDType $serialID
     * @return \Mnm\StructType\ItemInstanceType
     */
    public function setSerialID(\Mnm\StructType\SerialIDType $serialID = null)
    {
        $this->SerialID = $serialID;
        return $this;
    }
    /**
     * Get AdditionalItemProperty value
     * @return \Mnm\StructType\ItemPropertyType[]|null
     */
    public function getAdditionalItemProperty()
    {
        return $this->AdditionalItemProperty;
    }
    /**
     * Set AdditionalItemProperty value
     * @param \Mnm\StructType\ItemPropertyType[] $additionalItemProperty
     * @return \Mnm\StructType\ItemInstanceType
     */
    public function setAdditionalItemProperty(array $additionalItemProperty = array())
    {
        $this->AdditionalItemProperty = $additionalItemProperty;
        return $this;
    }
    /**
     * Add item to AdditionalItemProperty value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\ItemPropertyType $item
     * @return \Mnm\StructType\ItemInstanceType
     */
    public function addToAdditionalItemProperty(\Mnm\StructType\ItemPropertyType $item)
    {
        $this->AdditionalItemProperty[] = $item;
        return $this;
    }
    /**
     * Get LotIdentification value
     * @return \Mnm\StructType\LotIdentificationType|null
     */
    public function getLotIdentification()
    {
        return $this->LotIdentification;
    }
    /**
     * Set LotIdentification value
     * @param \Mnm\StructType\LotIdentificationType $lotIdentification
     * @return \Mnm\StructType\ItemInstanceType
     */
    public function setLotIdentification(\Mnm\StructType\LotIdentificationType $lotIdentification = null)
    {
        $this->LotIdentification = $lotIdentification;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\ItemInstanceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
