<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceListQueryModel StructType
 * @subpackage Structs
 */
class InvoiceListQueryModel extends PagedQueryContext
{
    /**
     * The ExecutionStartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExecutionStartDate;
    /**
     * The ExecutionEndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExecutionEndDate;
    /**
     * The CreateStartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CreateStartDate;
    /**
     * The CreateEndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CreateEndDate;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The SortColumn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SortColumn;
    /**
     * The SortMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SortMode;
    /**
     * The InvoiceIds
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $InvoiceIds;
    /**
     * The InvoiceNumbers
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $InvoiceNumbers;
    /**
     * The StatusInList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $StatusInList;
    /**
     * The StatusNotInList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $StatusNotInList;
    /**
     * Constructor method for InvoiceListQueryModel
     * @uses InvoiceListQueryModel::setExecutionStartDate()
     * @uses InvoiceListQueryModel::setExecutionEndDate()
     * @uses InvoiceListQueryModel::setCreateStartDate()
     * @uses InvoiceListQueryModel::setCreateEndDate()
     * @uses InvoiceListQueryModel::setStatus()
     * @uses InvoiceListQueryModel::setSortColumn()
     * @uses InvoiceListQueryModel::setSortMode()
     * @uses InvoiceListQueryModel::setInvoiceIds()
     * @uses InvoiceListQueryModel::setInvoiceNumbers()
     * @uses InvoiceListQueryModel::setStatusInList()
     * @uses InvoiceListQueryModel::setStatusNotInList()
     * @param string $executionStartDate
     * @param string $executionEndDate
     * @param string $createStartDate
     * @param string $createEndDate
     * @param string $status
     * @param string $sortColumn
     * @param string $sortMode
     * @param string[] $invoiceIds
     * @param string[] $invoiceNumbers
     * @param string[] $statusInList
     * @param string[] $statusNotInList
     */
    public function __construct($executionStartDate = null, $executionEndDate = null, $createStartDate = null, $createEndDate = null, $status = null, $sortColumn = null, $sortMode = null, array $invoiceIds = array(), array $invoiceNumbers = array(), array $statusInList = array(), array $statusNotInList = array())
    {
        $this
            ->setExecutionStartDate($executionStartDate)
            ->setExecutionEndDate($executionEndDate)
            ->setCreateStartDate($createStartDate)
            ->setCreateEndDate($createEndDate)
            ->setStatus($status)
            ->setSortColumn($sortColumn)
            ->setSortMode($sortMode)
            ->setInvoiceIds($invoiceIds)
            ->setInvoiceNumbers($invoiceNumbers)
            ->setStatusInList($statusInList)
            ->setStatusNotInList($statusNotInList);
    }
    /**
     * Get ExecutionStartDate value
     * @return string
     */
    public function getExecutionStartDate()
    {
        return $this->ExecutionStartDate;
    }
    /**
     * Set ExecutionStartDate value
     * @param string $executionStartDate
     * @return \Mnm\StructType\InvoiceListQueryModel
     */
    public function setExecutionStartDate($executionStartDate = null)
    {
        $this->ExecutionStartDate = $executionStartDate;
        return $this;
    }
    /**
     * Get ExecutionEndDate value
     * @return string
     */
    public function getExecutionEndDate()
    {
        return $this->ExecutionEndDate;
    }
    /**
     * Set ExecutionEndDate value
     * @param string $executionEndDate
     * @return \Mnm\StructType\InvoiceListQueryModel
     */
    public function setExecutionEndDate($executionEndDate = null)
    {
        $this->ExecutionEndDate = $executionEndDate;
        return $this;
    }
    /**
     * Get CreateStartDate value
     * @return string
     */
    public function getCreateStartDate()
    {
        return $this->CreateStartDate;
    }
    /**
     * Set CreateStartDate value
     * @param string $createStartDate
     * @return \Mnm\StructType\InvoiceListQueryModel
     */
    public function setCreateStartDate($createStartDate = null)
    {
        $this->CreateStartDate = $createStartDate;
        return $this;
    }
    /**
     * Get CreateEndDate value
     * @return string
     */
    public function getCreateEndDate()
    {
        return $this->CreateEndDate;
    }
    /**
     * Set CreateEndDate value
     * @param string $createEndDate
     * @return \Mnm\StructType\InvoiceListQueryModel
     */
    public function setCreateEndDate($createEndDate = null)
    {
        $this->CreateEndDate = $createEndDate;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Mnm\StructType\InvoiceListQueryModel
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get SortColumn value
     * @return string
     */
    public function getSortColumn()
    {
        return $this->SortColumn;
    }
    /**
     * Set SortColumn value
     * @param string $sortColumn
     * @return \Mnm\StructType\InvoiceListQueryModel
     */
    public function setSortColumn($sortColumn = null)
    {
        $this->SortColumn = $sortColumn;
        return $this;
    }
    /**
     * Get SortMode value
     * @return string
     */
    public function getSortMode()
    {
        return $this->SortMode;
    }
    /**
     * Set SortMode value
     * @param string $sortMode
     * @return \Mnm\StructType\InvoiceListQueryModel
     */
    public function setSortMode($sortMode = null)
    {
        $this->SortMode = $sortMode;
        return $this;
    }
    /**
     * Get InvoiceIds value
     * @return string[]|null
     */
    public function getInvoiceIds()
    {
        return $this->InvoiceIds;
    }
    /**
     * Set InvoiceIds value
     * @param string[] $invoiceIds
     * @return \Mnm\StructType\InvoiceListQueryModel
     */
    public function setInvoiceIds(array $invoiceIds = array())
    {
        $this->InvoiceIds = $invoiceIds;
        return $this;
    }
    /**
     * Add item to InvoiceIds value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Mnm\StructType\InvoiceListQueryModel
     */
    public function addToInvoiceIds($item)
    {
        $this->InvoiceIds[] = $item;
        return $this;
    }
    /**
     * Get InvoiceNumbers value
     * @return string[]|null
     */
    public function getInvoiceNumbers()
    {
        return $this->InvoiceNumbers;
    }
    /**
     * Set InvoiceNumbers value
     * @param string[] $invoiceNumbers
     * @return \Mnm\StructType\InvoiceListQueryModel
     */
    public function setInvoiceNumbers(array $invoiceNumbers = array())
    {
        $this->InvoiceNumbers = $invoiceNumbers;
        return $this;
    }
    /**
     * Add item to InvoiceNumbers value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Mnm\StructType\InvoiceListQueryModel
     */
    public function addToInvoiceNumbers($item)
    {
        $this->InvoiceNumbers[] = $item;
        return $this;
    }
    /**
     * Get StatusInList value
     * @return string[]|null
     */
    public function getStatusInList()
    {
        return $this->StatusInList;
    }
    /**
     * Set StatusInList value
     * @param string[] $statusInList
     * @return \Mnm\StructType\InvoiceListQueryModel
     */
    public function setStatusInList(array $statusInList = array())
    {
        $this->StatusInList = $statusInList;
        return $this;
    }
    /**
     * Add item to StatusInList value
     * @uses \Mnm\EnumType\InvoiceStatus::valueIsValid()
     * @uses \Mnm\EnumType\InvoiceStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Mnm\StructType\InvoiceListQueryModel
     */
    public function addToStatusInList($item)
    {
        $this->StatusInList[] = $item;
        return $this;
    }
    /**
     * Get StatusNotInList value
     * @return string[]|null
     */
    public function getStatusNotInList()
    {
        return $this->StatusNotInList;
    }
    /**
     * Set StatusNotInList value
     * @param string[] $statusNotInList
     * @return \Mnm\StructType\InvoiceListQueryModel
     */
    public function setStatusNotInList(array $statusNotInList = array())
    {
        $this->StatusNotInList = $statusNotInList;
        return $this;
    }
    /**
     * Add item to StatusNotInList value
     * @uses \Mnm\EnumType\InvoiceStatus::valueIsValid()
     * @uses \Mnm\EnumType\InvoiceStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Mnm\StructType\InvoiceListQueryModel
     */
    public function addToStatusNotInList($item)
    {
        $this->StatusNotInList[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\InvoiceListQueryModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
