<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceInfo StructType
 * @subpackage Structs
 */
class InvoiceInfo extends AbstractStructBase
{
    /**
     * The Scenario
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Scenario;
    /**
     * The CreateDateUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDateUtc;
    /**
     * The Invoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\InvoiceType
     */
    public $Invoice;
    /**
     * The TargetCustomer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\CustomerInfo
     */
    public $TargetCustomer;
    /**
     * The EArchiveInvoiceInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\EArchiveInvoiceInformation
     */
    public $EArchiveInvoiceInfo;
    /**
     * The Notification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\NotificationInformation
     */
    public $Notification;
    /**
     * The LocalDocumentId
     * @var string
     */
    public $LocalDocumentId;
    /**
     * The ExtraInformation
     * @var string
     */
    public $ExtraInformation;
    /**
     * Constructor method for InvoiceInfo
     * @uses InvoiceInfo::setScenario()
     * @uses InvoiceInfo::setCreateDateUtc()
     * @uses InvoiceInfo::setInvoice()
     * @uses InvoiceInfo::setTargetCustomer()
     * @uses InvoiceInfo::setEArchiveInvoiceInfo()
     * @uses InvoiceInfo::setNotification()
     * @uses InvoiceInfo::setLocalDocumentId()
     * @uses InvoiceInfo::setExtraInformation()
     * @param string $scenario
     * @param string $createDateUtc
     * @param \Mnm\StructType\InvoiceType $invoice
     * @param \Mnm\StructType\CustomerInfo $targetCustomer
     * @param \Mnm\StructType\EArchiveInvoiceInformation $eArchiveInvoiceInfo
     * @param \Mnm\StructType\NotificationInformation $notification
     * @param string $localDocumentId
     * @param string $extraInformation
     */
    public function __construct($scenario = null, $createDateUtc = null, \Mnm\StructType\InvoiceType $invoice = null, \Mnm\StructType\CustomerInfo $targetCustomer = null, \Mnm\StructType\EArchiveInvoiceInformation $eArchiveInvoiceInfo = null, \Mnm\StructType\NotificationInformation $notification = null, $localDocumentId = null, $extraInformation = null)
    {
        $this
            ->setScenario($scenario)
            ->setCreateDateUtc($createDateUtc)
            ->setInvoice($invoice)
            ->setTargetCustomer($targetCustomer)
            ->setEArchiveInvoiceInfo($eArchiveInvoiceInfo)
            ->setNotification($notification)
            ->setLocalDocumentId($localDocumentId)
            ->setExtraInformation($extraInformation);
    }
    /**
     * Get Scenario value
     * @return string
     */
    public function getScenario()
    {
        return $this->Scenario;
    }
    /**
     * Set Scenario value
     * @param string $scenario
     * @return \Mnm\StructType\InvoiceInfo
     */
    public function setScenario($scenario = null)
    {
        $this->Scenario = $scenario;
        return $this;
    }
    /**
     * Get CreateDateUtc value
     * @return string
     */
    public function getCreateDateUtc()
    {
        return $this->CreateDateUtc;
    }
    /**
     * Set CreateDateUtc value
     * @param string $createDateUtc
     * @return \Mnm\StructType\InvoiceInfo
     */
    public function setCreateDateUtc($createDateUtc = null)
    {
        $this->CreateDateUtc = $createDateUtc;
        return $this;
    }
    /**
     * Get Invoice value
     * @return \Mnm\StructType\InvoiceType|null
     */
    public function getInvoice()
    {
        return $this->Invoice;
    }
    /**
     * Set Invoice value
     * @param \Mnm\StructType\InvoiceType $invoice
     * @return \Mnm\StructType\InvoiceInfo
     */
    public function setInvoice(\Mnm\StructType\InvoiceType $invoice = null)
    {
        $this->Invoice = $invoice;
        return $this;
    }
    /**
     * Get TargetCustomer value
     * @return \Mnm\StructType\CustomerInfo|null
     */
    public function getTargetCustomer()
    {
        return $this->TargetCustomer;
    }
    /**
     * Set TargetCustomer value
     * @param \Mnm\StructType\CustomerInfo $targetCustomer
     * @return \Mnm\StructType\InvoiceInfo
     */
    public function setTargetCustomer(\Mnm\StructType\CustomerInfo $targetCustomer = null)
    {
        $this->TargetCustomer = $targetCustomer;
        return $this;
    }
    /**
     * Get EArchiveInvoiceInfo value
     * @return \Mnm\StructType\EArchiveInvoiceInformation|null
     */
    public function getEArchiveInvoiceInfo()
    {
        return $this->EArchiveInvoiceInfo;
    }
    /**
     * Set EArchiveInvoiceInfo value
     * @param \Mnm\StructType\EArchiveInvoiceInformation $eArchiveInvoiceInfo
     * @return \Mnm\StructType\InvoiceInfo
     */
    public function setEArchiveInvoiceInfo(\Mnm\StructType\EArchiveInvoiceInformation $eArchiveInvoiceInfo = null)
    {
        $this->EArchiveInvoiceInfo = $eArchiveInvoiceInfo;
        return $this;
    }
    /**
     * Get Notification value
     * @return \Mnm\StructType\NotificationInformation|null
     */
    public function getNotification()
    {
        return $this->Notification;
    }
    /**
     * Set Notification value
     * @param \Mnm\StructType\NotificationInformation $notification
     * @return \Mnm\StructType\InvoiceInfo
     */
    public function setNotification(\Mnm\StructType\NotificationInformation $notification = null)
    {
        $this->Notification = $notification;
        return $this;
    }
    /**
     * Get LocalDocumentId value
     * @return string|null
     */
    public function getLocalDocumentId()
    {
        return $this->LocalDocumentId;
    }
    /**
     * Set LocalDocumentId value
     * @param string $localDocumentId
     * @return \Mnm\StructType\InvoiceInfo
     */
    public function setLocalDocumentId($localDocumentId = null)
    {
        $this->LocalDocumentId = $localDocumentId;
        return $this;
    }
    /**
     * Get ExtraInformation value
     * @return string|null
     */
    public function getExtraInformation()
    {
        return $this->ExtraInformation;
    }
    /**
     * Set ExtraInformation value
     * @param string $extraInformation
     * @return \Mnm\StructType\InvoiceInfo
     */
    public function setExtraInformation($extraInformation = null)
    {
        $this->ExtraInformation = $extraInformation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\InvoiceInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
