<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceExportGtbInformation StructType
 * @subpackage Structs
 */
class InvoiceExportGtbInformation extends AbstractStructBase
{
    /**
     * The RealExportDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $RealExportDate;
    /**
     * The DocumentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentId;
    /**
     * The RefNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RefNo;
    /**
     * The GcbRegistrationNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GcbRegistrationNo;
    /**
     * Constructor method for InvoiceExportGtbInformation
     * @uses InvoiceExportGtbInformation::setRealExportDate()
     * @uses InvoiceExportGtbInformation::setDocumentId()
     * @uses InvoiceExportGtbInformation::setRefNo()
     * @uses InvoiceExportGtbInformation::setGcbRegistrationNo()
     * @param string $realExportDate
     * @param string $documentId
     * @param string $refNo
     * @param string $gcbRegistrationNo
     */
    public function __construct($realExportDate = null, $documentId = null, $refNo = null, $gcbRegistrationNo = null)
    {
        $this
            ->setRealExportDate($realExportDate)
            ->setDocumentId($documentId)
            ->setRefNo($refNo)
            ->setGcbRegistrationNo($gcbRegistrationNo);
    }
    /**
     * Get RealExportDate value
     * @return string
     */
    public function getRealExportDate()
    {
        return $this->RealExportDate;
    }
    /**
     * Set RealExportDate value
     * @param string $realExportDate
     * @return \Mnm\StructType\InvoiceExportGtbInformation
     */
    public function setRealExportDate($realExportDate = null)
    {
        $this->RealExportDate = $realExportDate;
        return $this;
    }
    /**
     * Get DocumentId value
     * @return string|null
     */
    public function getDocumentId()
    {
        return $this->DocumentId;
    }
    /**
     * Set DocumentId value
     * @param string $documentId
     * @return \Mnm\StructType\InvoiceExportGtbInformation
     */
    public function setDocumentId($documentId = null)
    {
        $this->DocumentId = $documentId;
        return $this;
    }
    /**
     * Get RefNo value
     * @return string|null
     */
    public function getRefNo()
    {
        return $this->RefNo;
    }
    /**
     * Set RefNo value
     * @param string $refNo
     * @return \Mnm\StructType\InvoiceExportGtbInformation
     */
    public function setRefNo($refNo = null)
    {
        $this->RefNo = $refNo;
        return $this;
    }
    /**
     * Get GcbRegistrationNo value
     * @return string|null
     */
    public function getGcbRegistrationNo()
    {
        return $this->GcbRegistrationNo;
    }
    /**
     * Set GcbRegistrationNo value
     * @param string $gcbRegistrationNo
     * @return \Mnm\StructType\InvoiceExportGtbInformation
     */
    public function setGcbRegistrationNo($gcbRegistrationNo = null)
    {
        $this->GcbRegistrationNo = $gcbRegistrationNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\InvoiceExportGtbInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
